/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.RedisAcceptableUsagePolicyRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.aup.AcceptableUsagePolicyProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration(value="casAcceptableUsagePolicyRedisConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(prefix="cas.acceptableUsagePolicy", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CasAcceptableUsagePolicyRedisConfiguration {
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"redisAcceptableUsagePolicyTemplate"})
    public RedisTemplate redisAcceptableUsagePolicyTemplate() {
        return RedisObjectFactory.newRedisTemplate((RedisConnectionFactory)this.redisAcceptableUsagePolicyConnectionFactory());
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisAcceptableUsagePolicyConnectionFactory"})
    public RedisConnectionFactory redisAcceptableUsagePolicyConnectionFactory() {
        AcceptableUsagePolicyProperties.Redis redis = this.casProperties.getAcceptableUsagePolicy().getRedis();
        return RedisObjectFactory.newRedisConnectionFactory((BaseRedisProperties)redis);
    }

    @RefreshScope
    @Bean
    public AcceptableUsagePolicyRepository acceptableUsagePolicyRepository() {
        return new RedisAcceptableUsagePolicyRepository((TicketRegistrySupport)this.ticketRegistrySupport.getObject(), this.casProperties.getAcceptableUsagePolicy(), this.redisAcceptableUsagePolicyTemplate());
    }
}

