/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import lombok.Generated;
import org.apereo.cas.aup.AbstractPrincipalAttributeAcceptableUsagePolicyRepository;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.webflow.execution.RequestContext;

public class RedisAcceptableUsagePolicyRepository
extends AbstractPrincipalAttributeAcceptableUsagePolicyRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisAcceptableUsagePolicyRepository.class);
    public static final String CAS_AUP_PREFIX = RedisAcceptableUsagePolicyRepository.class.getSimpleName() + ":";
    private static final long serialVersionUID = 1600024683199961892L;
    private final transient RedisTemplate redisTemplate;

    public RedisAcceptableUsagePolicyRepository(TicketRegistrySupport ticketRegistrySupport, String aupAttributeName, RedisTemplate redisTemplate) {
        super(ticketRegistrySupport, aupAttributeName);
        this.redisTemplate = redisTemplate;
    }

    public boolean submit(RequestContext requestContext, Credential credential) {
        try {
            String redisKey = CAS_AUP_PREFIX + credential.getId() + ":" + this.aupAttributeName;
            this.redisTemplate.boundValueOps((Object)redisKey).set((Object)Boolean.TRUE);
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

