/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Triple;
import org.apereo.cas.aup.AcceptableUsagePolicyStatus;
import org.apereo.cas.aup.BaseAcceptableUsagePolicyRepository;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.aup.AcceptableUsagePolicyProperties;
import org.apereo.cas.configuration.model.support.aup.LdapAcceptableUsagePolicyProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapConnectionFactory;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.model.TriStateBoolean;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.webflow.execution.RequestContext;

public class LdapAcceptableUsagePolicyRepository
extends BaseAcceptableUsagePolicyRepository
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAcceptableUsagePolicyRepository.class);
    private static final long serialVersionUID = 1600024683199961892L;
    private final Map<String, ConnectionFactory> connectionFactoryList;

    public LdapAcceptableUsagePolicyRepository(TicketRegistrySupport ticketRegistrySupport, AcceptableUsagePolicyProperties aupProperties, Map<String, ConnectionFactory> connectionFactoryList) {
        super(ticketRegistrySupport, aupProperties);
        this.connectionFactoryList = connectionFactoryList;
    }

    public AcceptableUsagePolicyStatus verify(RequestContext requestContext) {
        AcceptableUsagePolicyStatus status = super.verify(requestContext);
        if (status.isDenied()) {
            Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
            return this.aupProperties.getLdap().stream().sorted(Comparator.comparing(AbstractLdapProperties::getName)).map(Unchecked.function(ldap -> this.searchLdapForId((LdapAcceptableUsagePolicyProperties)ldap, principal.getId()))).filter(Optional::isPresent).findFirst().filter(Optional::isPresent).map(result -> ((SearchResponse)((Triple)result.get()).getMiddle()).getEntry()).map(entry -> {
                LdapAttribute attribute = entry.getAttribute(this.aupProperties.getCore().getAupAttributeName());
                return attribute != null && attribute.getStringValues().stream().anyMatch(value -> value.equalsIgnoreCase(this.getAcceptedAttributeValue()));
            }).map(result -> new AcceptableUsagePolicyStatus(TriStateBoolean.fromBoolean((boolean)result), status.getPrincipal())).orElseGet(() -> AcceptableUsagePolicyStatus.denied((Principal)status.getPrincipal()));
        }
        return status;
    }

    protected Optional<Triple<ConnectionFactory, SearchResponse, LdapAcceptableUsagePolicyProperties>> searchLdapForId(LdapAcceptableUsagePolicyProperties ldap, String id) throws Exception {
        FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)ldap.getSearchFilter(), (String)"user", (List)CollectionUtils.wrap((Object)id));
        LOGGER.debug("Constructed LDAP filter [{}]", (Object)filter);
        LdapConnectionFactory connectionFactory = new LdapConnectionFactory(this.connectionFactoryList.get(ldap.getLdapUrl()));
        SearchResponse response = connectionFactory.executeSearchOperation(ldap.getBaseDn(), filter, ldap.getPageSize());
        if (LdapUtils.containsResultEntry((SearchResponse)response)) {
            LOGGER.debug("LDAP query located an entry for [{}] and responded with [{}]", (Object)id, (Object)response);
            return Optional.of(Triple.of((Object)connectionFactory.getConnectionFactory(), (Object)response, (Object)ldap));
        }
        LOGGER.debug("LDAP query could not locate an entry for [{}]", (Object)id);
        return Optional.empty();
    }

    public boolean submit(RequestContext requestContext) {
        Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
        Optional<Optional> response = this.aupProperties.getLdap().stream().sorted(Comparator.comparing(AbstractLdapProperties::getName)).map(Unchecked.function(ldap -> this.searchLdapForId((LdapAcceptableUsagePolicyProperties)ldap, principal.getId()))).filter(Optional::isPresent).findFirst();
        if (response.isPresent()) {
            Triple result = (Triple)response.get().get();
            String currentDn = ((SearchResponse)result.getMiddle()).getEntry().getDn();
            LOGGER.debug("Updating [{}]", (Object)currentDn);
            Map attributes = CollectionUtils.wrap((String)this.aupProperties.getCore().getAupAttributeName(), (Object)CollectionUtils.wrapSet((Object)((LdapAcceptableUsagePolicyProperties)result.getRight()).getAupAcceptedAttributeValue()));
            LdapConnectionFactory factory = new LdapConnectionFactory((ConnectionFactory)result.getLeft());
            return factory.executeModifyOperation(currentDn, attributes);
        }
        return false;
    }

    public void destroy() {
        this.connectionFactoryList.forEach((ldap, connectionFactory) -> connectionFactory.close());
    }
}

