/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import com.unboundid.ldap.sdk.LDAPConnection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.adaptors.ldap.LdapIntegrationTestsOperations;
import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.BaseAcceptableUsagePolicyRepositoryTests;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.config.CasAcceptableUsagePolicyLdapConfiguration;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="Ldap")
@EnabledIfPortOpen(port={10389})
@Import(value={CasAcceptableUsagePolicyLdapConfiguration.class})
@TestPropertySource(properties={"cas.acceptable-usage-policy.ldap[0].ldap-url=ldap://localhost:10389", "cas.acceptable-usage-policy.ldap[0].base-dn=ou=people,dc=example,dc=org", "cas.acceptable-usage-policy.ldap[0].search-filter=cn={0}", "cas.acceptable-usage-policy.ldap[0].bind-dn=cn=Directory Manager", "cas.acceptable-usage-policy.ldap[0].bind-credential=password", "cas.acceptable-usage-policy.core.aup-attribute-name=carLicense"})
public class LdapAcceptableUsagePolicyRepositoryTests
extends BaseAcceptableUsagePolicyRepositoryTests {
    private static final String USER = RandomUtils.randomAlphabetic((int)10);
    private static final int LDAP_PORT = 10389;
    @Autowired
    @Qualifier(value="acceptableUsagePolicyRepository")
    protected AcceptableUsagePolicyRepository acceptableUsagePolicyRepository;

    @BeforeAll
    public static void bootstrap() throws Exception {
        ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)new MockHttpServletRequest()));
        LDAPConnection localhost = new LDAPConnection("localhost", 10389, "cn=Directory Manager", "password");
        try {
            String ldif = IOUtils.toString((InputStream)new ClassPathResource("ldif/ldap-aup.ldif").getInputStream(), (Charset)StandardCharsets.UTF_8).replace("$user", USER);
            LdapIntegrationTestsOperations.populateEntries((LDAPConnection)localhost, (InputStream)new ByteArrayInputStream(ldif.getBytes(StandardCharsets.UTF_8)), (String)"ou=people,dc=example,dc=org");
        }
        finally {
            if (Collections.singletonList(localhost).get(0) != null) {
                localhost.close();
            }
        }
    }

    public boolean hasLiveUpdates() {
        return true;
    }

    @Test
    public void verifyMissingUser() throws Exception {
        String actualPrincipalId = UUID.randomUUID().toString();
        UsernamePasswordCredential c = LdapAcceptableUsagePolicyRepositoryTests.getCredential((String)actualPrincipalId);
        MockRequestContext context = this.getRequestContext(actualPrincipalId, Map.of(), (Credential)c);
        Assertions.assertFalse((boolean)this.getAcceptableUsagePolicyRepository().verify((RequestContext)context).isAccepted());
    }

    @Test
    public void verifyOperation() throws Exception {
        Assertions.assertNotNull((Object)this.acceptableUsagePolicyRepository);
        this.verifyRepositoryAction(USER, CollectionUtils.wrap((String)"carLicense", List.of("false"), (String)"email", List.of("casaupldap@example.org")));
    }

    @Generated
    public AcceptableUsagePolicyRepository getAcceptableUsagePolicyRepository() {
        return this.acceptableUsagePolicyRepository;
    }
}

