/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.concurrent.ConcurrentHashMap;
import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.LdapAcceptableUsagePolicyRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.aup.AcceptableUsagePolicyProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.LdapUtils;
import org.ldaptive.ConnectionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="CasAcceptableUsagePolicyLdapConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(prefix="cas.acceptable-usage-policy.core", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CasAcceptableUsagePolicyLdapConfiguration {
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public AcceptableUsagePolicyRepository acceptableUsagePolicyRepository(CasConfigurationProperties casProperties, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport) {
        ConcurrentHashMap<String, ConnectionFactory> connectionFactoryList = new ConcurrentHashMap<String, ConnectionFactory>();
        AcceptableUsagePolicyProperties aupProperties = casProperties.getAcceptableUsagePolicy();
        aupProperties.getLdap().forEach(ldap -> connectionFactoryList.put(ldap.getLdapUrl(), LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap)));
        return new LdapAcceptableUsagePolicyRepository(ticketRegistrySupport, aupProperties, connectionFactoryList);
    }
}

