/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.aup.BaseAcceptableUsagePolicyRepository;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.model.support.aup.AcceptableUsagePolicyProperties;
import org.apereo.cas.configuration.model.support.aup.LdapAcceptableUsagePolicyProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.LoggingUtils;
import org.jooq.lambda.Unchecked;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.webflow.execution.RequestContext;

public class LdapAcceptableUsagePolicyRepository
extends BaseAcceptableUsagePolicyRepository
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAcceptableUsagePolicyRepository.class);
    private static final long serialVersionUID = 1600024683199961892L;
    private final Map<String, ConnectionFactory> connectionFactoryList;

    public LdapAcceptableUsagePolicyRepository(TicketRegistrySupport ticketRegistrySupport, AcceptableUsagePolicyProperties aupProperties, Map<String, ConnectionFactory> connectionFactoryList) {
        super(ticketRegistrySupport, aupProperties);
        this.connectionFactoryList = connectionFactoryList;
    }

    protected Optional<Pair<ConnectionFactory, SearchResponse>> searchLdapForId(LdapAcceptableUsagePolicyProperties ldap, String id) throws Exception {
        FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)ldap.getSearchFilter(), (String)"user", (List)CollectionUtils.wrap((Object)id));
        LOGGER.debug("Constructed LDAP filter [{}]", (Object)filter);
        ConnectionFactory connectionFactory = this.connectionFactoryList.get(ldap.getLdapUrl());
        SearchResponse response = LdapUtils.executeSearchOperation((ConnectionFactory)connectionFactory, (String)ldap.getBaseDn(), (FilterTemplate)filter, (int)ldap.getPageSize());
        if (LdapUtils.containsResultEntry((SearchResponse)response)) {
            LOGGER.debug("LDAP query located an entry for [{}] and responded with [{}]", (Object)id, (Object)response);
            return Optional.of(Pair.of((Object)connectionFactory, (Object)response));
        }
        LOGGER.debug("LDAP query could not locate an entry for [{}]", (Object)id);
        return Optional.empty();
    }

    public boolean submit(RequestContext requestContext, Credential credential) {
        try {
            Optional<Optional> response = this.aupProperties.getLdap().stream().sorted(Comparator.comparing(AbstractLdapProperties::getName)).map(Unchecked.function(ldap -> this.searchLdapForId((LdapAcceptableUsagePolicyProperties)ldap, credential.getId()))).filter(Optional::isPresent).findFirst();
            if (response.isPresent()) {
                Pair result = (Pair)response.get().get();
                String currentDn = ((SearchResponse)result.getValue()).getEntry().getDn();
                LOGGER.debug("Updating [{}]", (Object)currentDn);
                Map attributes = CollectionUtils.wrap((String)this.aupProperties.getAupAttributeName(), (Object)CollectionUtils.wrapSet((Object)Boolean.TRUE.toString().toUpperCase()));
                return LdapUtils.executeModifyOperation((String)currentDn, (ConnectionFactory)((ConnectionFactory)result.getKey()), (Map)attributes);
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return false;
    }

    public void destroy() {
        this.connectionFactoryList.forEach((ldap, connectionFactory) -> connectionFactory.close());
    }
}

