/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import com.unboundid.ldap.sdk.LDAPConnection;
import java.io.InputStream;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.adaptors.ldap.LdapIntegrationTestsOperations;
import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.BaseAcceptableUsagePolicyRepositoryTests;
import org.apereo.cas.config.CasAcceptableUsagePolicyLdapConfiguration;
import org.apereo.cas.util.junit.EnabledIfContinuousIntegration;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.TestPropertySource;

@Tag(value="Ldap")
@Import(value={CasAcceptableUsagePolicyLdapConfiguration.class})
@EnabledIfContinuousIntegration
@TestPropertySource(properties={"cas.acceptableUsagePolicy.ldap.ldapUrl=ldap://localhost:10389", "cas.acceptableUsagePolicy.ldap.useSsl=false", "cas.acceptableUsagePolicy.ldap.baseDn=ou=people,dc=example,dc=org", "cas.acceptableUsagePolicy.ldap.searchFilter=cn={0}", "cas.acceptableUsagePolicy.ldap.bindDn=cn=Directory Manager", "cas.acceptableUsagePolicy.ldap.bindCredential=password", "cas.acceptableUsagePolicy.aupAttributeName=carLicense"})
public class LdapAcceptableUsagePolicyRepositoryTests
extends BaseAcceptableUsagePolicyRepositoryTests {
    private static final int LDAP_PORT = 10389;
    @Autowired
    @Qualifier(value="acceptableUsagePolicyRepository")
    protected AcceptableUsagePolicyRepository acceptableUsagePolicyRepository;

    @BeforeAll
    public static void bootstrap() {
        ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)new MockHttpServletRequest()));
        LDAPConnection localhost = new LDAPConnection("localhost", 10389, "cn=Directory Manager", "password");
        try {
            LdapIntegrationTestsOperations.populateEntries((LDAPConnection)localhost, (InputStream)new ClassPathResource("ldif/ldap-aup.ldif").getInputStream(), (String)"ou=people,dc=example,dc=org");
        }
        finally {
            if (Collections.singletonList(localhost).get(0) != null) {
                localhost.close();
            }
        }
    }

    @Generated
    public AcceptableUsagePolicyRepository getAcceptableUsagePolicyRepository() {
        return this.acceptableUsagePolicyRepository;
    }
}

