/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.LdapAcceptableUsagePolicyRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.aup.AcceptableUsagePolicyProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.LdapUtils;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.pool.PooledConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casAcceptableUsagePolicyLdapConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(prefix="cas.acceptableUsagePolicy", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CasAcceptableUsagePolicyLdapConfiguration {
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    public AcceptableUsagePolicyRepository acceptableUsagePolicyRepository() {
        AcceptableUsagePolicyProperties.Ldap ldap = this.casProperties.getAcceptableUsagePolicy().getLdap();
        PooledConnectionFactory connectionFactory = LdapUtils.newLdaptivePooledConnectionFactory((AbstractLdapProperties)ldap);
        return new LdapAcceptableUsagePolicyRepository((TicketRegistrySupport)this.ticketRegistrySupport.getIfAvailable(), this.casProperties.getAcceptableUsagePolicy().getAupAttributeName(), (ConnectionFactory)connectionFactory, ldap.getSearchFilter(), ldap.getBaseDn());
    }
}

