/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.LdapAcceptableUsagePolicyRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.aup.AcceptableUsagePolicyProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.LdapUtils;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.pool.PooledConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casAcceptableUsagePolicyLdapConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(prefix="cas.acceptableUsagePolicy", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CasAcceptableUsagePolicyLdapConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasAcceptableUsagePolicyLdapConfiguration.class);
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    public AcceptableUsagePolicyRepository acceptableUsagePolicyRepository() {
        AcceptableUsagePolicyProperties.Ldap ldap = this.casProperties.getAcceptableUsagePolicy().getLdap();
        PooledConnectionFactory connectionFactory = LdapUtils.newLdaptivePooledConnectionFactory((AbstractLdapProperties)ldap);
        return new LdapAcceptableUsagePolicyRepository(this.ticketRegistrySupport, this.casProperties.getAcceptableUsagePolicy().getAupAttributeName(), (ConnectionFactory)connectionFactory, ldap.getSearchFilter(), ldap.getBaseDn());
    }
}

