/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import com.unboundid.ldap.sdk.LDAPConnection;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.adaptors.ldap.LdapIntegrationTestsOperations;
import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.category.LdapCategory;
import org.apereo.cas.config.CasAcceptableUsagePolicyLdapConfiguration;
import org.apereo.cas.config.CasAuthenticationEventExecutionPlanTestConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasDefaultServiceTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.CasRegisteredServicesTestConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.junit.ConditionalIgnore;
import org.apereo.cas.util.junit.ConditionalIgnoreRule;
import org.apereo.cas.util.junit.RunningContinuousIntegrationCondition;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.rules.SpringClassRule;
import org.springframework.test.context.junit4.rules.SpringMethodRule;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@Category(value={LdapCategory.class})
@SpringBootTest(classes={CasAcceptableUsagePolicyLdapConfiguration.class, RefreshAutoConfiguration.class, CasCoreConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreServicesConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreHttpConfiguration.class, CasCoreWebConfiguration.class, CasPersonDirectoryTestConfiguration.class, CasCoreUtilConfiguration.class, CasRegisteredServicesTestConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasAuthenticationEventExecutionPlanTestConfiguration.class, CasDefaultServiceTicketIdGeneratorsConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class})
@ConditionalIgnore(condition=RunningContinuousIntegrationCondition.class)
@TestPropertySource(locations={"classpath:/ldap-aup.properties"})
public class LdapAcceptableUsagePolicyRepositoryTests {
    @ClassRule
    public static final SpringClassRule SPRING_CLASS_RULE = new SpringClassRule();
    private static final int LDAP_PORT = 10389;
    @Rule
    public final SpringMethodRule springMethodRule = new SpringMethodRule();
    @Rule
    public final ConditionalIgnoreRule conditionalIgnoreRule = new ConditionalIgnoreRule();
    @Autowired
    @Qualifier(value="acceptableUsagePolicyRepository")
    private AcceptableUsagePolicyRepository acceptableUsagePolicyRepository;

    @Test
    public void verifyAction() {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        UsernamePasswordCredential c = CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword((String)"casaup");
        Principal pricipal = CoreAuthenticationTestUtils.getPrincipal((String)c.getId(), (Map)CollectionUtils.wrap((String)"carLicense", (Object)"false"));
        Authentication auth = CoreAuthenticationTestUtils.getAuthentication((Principal)pricipal);
        WebUtils.putAuthentication((Authentication)auth, (RequestContext)context);
        Assert.assertFalse((boolean)((Boolean)this.acceptableUsagePolicyRepository.verify((RequestContext)context, (Credential)c).getLeft()));
        Assert.assertTrue((boolean)this.acceptableUsagePolicyRepository.submit((RequestContext)context, (Credential)c));
    }

    @BeforeClass
    public static void bootstrap() {
        ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)new MockHttpServletRequest()));
        LDAPConnection localhost = new LDAPConnection("localhost", 10389, "cn=Directory Manager", "password");
        LdapIntegrationTestsOperations.populateEntries((LDAPConnection)localhost, (InputStream)new ClassPathResource("ldif/ldap-aup.ldif").getInputStream(), (String)"ou=people,dc=example,dc=org");
    }
}

