/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import java.util.List;
import java.util.Map;
import org.apereo.cas.aup.AbstractPrincipalAttributeAcceptableUsagePolicyRepository;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class LdapAcceptableUsagePolicyRepository
extends AbstractPrincipalAttributeAcceptableUsagePolicyRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAcceptableUsagePolicyRepository.class);
    private static final long serialVersionUID = 1600024683199961892L;
    private final ConnectionFactory connectionFactory;
    private final String searchFilter;
    private final String baseDn;

    public LdapAcceptableUsagePolicyRepository(TicketRegistrySupport ticketRegistrySupport, String aupAttributeName, ConnectionFactory connectionFactory, String searchFilter, String baseDn) {
        super(ticketRegistrySupport, aupAttributeName);
        this.connectionFactory = connectionFactory;
        this.searchFilter = searchFilter;
        this.baseDn = baseDn;
    }

    public boolean submit(RequestContext requestContext, Credential credential) {
        try {
            Response<SearchResult> response = this.searchForId(credential.getId());
            if (LdapUtils.containsResultEntry(response)) {
                String currentDn = ((SearchResult)response.getResult()).getEntry().getDn();
                LOGGER.debug("Updating [{}]", (Object)currentDn);
                return LdapUtils.executeModifyOperation((String)currentDn, (ConnectionFactory)this.connectionFactory, (Map)CollectionUtils.wrap((String)this.aupAttributeName, (Object)CollectionUtils.wrap((Object)Boolean.TRUE.toString())));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private Response<SearchResult> searchForId(String id) throws LdapException {
        SearchFilter filter = LdapUtils.newLdaptiveSearchFilter((String)this.searchFilter, (String)"user", (List)CollectionUtils.wrap((Object)id));
        return LdapUtils.executeSearchOperation((ConnectionFactory)this.connectionFactory, (String)this.baseDn, (SearchFilter)filter);
    }
}

