/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.JdbcAuditTrailEntityFactory;
import org.apereo.cas.audit.spi.entity.AuditTrailEntity;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.audit.AuditJdbcProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.thread.Cleanable;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.support.JdbcAuditTrailManager;
import org.apereo.inspektr.audit.support.MaxAgeWhereClauseMatchCriteria;
import org.apereo.inspektr.audit.support.WhereClauseMatchCriteria;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;

@EnableAspectJAutoProxy(proxyTargetClass=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=false)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Audit}, module="jdbc")
@AutoConfiguration
public class CasJdbcAuditAutoConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.audit.jdbc.url").evenIfMissing();

    static class JdbcAuditTrailCleaner
    implements Cleanable {
        private final AuditTrailManager jdbcAuditTrailManager;

        @Scheduled(initialDelayString="${cas.audit.jdbc.schedule.start-delay:10000}", fixedDelayString="${cas.audit.jdbc.schedule.repeat-interval:30000}")
        public void clean() {
            this.jdbcAuditTrailManager.clean();
        }

        @Generated
        public JdbcAuditTrailCleaner(AuditTrailManager jdbcAuditTrailManager) {
            this.jdbcAuditTrailManager = jdbcAuditTrailManager;
        }
    }

    @Configuration(value="CasSupportJdbcAuditDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSupportJdbcAuditDataConfiguration {
        CasSupportJdbcAuditDataConfiguration() {
        }

        @ConditionalOnMissingBean(name={"inspektrAuditTrailDataSource"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DataSource inspektrAuditTrailDataSource(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (DataSource)BeanSupplier.of(DataSource.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> JpaBeans.newDataSource((AbstractJpaProperties)casProperties.getAudit().getJdbc())).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasSupportJdbcAuditTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSupportJdbcAuditTransactionConfiguration {
        CasSupportJdbcAuditTransactionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"inspektrAuditTransactionManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager inspektrAuditTransactionManager(ConfigurableApplicationContext applicationContext, @Qualifier(value="inspektrAuditTrailDataSource") DataSource inspektrAuditTrailDataSource) {
            return (PlatformTransactionManager)BeanSupplier.of(PlatformTransactionManager.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DataSourceTransactionManager(inspektrAuditTrailDataSource)).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasSupportJdbcAuditScheduleConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSupportJdbcAuditScheduleConfiguration {
        CasSupportJdbcAuditScheduleConfiguration() {
        }

        @ConditionalOnMissingBean(name={"inspektrAuditTrailCleaner"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public Cleanable inspektrAuditTrailCleaner(ConfigurableApplicationContext applicationContext, @Qualifier(value="jdbcAuditTrailManager") AuditTrailManager jdbcAuditTrailManager) {
            return (Cleanable)BeanSupplier.of(Cleanable.class).when(BeanCondition.on((String)"cas.audit.jdbc.schedule.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new JdbcAuditTrailCleaner(jdbcAuditTrailManager)).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasSupportJdbcAuditExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSupportJdbcAuditExecutionPlanConfiguration {
        CasSupportJdbcAuditExecutionPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"jdbcAuditTrailExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailExecutionPlanConfigurer jdbcAuditTrailExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="jdbcAuditTrailManager") AuditTrailManager jdbcAuditTrailManager) {
            return (AuditTrailExecutionPlanConfigurer)BeanSupplier.of(AuditTrailExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerAuditTrailManager(jdbcAuditTrailManager)).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasSupportJdbcAuditManagerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSupportJdbcAuditManagerConfiguration {
        CasSupportJdbcAuditManagerConfiguration() {
        }

        private static String getAuditTableNameFrom(AuditJdbcProperties jdbc) {
            String tableName = "COM_AUDIT_TRAIL";
            if (StringUtils.isNotBlank((CharSequence)jdbc.getDefaultSchema())) {
                tableName = jdbc.getDefaultSchema().concat(".").concat(tableName);
            }
            if (StringUtils.isNotBlank((CharSequence)jdbc.getDefaultCatalog())) {
                tableName = jdbc.getDefaultCatalog().concat(".").concat(tableName);
            }
            return tableName;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @DependsOn(value={"inspektrAuditEntityManagerFactory"})
        public AuditTrailManager jdbcAuditTrailManager(ConfigurableApplicationContext applicationContext, @Qualifier(value="auditCleanupCriteria") WhereClauseMatchCriteria auditCleanupCriteria, @Qualifier(value="inspektrAuditTransactionTemplate") TransactionOperations inspektrAuditTransactionTemplate, @Qualifier(value="inspektrAuditTrailDataSource") DataSource inspektrAuditTrailDataSource, CasConfigurationProperties casProperties) {
            return (AuditTrailManager)BeanSupplier.of(AuditTrailManager.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                JdbcAuditTrailManager manager = new JdbcAuditTrailManager(inspektrAuditTransactionTemplate, new JdbcTemplate(inspektrAuditTrailDataSource));
                manager.setCleanupCriteria(auditCleanupCriteria);
                AuditJdbcProperties jdbc = casProperties.getAudit().getJdbc();
                manager.setAsynchronous(jdbc.isAsynchronous());
                manager.setColumnLength(jdbc.getColumnLength());
                manager.setTableName(CasSupportJdbcAuditManagerConfiguration.getAuditTableNameFrom(jdbc));
                FunctionUtils.doIfNotBlank((CharSequence)jdbc.getSelectSqlQueryTemplate(), manager::setSelectByDateSqlTemplate);
                FunctionUtils.doIfNotBlank((CharSequence)jdbc.getDateFormatterPattern(), manager::setDateFormatterPattern);
                FunctionUtils.doIfNotBlank((CharSequence)jdbc.getDateFormatterFunction(), manager::setDateFormatterFunction);
                return manager;
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasSupportJdbcAuditTransactionTemplateConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSupportJdbcAuditTransactionTemplateConfiguration {
        CasSupportJdbcAuditTransactionTemplateConfiguration() {
        }

        @ConditionalOnMissingBean(name={"inspektrAuditTransactionTemplate"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TransactionOperations inspektrAuditTransactionTemplate(ConfigurableApplicationContext applicationContext, @Qualifier(value="inspektrAuditTransactionManager") PlatformTransactionManager inspektrAuditTransactionManager, CasConfigurationProperties casProperties) {
            return (TransactionOperations)BeanSupplier.of(TransactionOperations.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                TransactionTemplate template = new TransactionTemplate(inspektrAuditTransactionManager);
                AuditJdbcProperties jdbc = casProperties.getAudit().getJdbc();
                template.setIsolationLevelName(jdbc.getIsolationLevelName());
                template.setPropagationBehaviorName(jdbc.getPropagationBehaviorName());
                return template;
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasSupportJdbcAuditEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSupportJdbcAuditEntityConfiguration {
        CasSupportJdbcAuditEntityConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public JpaVendorAdapter inspektrAuditJpaVendorAdapter(CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc());
        }

        @Bean
        @ConditionalOnMissingBean(name={"inspektrAuditEntityManagerFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FactoryBean<EntityManagerFactory> inspektrAuditEntityManagerFactory(@Qualifier(value="inspektrAuditJpaVendorAdapter") JpaVendorAdapter inspektrAuditJpaVendorAdapter, ConfigurableApplicationContext applicationContext, @Qualifier(value="inspektrAuditTrailDataSource") DataSource inspektrAuditTrailDataSource, CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            return (FactoryBean)BeanSupplier.of(FactoryBean.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
                String dialect = casProperties.getAudit().getJdbc().getDialect();
                Class<AuditTrailEntity> type = new JdbcAuditTrailEntityFactory(dialect).getType();
                JpaConfigurationContext ctx = JpaConfigurationContext.builder().jpaVendorAdapter(inspektrAuditJpaVendorAdapter).persistenceUnitName("jpaInspektrAuditContext").dataSource(inspektrAuditTrailDataSource).packagesToScan(CollectionUtils.wrapSet((Object)type.getPackage().getName())).build();
                return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)casProperties.getAudit().getJdbc());
            })).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"auditCleanupCriteria"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WhereClauseMatchCriteria auditCleanupCriteria(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (WhereClauseMatchCriteria)BeanSupplier.of(WhereClauseMatchCriteria.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new MaxAgeWhereClauseMatchCriteria(casProperties.getAudit().getJdbc().getMaxAgeDays())).otherwiseProxy().get();
        }
    }
}

