/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import java.time.Clock;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apereo.cas.audit.spi.BaseAuditConfigurationTests;
import org.apereo.cas.config.CasHibernateJpaAutoConfiguration;
import org.apereo.cas.config.CasJdbcAuditAutoConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.thread.Cleanable;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.common.web.ClientInfo;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest(classes={BaseAuditConfigurationTests.SharedTestConfiguration.class, CasJdbcAuditAutoConfiguration.class, CasHibernateJpaAutoConfiguration.class}, properties={"cas.jdbc.show-sql=true", "cas.audit.jdbc.column-length=-1", "cas.audit.jdbc.schedule.enabled=true", "cas.audit.jdbc.asynchronous=false"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="JDBC")
class CasJdbcAuditConfigurationTests
extends BaseAuditConfigurationTests {
    @Autowired
    @Qualifier(value="inspektrAuditTrailCleaner")
    private Cleanable inspektrAuditTrailCleaner;
    @Autowired
    @Qualifier(value="jdbcAuditTrailManager")
    private AuditTrailManager auditTrailManager;

    CasJdbcAuditConfigurationTests() {
    }

    @Test
    void verifyCleaner() throws Throwable {
        this.inspektrAuditTrailCleaner.clean();
    }

    @Test
    void verifyLargeResource() throws Throwable {
        HashMap headers = new HashMap();
        IntStream.rangeClosed(1, 100).forEach(i -> headers.put(i + "-" + String.valueOf(UUID.randomUUID()), RandomUtils.randomAlphanumeric((int)500)));
        ClientInfo clientInfo = new ClientInfo("1.2.3.4", "1.2.3.4", UUID.randomUUID().toString(), "London").setExtraInfo(Map.of("Hello", "World")).setHeaders(headers);
        AuditActionContext context = new AuditActionContext(UUID.randomUUID().toString(), RandomUtils.randomAlphabetic((int)10000), "TEST", "CAS", LocalDateTime.now(Clock.systemUTC()), clientInfo);
        this.getAuditTrailManager().record(context);
    }

    @Generated
    public Cleanable getInspektrAuditTrailCleaner() {
        return this.inspektrAuditTrailCleaner;
    }

    @Generated
    public AuditTrailManager getAuditTrailManager() {
        return this.auditTrailManager;
    }
}

