/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import java.time.Clock;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apereo.cas.audit.spi.BaseAuditConfigurationTests;
import org.apereo.cas.config.CasCoreAuditConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreTicketsSerializationConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasHibernateJpaConfiguration;
import org.apereo.cas.config.CasJdbcAuditConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.thread.Cleanable;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.common.web.ClientInfo;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={CasCoreAuditConfiguration.class, CasJdbcAuditConfiguration.class, CasHibernateJpaConfiguration.class, CasCoreUtilConfiguration.class, CasCoreConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketsSerializationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreServicesConfiguration.class, CasCoreWebConfiguration.class, CasCoreNotificationsConfiguration.class, AopAutoConfiguration.class, WebMvcAutoConfiguration.class, RefreshAutoConfiguration.class}, properties={"cas.jdbc.show-sql=true", "cas.audit.jdbc.column-length=-1", "cas.audit.jdbc.schedule.enabled=true", "cas.audit.jdbc.asynchronous=false"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="JDBC")
class CasJdbcAuditConfigurationTests
extends BaseAuditConfigurationTests {
    @Autowired
    @Qualifier(value="inspektrAuditTrailCleaner")
    private Cleanable inspektrAuditTrailCleaner;
    @Autowired
    @Qualifier(value="jdbcAuditTrailManager")
    private AuditTrailManager auditTrailManager;

    CasJdbcAuditConfigurationTests() {
    }

    @Test
    void verifyCleaner() throws Throwable {
        this.inspektrAuditTrailCleaner.clean();
    }

    @Test
    void verifyLargeResource() throws Throwable {
        HashMap headers = new HashMap();
        IntStream.rangeClosed(1, 100).forEach(i -> headers.put(i + "-" + String.valueOf(UUID.randomUUID()), RandomUtils.randomAlphanumeric((int)500)));
        ClientInfo clientInfo = new ClientInfo("1.2.3.4", "1.2.3.4", UUID.randomUUID().toString(), "London").setExtraInfo(Map.of("Hello", "World")).setHeaders(headers);
        AuditActionContext context = new AuditActionContext(UUID.randomUUID().toString(), RandomUtils.randomAlphabetic((int)10000), "TEST", "CAS", LocalDateTime.now(Clock.systemUTC()), clientInfo);
        this.getAuditTrailManager().record(context);
    }

    @Generated
    public Cleanable getInspektrAuditTrailCleaner() {
        return this.inspektrAuditTrailCleaner;
    }

    @Generated
    public AuditTrailManager getAuditTrailManager() {
        return this.auditTrailManager;
    }
}

