/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit.support;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.spi.AbstractAuditTrailManager;
import org.apereo.cas.util.jpa.MapToJsonAttributeConverter;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.support.NoMatchWhereClauseMatchCriteria;
import org.apereo.inspektr.audit.support.WhereClauseMatchCriteria;
import org.apereo.inspektr.common.web.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;

public class JdbcAuditTrailManager
extends AbstractAuditTrailManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcAuditTrailManager.class);
    private static final String INSERT_SQL_TEMPLATE = "INSERT INTO %s (" + Arrays.stream(AuditTableColumns.values()).map(AuditTableColumns::getColumnName).collect(Collectors.joining(",")) + ") VALUES (" + Arrays.stream(AuditTableColumns.values()).map(AuditTableColumns::getColumnName).map(name -> StringUtils.prependIfMissing((String)name, (CharSequence)":", (CharSequence[])new CharSequence[0])).collect(Collectors.joining(",")) + ")";
    private static final String DELETE_SQL_TEMPLATE = "DELETE FROM %s %s";
    private static final int DEFAULT_COLUMN_LENGTH = 512;
    @NotNull
    private final TransactionOperations transactionTemplate;
    @NotNull
    private final JdbcTemplate jdbcTemplate;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String tableName = "COM_AUDIT_TRAIL";
    private int columnLength = 512;
    private String selectByDateSqlTemplate = "SELECT * FROM %s WHERE %s ORDER BY " + AuditTableColumns.DATE.getColumnName() + " DESC";
    private String dateFormatterPattern = "yyyy-MM-dd 00:00:00.000000";
    private String dateFormatterFunction;
    private WhereClauseMatchCriteria cleanupCriteria = new NoMatchWhereClauseMatchCriteria();
    private List<String> headerNames = new ArrayList<String>();

    protected void saveAuditRecord(final AuditActionContext auditActionContext) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus __) {
                String principal = auditActionContext.getPrincipal();
                String userId = JdbcAuditTrailManager.this.columnLength <= 0 || principal.length() <= JdbcAuditTrailManager.this.columnLength ? principal : principal.substring(0, JdbcAuditTrailManager.this.columnLength);
                String resourceOperatedUpon = auditActionContext.getResourceOperatedUpon();
                String resource = JdbcAuditTrailManager.this.columnLength <= 0 || resourceOperatedUpon.length() <= JdbcAuditTrailManager.this.columnLength ? resourceOperatedUpon : resourceOperatedUpon.substring(0, JdbcAuditTrailManager.this.columnLength);
                String actionPerformed = auditActionContext.getActionPerformed();
                String action = JdbcAuditTrailManager.this.columnLength <= 0 || actionPerformed.length() <= JdbcAuditTrailManager.this.columnLength ? actionPerformed : actionPerformed.substring(0, JdbcAuditTrailManager.this.columnLength);
                String sql = String.format(INSERT_SQL_TEMPLATE, JdbcAuditTrailManager.this.tableName);
                ClientInfo clientInfo = auditActionContext.getClientInfo();
                String locale = Optional.ofNullable(clientInfo.getLocale()).map(Locale::toLanguageTag).orElseGet(Locale.US::toLanguageTag);
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                parameterMap.put(AuditTableColumns.USER.getColumnName(), userId);
                parameterMap.put(AuditTableColumns.CLIENT_IP.getColumnName(), clientInfo.getClientIpAddress());
                parameterMap.put(AuditTableColumns.SERVER_IP.getColumnName(), clientInfo.getServerIpAddress());
                parameterMap.put(AuditTableColumns.RESOURCE.getColumnName(), resource);
                parameterMap.put(AuditTableColumns.APPLIC_CD.getColumnName(), auditActionContext.getApplicationCode());
                parameterMap.put(AuditTableColumns.DATE.getColumnName(), auditActionContext.getWhenActionWasPerformed());
                parameterMap.put(AuditTableColumns.GEOLOCATION.getColumnName(), clientInfo.getGeoLocation());
                parameterMap.put(AuditTableColumns.USERAGENT.getColumnName(), clientInfo.getUserAgent());
                parameterMap.put(AuditTableColumns.LOCALE.getColumnName(), locale);
                parameterMap.put(AuditTableColumns.ACTION.getColumnName(), action);
                MapToJsonAttributeConverter converter = new MapToJsonAttributeConverter();
                parameterMap.put(AuditTableColumns.HEADERS.getColumnName(), converter.convertToDatabaseColumn(clientInfo.getHeaders()));
                parameterMap.put(AuditTableColumns.EXTRA_INFO.getColumnName(), converter.convertToDatabaseColumn(clientInfo.getExtraInfo()));
                NamedParameterJdbcTemplate namedTemplate = new NamedParameterJdbcTemplate((JdbcOperations)JdbcAuditTrailManager.this.jdbcTemplate);
                namedTemplate.update(sql, parameterMap);
            }
        });
    }

    public void clean() {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus __) {
                String sql = String.format(JdbcAuditTrailManager.DELETE_SQL_TEMPLATE, JdbcAuditTrailManager.this.tableName, JdbcAuditTrailManager.this.cleanupCriteria);
                List<?> params = JdbcAuditTrailManager.this.cleanupCriteria.getParameterValues();
                LOGGER.info("Cleaning audit records with query [{}]", (Object)sql);
                LOGGER.debug("Query parameters: " + String.valueOf(params));
                int count = JdbcAuditTrailManager.this.jdbcTemplate.update(sql, params.toArray());
                LOGGER.info("[{}] records deleted.", (Object)count);
            }
        });
    }

    public void removeAll() {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus __) {
                String sql = String.format(JdbcAuditTrailManager.DELETE_SQL_TEMPLATE, JdbcAuditTrailManager.this.tableName, "aud");
                int count = JdbcAuditTrailManager.this.jdbcTemplate.update(sql);
                LOGGER.info("[{}] records deleted.", (Object)count);
            }
        });
    }

    public Set<? extends AuditActionContext> getAuditRecords(Map<AuditTrailManager.WhereClauseFields, Object> whereClause) {
        StringBuilder builder = new StringBuilder("1=1 ");
        if (whereClause.containsKey(AuditTrailManager.WhereClauseFields.DATE)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.dateFormatterPattern, Locale.ENGLISH);
            LocalDate sinceDate = (LocalDate)whereClause.get(AuditTrailManager.WhereClauseFields.DATE);
            String formattedDate = sinceDate.format(formatter);
            if (this.dateFormatterFunction != null) {
                String patternToUse = StringUtils.isNotBlank((CharSequence)this.dateFormatterPattern) ? this.dateFormatterPattern : "yyyy-MM-dd";
                formattedDate = String.format(this.dateFormatterFunction, sinceDate.format(formatter), patternToUse);
                builder.append(String.format("AND AUD_DATE>=%s ", formattedDate));
            } else {
                builder.append(String.format("AND AUD_DATE>='%s' ", formattedDate));
            }
        }
        if (whereClause.containsKey(AuditTrailManager.WhereClauseFields.PRINCIPAL)) {
            String principal = whereClause.get(AuditTrailManager.WhereClauseFields.PRINCIPAL).toString();
            builder.append(String.format("AND AUD_USER='%s' ", principal));
        }
        return this.getAuditRecordsSince(builder);
    }

    private Set<? extends AuditActionContext> getAuditRecordsSince(StringBuilder where) {
        return (Set)this.transactionTemplate.execute(transactionStatus -> {
            String sql = String.format(this.selectByDateSqlTemplate, this.tableName, where);
            LinkedHashSet results = new LinkedHashSet();
            this.jdbcTemplate.query(sql, resultSet -> results.add(this.getAuditActionContext(resultSet)));
            return results;
        });
    }

    protected AuditActionContext getAuditActionContext(ResultSet resultSet) throws SQLException {
        String principal = resultSet.getString(AuditTableColumns.USER.getColumnName());
        String resource = resultSet.getString(AuditTableColumns.RESOURCE.getColumnName());
        String clientIp = resultSet.getString(AuditTableColumns.CLIENT_IP.getColumnName());
        String serverIp = resultSet.getString(AuditTableColumns.SERVER_IP.getColumnName());
        Date audDate = resultSet.getDate(AuditTableColumns.DATE.getColumnName());
        String appCode = resultSet.getString(AuditTableColumns.APPLIC_CD.getColumnName());
        String action = resultSet.getString(AuditTableColumns.ACTION.getColumnName());
        String userAgent = resultSet.getString(AuditTableColumns.USERAGENT.getColumnName());
        String geoLocation = resultSet.getString(AuditTableColumns.GEOLOCATION.getColumnName());
        String locale = (String)StringUtils.defaultIfBlank((CharSequence)resultSet.getString(AuditTableColumns.LOCALE.getColumnName()), (CharSequence)Locale.US.toLanguageTag());
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String headerName : this.headerNames) {
            String headerValue = resultSet.getString(headerName);
            if (!StringUtils.isNotBlank((CharSequence)headerValue)) continue;
            headers.put(headerName, headerValue);
        }
        ClientInfo clientInfo = new ClientInfo(clientIp, serverIp, userAgent, geoLocation).setLocale(Locale.forLanguageTag(locale)).setHeaders(headers);
        LocalDateTime auditDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(audDate.getTime()), ZoneOffset.UTC);
        return new AuditActionContext(principal, resource, action, appCode, auditDate, clientInfo);
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setColumnLength(int columnLength) {
        this.columnLength = columnLength;
    }

    @Generated
    public void setSelectByDateSqlTemplate(String selectByDateSqlTemplate) {
        this.selectByDateSqlTemplate = selectByDateSqlTemplate;
    }

    @Generated
    public void setDateFormatterPattern(String dateFormatterPattern) {
        this.dateFormatterPattern = dateFormatterPattern;
    }

    @Generated
    public void setDateFormatterFunction(String dateFormatterFunction) {
        this.dateFormatterFunction = dateFormatterFunction;
    }

    @Generated
    public void setCleanupCriteria(WhereClauseMatchCriteria cleanupCriteria) {
        this.cleanupCriteria = cleanupCriteria;
    }

    @Generated
    public void setHeaderNames(List<String> headerNames) {
        this.headerNames = headerNames;
    }

    @Generated
    public JdbcAuditTrailManager(TransactionOperations transactionTemplate, JdbcTemplate jdbcTemplate) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
    }

    public static enum AuditTableColumns {
        USER("AUD_USER"),
        CLIENT_IP("AUD_CLIENT_IP"),
        SERVER_IP("AUD_SERVER_IP"),
        RESOURCE("AUD_RESOURCE"),
        ACTION("AUD_ACTION"),
        APPLIC_CD("APPLIC_CD"),
        DATE("AUD_DATE"),
        GEOLOCATION("AUD_GEOLOCATION"),
        USERAGENT("AUD_USERAGENT"),
        LOCALE("AUD_LOCALE"),
        HEADERS("AUD_HEADERS"),
        EXTRA_INFO("AUD_EXTRA_INFO");

        private final String columnName;

        @Generated
        private AuditTableColumns(String columnName) {
            this.columnName = columnName;
        }

        @Generated
        public String getColumnName() {
            return this.columnName;
        }
    }
}

