/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit.support;

import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import org.apereo.inspektr.audit.support.AbstractWhereClauseMatchCriteria;

public class DurationWhereClauseMatchCriteria
extends AbstractWhereClauseMatchCriteria {
    private static final String DATE_COLUMN = "AUD_DATE";
    protected final String duration;

    public DurationWhereClauseMatchCriteria(String duration) {
        this.duration = duration;
        this.addCriteria(DATE_COLUMN, "<");
    }

    @Override
    public List<?> getParameterValues() {
        long newTime = LocalDateTime.now(Clock.systemUTC()).toEpochSecond(ZoneOffset.UTC) + Duration.parse(this.duration).toMillis();
        return Collections.singletonList(newTime);
    }
}

