/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import java.time.Clock;
import java.time.LocalDateTime;
import java.util.UUID;
import lombok.Generated;
import org.apereo.cas.audit.spi.BaseAuditConfigurationTests;
import org.apereo.cas.config.CasCoreAuditConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasHibernateJpaConfiguration;
import org.apereo.cas.config.CasJdbcAuditConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.thread.Cleanable;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.common.web.ClientInfo;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={CasCoreAuditConfiguration.class, CasJdbcAuditConfiguration.class, CasHibernateJpaConfiguration.class, CasCoreUtilConfiguration.class, AopAutoConfiguration.class, WebMvcAutoConfiguration.class, RefreshAutoConfiguration.class}, properties={"cas.jdbc.show-sql=false", "cas.audit.jdbc.column-length=-1", "cas.audit.jdbc.schedule.enabled=true", "cas.audit.jdbc.asynchronous=false"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Tag(value="JDBC")
class CasJdbcAuditConfigurationTests
extends BaseAuditConfigurationTests {
    @Autowired
    @Qualifier(value="inspektrAuditTrailCleaner")
    private Cleanable inspektrAuditTrailCleaner;
    @Autowired
    @Qualifier(value="jdbcAuditTrailManager")
    private AuditTrailManager auditTrailManager;

    CasJdbcAuditConfigurationTests() {
    }

    @Test
    void verifyCleaner() {
        this.inspektrAuditTrailCleaner.clean();
    }

    @Test
    void verifyLargeResource() {
        AuditActionContext context = new AuditActionContext(UUID.randomUUID().toString(), RandomUtils.randomAlphabetic((int)10000), "TEST", "CAS", LocalDateTime.now(Clock.systemUTC()), new ClientInfo("1.2.3.4", "1.2.3.4", "GoogleChrome", "Paris"));
        this.getAuditTrailManager().record(context);
    }

    @Generated
    public Cleanable getInspektrAuditTrailCleaner() {
        return this.inspektrAuditTrailCleaner;
    }

    @Generated
    public AuditTrailManager getAuditTrailManager() {
        return this.auditTrailManager;
    }
}

