/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.config;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.spi.entity.AuditTrailEntity;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.audit.AuditJdbcProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.support.JdbcAuditTrailManager;
import org.apereo.inspektr.audit.support.MaxAgeWhereClauseMatchCriteria;
import org.apereo.inspektr.audit.support.WhereClauseMatchCriteria;
import org.apereo.inspektr.common.Cleanable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration(value="CasJdbcAuditConfiguration", proxyBeanMethods=false)
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement
public class CasSupportJdbcAuditConfiguration {

    @Configuration(value="CasSupportJdbcAuditDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSupportJdbcAuditDataConfiguration {
        @ConditionalOnMissingBean(name={"inspektrAuditTrailDataSource"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DataSource inspektrAuditTrailDataSource(CasConfigurationProperties casProperties) {
            return JpaBeans.newDataSource((AbstractJpaProperties)casProperties.getAudit().getJdbc());
        }
    }

    @Configuration(value="CasSupportJdbcAuditTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSupportJdbcAuditTransactionConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"inspektrAuditTransactionManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager inspektrAuditTransactionManager(@Qualifier(value="inspektrAuditTrailDataSource") DataSource inspektrAuditTrailDataSource) {
            return new DataSourceTransactionManager(inspektrAuditTrailDataSource);
        }
    }

    @Configuration(value="CasSupportJdbcAuditScheduleConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSupportJdbcAuditScheduleConfiguration {
        @ConditionalOnMissingBean(name={"inspektrAuditTrailCleaner"})
        @ConditionalOnProperty(prefix="cas.audit.jdbc.schedule", name={"enabled"}, havingValue="true", matchIfMissing=true)
        @Bean
        public Cleanable inspektrAuditTrailCleaner(final @Qualifier(value="jdbcAuditTrailManager") AuditTrailManager jdbcAuditTrailManager) {
            return new Cleanable(){

                @Scheduled(initialDelayString="${cas.audit.jdbc.schedule.start-delay:10000}", fixedDelayString="${cas.audit.jdbc.schedule.repeat-interval:30000}")
                public void clean() {
                    jdbcAuditTrailManager.clean();
                }
            };
        }
    }

    @Configuration(value="CasSupportJdbcAuditExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSupportJdbcAuditExecutionPlanConfiguration {
        @ConditionalOnMissingBean(name={"jdbcAuditTrailExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailExecutionPlanConfigurer jdbcAuditTrailExecutionPlanConfigurer(@Qualifier(value="jdbcAuditTrailManager") AuditTrailManager jdbcAuditTrailManager) {
            return plan -> plan.registerAuditTrailManager(jdbcAuditTrailManager);
        }
    }

    @Configuration(value="CasSupportJdbcAuditManagerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSupportJdbcAuditManagerConfiguration {
        private static String getAuditTableNameFrom(AuditJdbcProperties jdbc) {
            String tableName = "COM_AUDIT_TRAIL";
            if (StringUtils.isNotBlank((CharSequence)jdbc.getDefaultSchema())) {
                tableName = jdbc.getDefaultSchema().concat(".").concat(tableName);
            }
            if (StringUtils.isNotBlank((CharSequence)jdbc.getDefaultCatalog())) {
                tableName = jdbc.getDefaultCatalog().concat(".").concat(tableName);
            }
            return tableName;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailManager jdbcAuditTrailManager(@Qualifier(value="auditCleanupCriteria") WhereClauseMatchCriteria auditCleanupCriteria, @Qualifier(value="inspektrAuditTransactionTemplate") TransactionTemplate inspektrAuditTransactionTemplate, @Qualifier(value="inspektrAuditTrailDataSource") DataSource inspektrAuditTrailDataSource, CasConfigurationProperties casProperties) {
            AuditJdbcProperties jdbc = casProperties.getAudit().getJdbc();
            JdbcAuditTrailManager t = new JdbcAuditTrailManager(inspektrAuditTransactionTemplate);
            t.setCleanupCriteria(auditCleanupCriteria);
            t.setDataSource(inspektrAuditTrailDataSource);
            t.setAsynchronous(jdbc.isAsynchronous());
            t.setColumnLength(jdbc.getColumnLength());
            t.setTableName(CasSupportJdbcAuditManagerConfiguration.getAuditTableNameFrom(jdbc));
            if (StringUtils.isNotBlank((CharSequence)jdbc.getSelectSqlQueryTemplate())) {
                t.setSelectByDateSqlTemplate(jdbc.getSelectSqlQueryTemplate());
            }
            if (StringUtils.isNotBlank((CharSequence)jdbc.getDateFormatterPattern())) {
                t.setDateFormatterPattern(jdbc.getDateFormatterPattern());
            }
            return t;
        }
    }

    @Configuration(value="CasSupportJdbcAuditTransactionTemplateConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSupportJdbcAuditTransactionTemplateConfiguration {
        @ConditionalOnMissingBean(name={"inspektrAuditTransactionTemplate"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TransactionTemplate inspektrAuditTransactionTemplate(@Qualifier(value="inspektrAuditTransactionManager") PlatformTransactionManager inspektrAuditTransactionManager, CasConfigurationProperties casProperties) {
            TransactionTemplate t = new TransactionTemplate(inspektrAuditTransactionManager);
            AuditJdbcProperties jdbc = casProperties.getAudit().getJdbc();
            t.setIsolationLevelName(jdbc.getIsolationLevelName());
            t.setPropagationBehaviorName(jdbc.getPropagationBehaviorName());
            return t;
        }
    }

    @Configuration(value="CasSupportJdbcAuditEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSupportJdbcAuditEntityConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LocalContainerEntityManagerFactoryBean inspektrAuditEntityManagerFactory(@Qualifier(value="inspektrAuditTrailDataSource") DataSource inspektrAuditTrailDataSource, CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) {
            JpaConfigurationContext ctx = JpaConfigurationContext.builder().jpaVendorAdapter(jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc())).persistenceUnitName("jpaInspektrAuditContext").dataSource(inspektrAuditTrailDataSource).packagesToScan(CollectionUtils.wrapSet((Object)AuditTrailEntity.class.getPackage().getName())).build();
            return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)casProperties.getAudit().getJdbc());
        }

        @ConditionalOnMissingBean(name={"auditCleanupCriteria"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WhereClauseMatchCriteria auditCleanupCriteria(CasConfigurationProperties casProperties) {
            return new MaxAgeWhereClauseMatchCriteria(casProperties.getAudit().getJdbc().getMaxAgeDays());
        }
    }
}

