/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.config;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.spi.entity.AuditTrailEntity;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.audit.AuditJdbcProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.DatabaseProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigDataHolder;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.support.JdbcAuditTrailManager;
import org.apereo.inspektr.audit.support.MaxAgeWhereClauseMatchCriteria;
import org.apereo.inspektr.audit.support.WhereClauseMatchCriteria;
import org.apereo.inspektr.common.Cleanable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration(value="casJdbcAuditConfiguration")
@EnableAspectJAutoProxy(proxyTargetClass=true)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=true)
public class CasSupportJdbcAuditConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    private static String getAuditTableNameFrom(AuditJdbcProperties jdbc) {
        String tableName = "COM_AUDIT_TRAIL";
        if (StringUtils.isNotBlank((CharSequence)jdbc.getDefaultSchema())) {
            tableName = jdbc.getDefaultSchema().concat(".").concat(tableName);
        }
        if (StringUtils.isNotBlank((CharSequence)jdbc.getDefaultCatalog())) {
            tableName = jdbc.getDefaultCatalog().concat(".").concat(tableName);
        }
        return tableName;
    }

    @Bean
    public AuditTrailManager jdbcAuditTrailManager() {
        AuditJdbcProperties jdbc = this.casProperties.getAudit().getJdbc();
        JdbcAuditTrailManager t = new JdbcAuditTrailManager(this.inspektrAuditTransactionTemplate());
        t.setCleanupCriteria(this.auditCleanupCriteria());
        t.setDataSource(this.inspektrAuditTrailDataSource());
        t.setAsynchronous(jdbc.isAsynchronous());
        t.setColumnLength(jdbc.getColumnLength());
        t.setTableName(CasSupportJdbcAuditConfiguration.getAuditTableNameFrom(jdbc));
        return t;
    }

    @ConditionalOnMissingBean(name={"jdbcAuditTrailExecutionPlanConfigurer"})
    @Bean
    public AuditTrailExecutionPlanConfigurer jdbcAuditTrailExecutionPlanConfigurer() {
        return plan -> plan.registerAuditTrailManager(this.jdbcAuditTrailManager());
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean inspektrAuditEntityManagerFactory() {
        return JpaBeans.newHibernateEntityManagerFactoryBean((JpaConfigDataHolder)new JpaConfigDataHolder((JpaVendorAdapter)JpaBeans.newHibernateJpaVendorAdapter((DatabaseProperties)this.casProperties.getJdbc()), "jpaInspektrAuditContext", CollectionUtils.wrap((Object)AuditTrailEntity.class.getPackage().getName()), this.inspektrAuditTrailDataSource()), (AbstractJpaProperties)this.casProperties.getAudit().getJdbc());
    }

    @ConditionalOnMissingBean(name={"auditCleanupCriteria"})
    @Bean
    @RefreshScope
    public WhereClauseMatchCriteria auditCleanupCriteria() {
        return new MaxAgeWhereClauseMatchCriteria(this.casProperties.getAudit().getJdbc().getMaxAgeDays());
    }

    @Bean
    public PlatformTransactionManager inspektrAuditTransactionManager() {
        return new DataSourceTransactionManager(this.inspektrAuditTrailDataSource());
    }

    @ConditionalOnMissingBean(name={"inspektrAuditTrailDataSource"})
    @Bean
    @RefreshScope
    public DataSource inspektrAuditTrailDataSource() {
        return JpaBeans.newDataSource((AbstractJpaProperties)this.casProperties.getAudit().getJdbc());
    }

    @ConditionalOnMissingBean(name={"inspektrAuditTransactionTemplate"})
    @Bean
    public TransactionTemplate inspektrAuditTransactionTemplate() {
        TransactionTemplate t = new TransactionTemplate(this.inspektrAuditTransactionManager());
        t.setIsolationLevelName(this.casProperties.getAudit().getJdbc().getIsolationLevelName());
        t.setPropagationBehaviorName(this.casProperties.getAudit().getJdbc().getPropagationBehaviorName());
        return t;
    }

    @ConditionalOnMissingBean(name={"inspektrAuditTrailCleaner"})
    @ConditionalOnProperty(prefix="cas.audit.jdbc.schedule", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    public Cleanable inspektrAuditTrailCleaner() {
        return new Cleanable(){

            @Scheduled(initialDelayString="${cas.audit.jdbc.schedule.startDelay:10000}", fixedDelayString="${cas.audit.jdbc.schedule.repeatInterval:30000}")
            public void clean() {
                Cleanable cleaner = (Cleanable)Cleanable.class.cast(CasSupportJdbcAuditConfiguration.this.jdbcAuditTrailManager());
                cleaner.clean();
            }
        };
    }
}

