/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import java.time.LocalDate;
import java.util.Date;
import java.util.Set;
import org.apereo.cas.audit.config.CasSupportJdbcAuditConfiguration;
import org.apereo.cas.audit.spi.config.CasCoreAuditConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.junit.ConditionalSpringRunner;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.test.context.TestPropertySource;

@RunWith(value=ConditionalSpringRunner.class)
@SpringBootTest(classes={CasCoreAuditConfiguration.class, CasSupportJdbcAuditConfiguration.class, AopAutoConfiguration.class, RefreshAutoConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@TestPropertySource(properties={"cas.audit.jdbc.asynchronous=false"})
public class CasSupportJdbcAuditConfigurationTests {
    @Autowired
    @Qualifier(value="jdbcAuditTrailManager")
    private AuditTrailManager jdbcAuditTrailManager;

    @Test
    public void verifyAuditManager() {
        LocalDate time = LocalDate.now().minusDays(2L);
        Date since = DateTimeUtils.dateOf((LocalDate)time);
        AuditActionContext ctx = new AuditActionContext("casuser", "TEST", "TEST", "CAS", since, "1.2.3.4", "1.2.3.4");
        this.jdbcAuditTrailManager.record(ctx);
        Set results = this.jdbcAuditTrailManager.getAuditRecordsSince(time);
        Assert.assertFalse((boolean)results.isEmpty());
    }
}

