/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.config;

import javax.sql.DataSource;
import org.apereo.cas.audit.spi.DefaultDelegatingAuditTrailManager;
import org.apereo.cas.audit.spi.DelegatingAuditTrailManager;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.DatabaseProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigDataHolder;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.support.JdbcAuditTrailManager;
import org.apereo.inspektr.audit.support.MaxAgeWhereClauseMatchCriteria;
import org.apereo.inspektr.audit.support.WhereClauseMatchCriteria;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration(value="casJdbcAuditConfiguration")
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=true)
public class CasSupportJdbcAuditConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean(name={"jdbcAuditTrailManager", "auditTrailManager"})
    public DelegatingAuditTrailManager jdbcAuditTrailManager() {
        JdbcAuditTrailManager t = new JdbcAuditTrailManager(this.inspektrAuditTransactionTemplate());
        t.setCleanupCriteria(this.auditCleanupCriteria());
        t.setDataSource(this.inspektrAuditTrailDataSource());
        return new DefaultDelegatingAuditTrailManager((AuditTrailManager)t);
    }

    @Lazy
    @Bean
    public LocalContainerEntityManagerFactoryBean inspektrAuditEntityManagerFactory() {
        return Beans.newEntityManagerFactoryBean((JpaConfigDataHolder)new JpaConfigDataHolder((JpaVendorAdapter)Beans.newHibernateJpaVendorAdapter((DatabaseProperties)this.casProperties.getJdbc()), "jpaInspektrAuditContext", new String[]{"org.apereo.cas.audit.entity"}, this.inspektrAuditTrailDataSource()), (AbstractJpaProperties)this.casProperties.getAudit().getJdbc());
    }

    @Bean
    @RefreshScope
    public WhereClauseMatchCriteria auditCleanupCriteria() {
        return new MaxAgeWhereClauseMatchCriteria(this.casProperties.getAudit().getJdbc().getMaxAgeDays());
    }

    @Bean
    public PlatformTransactionManager inspektrAuditTransactionManager() {
        return new DataSourceTransactionManager(this.inspektrAuditTrailDataSource());
    }

    @Bean
    @RefreshScope
    public DataSource inspektrAuditTrailDataSource() {
        return Beans.newHickariDataSource((AbstractJpaProperties)this.casProperties.getAudit().getJdbc());
    }

    @Bean
    public TransactionTemplate inspektrAuditTransactionTemplate() {
        TransactionTemplate t = new TransactionTemplate(this.inspektrAuditTransactionManager());
        t.setIsolationLevelName(this.casProperties.getAudit().getJdbc().getIsolationLevelName());
        t.setPropagationBehaviorName(this.casProperties.getAudit().getJdbc().getPropagationBehaviorName());
        return t;
    }
}

