/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation.config;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.validation.AuthenticationPolicyAwareServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.Cas10ProtocolValidationSpecification;
import org.apereo.cas.validation.Cas20ProtocolValidationSpecification;
import org.apereo.cas.validation.Cas20WithoutProxyingValidationSpecification;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.DefaultServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.validation.RequestedAuthenticationContextValidator;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizerConfigurer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration(value="casCoreValidationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreValidationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreValidationConfiguration.class);
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="authenticationEventExecutionPlan")
    private ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean(name={"cas10ProtocolValidationSpecification"})
    public CasProtocolValidationSpecification cas10ProtocolValidationSpecification() {
        return new Cas10ProtocolValidationSpecification((ServicesManager)this.servicesManager.getObject());
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean(name={"cas20ProtocolValidationSpecification"})
    public CasProtocolValidationSpecification cas20ProtocolValidationSpecification() {
        return new Cas20ProtocolValidationSpecification((ServicesManager)this.servicesManager.getObject());
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean(name={"cas20WithoutProxyProtocolValidationSpecification"})
    public CasProtocolValidationSpecification cas20WithoutProxyProtocolValidationSpecification() {
        return new Cas20WithoutProxyingValidationSpecification((ServicesManager)this.servicesManager.getObject());
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"serviceValidationAuthorizers"})
    public ServiceTicketValidationAuthorizersExecutionPlan serviceValidationAuthorizers(List<ServiceTicketValidationAuthorizerConfigurer> configurers) {
        DefaultServiceTicketValidationAuthorizersExecutionPlan plan = new DefaultServiceTicketValidationAuthorizersExecutionPlan();
        configurers.forEach(c -> {
            LOGGER.trace("Configuring service ticket validation authorizer execution plan [{}]", (Object)c.getName());
            c.configureAuthorizersExecutionPlan((ServiceTicketValidationAuthorizersExecutionPlan)plan);
        });
        return plan;
    }

    @Bean
    @ConditionalOnMissingBean(name={"authenticationPolicyAwareServiceTicketValidationAuthorizer"})
    public ServiceTicketValidationAuthorizer authenticationPolicyAwareServiceTicketValidationAuthorizer() {
        return new AuthenticationPolicyAwareServiceTicketValidationAuthorizer((ServicesManager)this.servicesManager.getObject(), (AuthenticationEventExecutionPlan)this.authenticationEventExecutionPlan.getObject(), this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(name={"casCoreServiceTicketValidationAuthorizerConfigurer"})
    public ServiceTicketValidationAuthorizerConfigurer casCoreServiceTicketValidationAuthorizerConfigurer() {
        return plan -> plan.registerAuthorizer(this.authenticationPolicyAwareServiceTicketValidationAuthorizer());
    }

    @Bean
    @ConditionalOnMissingBean(name={"requestedContextValidator"})
    public RequestedAuthenticationContextValidator requestedContextValidator() {
        return (assertion, request) -> {
            Service service = assertion.getService();
            LOGGER.trace("Locating the primary authentication associated with this service request [{}]", (Object)service);
            RegisteredService registeredService = ((ServicesManager)this.servicesManager.getObject()).findServiceBy(service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            return Pair.of((Object)Boolean.TRUE, Optional.empty());
        };
    }
}

