/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import java.util.ArrayList;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.validation.ImmutableAssertion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="Simple")
public class ImmutableAssertionTests {
    @Test
    public void verifyGettersForChainedPrincipals() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication((String)"test"));
        list.add(CoreAuthenticationTestUtils.getAuthentication((String)"test1"));
        list.add(CoreAuthenticationTestUtils.getAuthentication((String)"test2"));
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, true, (Service)RegisteredServiceTestUtils.getService());
        Assertions.assertEquals((int)((Authentication[])list.toArray(Authentication[]::new)).length, (int)assertion.getChainedAuthentications().size());
    }

    @Test
    public void verifyGetterFalseForNewLogin() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication());
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, false, (Service)RegisteredServiceTestUtils.getService());
        Assertions.assertFalse((boolean)assertion.isFromNewLogin());
    }

    @Test
    public void verifyGetterTrueForNewLogin() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication());
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, true, (Service)RegisteredServiceTestUtils.getService());
        Assertions.assertTrue((boolean)assertion.isFromNewLogin());
    }

    @Test
    public void verifyEqualsWithNull() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication());
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, true, (Service)RegisteredServiceTestUtils.getService());
        Assertions.assertNotEquals((Object)assertion, null);
    }

    @Test
    public void verifyEqualsWithInvalidObject() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication());
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, true, (Service)RegisteredServiceTestUtils.getService());
        Assertions.assertFalse((boolean)"test".equals(assertion));
    }

    @Test
    public void verifyEqualsWithValidObject() {
        ArrayList<Authentication> list1 = new ArrayList<Authentication>();
        ArrayList<Authentication> list2 = new ArrayList<Authentication>();
        Authentication auth = CoreAuthenticationTestUtils.getAuthentication();
        list1.add(auth);
        list2.add(auth);
        ImmutableAssertion assertion1 = new ImmutableAssertion(auth, list1, true, (Service)RegisteredServiceTestUtils.getService());
        ImmutableAssertion assertion2 = new ImmutableAssertion(auth, list2, true, (Service)RegisteredServiceTestUtils.getService());
        Assertions.assertTrue((boolean)assertion1.equals((Object)assertion2));
    }

    @Test
    public void verifyGetService() {
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService();
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication());
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, false, (Service)service);
        Assertions.assertEquals((Object)service, (Object)assertion.getService());
    }
}

