/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.Cas10ProtocolValidationSpecification;
import org.apereo.cas.validation.Cas20ProtocolValidationSpecification;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.ChainingCasProtocolValidationSpecification;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.mock.web.MockHttpServletRequest;

@SpringBootTest(classes={RefreshAutoConfiguration.class})
@Tag(value="Simple")
public class ChainingCasProtocolValidationSpecificationTests {
    private static Assertion getAssertion() {
        Assertion assertion = (Assertion)Mockito.mock(Assertion.class);
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser");
        Map<UsernamePasswordCredential, SimpleTestUsernamePasswordAuthenticationHandler> handlers = Map.of(new UsernamePasswordCredential(), new SimpleTestUsernamePasswordAuthenticationHandler());
        Authentication authentication = CoreAuthenticationTestUtils.getAuthenticationBuilder((Principal)principal, handlers, Map.of()).build();
        Mockito.when((Object)assertion.getPrimaryAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)assertion.getChainedAuthentications()).thenReturn(List.of(authentication));
        return assertion;
    }

    @Test
    public void verifyOperationByAny() {
        ServicesManager servicesManager = (ServicesManager)Mockito.mock(ServicesManager.class);
        ChainingCasProtocolValidationSpecification chain = new ChainingCasProtocolValidationSpecification(true);
        chain.addSpecifications(new CasProtocolValidationSpecification[]{new Cas20ProtocolValidationSpecification(servicesManager), new Cas10ProtocolValidationSpecification(servicesManager)});
        Assertions.assertEquals((int)2, (int)chain.size());
        chain.reset();
        Assertions.assertTrue((boolean)chain.isSatisfiedBy(ChainingCasProtocolValidationSpecificationTests.getAssertion(), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifyOperationByAll() {
        ServicesManager servicesManager = (ServicesManager)Mockito.mock(ServicesManager.class);
        ChainingCasProtocolValidationSpecification chain = new ChainingCasProtocolValidationSpecification(false);
        chain.addSpecifications(new CasProtocolValidationSpecification[]{new Cas20ProtocolValidationSpecification(servicesManager)});
        chain.reset();
        Assertions.assertTrue((boolean)chain.isSatisfiedBy(ChainingCasProtocolValidationSpecificationTests.getAssertion(), (HttpServletRequest)new MockHttpServletRequest()));
    }
}

