/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.validation.Cas20WithoutProxyingValidationSpecification;
import org.apereo.cas.validation.CoreValidationTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;

@Tag(value="Simple")
public class Cas20WithoutProxyingValidationSpecificationTests {
    private Cas20WithoutProxyingValidationSpecification validationSpecification;

    @BeforeEach
    public void initialize() {
        this.validationSpecification = new Cas20WithoutProxyingValidationSpecification((ServicesManager)Mockito.mock(ServicesManager.class));
    }

    @Test
    public void verifySatisfiesSpecOfTrue() {
        Assertions.assertTrue((boolean)this.validationSpecification.isSatisfiedBy(CoreValidationTestUtils.getAssertion(true), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifyNotSatisfiesSpecOfTrue() {
        this.validationSpecification.setRenew(true);
        Assertions.assertFalse((boolean)this.validationSpecification.isSatisfiedBy(CoreValidationTestUtils.getAssertion(false), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifySatisfiesSpecOfFalse() {
        Assertions.assertTrue((boolean)this.validationSpecification.isSatisfiedBy(CoreValidationTestUtils.getAssertion(false), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifyDoesNotSatisfiesSpecOfFalse() {
        Assertions.assertFalse((boolean)this.validationSpecification.isSatisfiedBy(CoreValidationTestUtils.getAssertion(false, new String[]{"test2"}), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifySettingRenew() {
        Cas20WithoutProxyingValidationSpecification validation = new Cas20WithoutProxyingValidationSpecification((ServicesManager)Mockito.mock(ServicesManager.class), true);
        Assertions.assertTrue((boolean)validation.isRenew());
    }
}

