/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.validation.Cas10ProtocolValidationSpecification;
import org.apereo.cas.validation.CoreValidationTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.mock.web.MockHttpServletRequest;

@SpringBootTest(classes={RefreshAutoConfiguration.class})
@ExtendWith(value={MockitoExtension.class})
@Tag(value="Simple")
public class Cas10ProtocolValidationSpecificationTests {
    @Mock
    private ServicesManager servicesManager;

    @Test
    public void verifyRenewGettersAndSettersFalse() {
        Cas10ProtocolValidationSpecification s = new Cas10ProtocolValidationSpecification(this.servicesManager);
        s.setRenew(false);
        Assertions.assertFalse((boolean)s.isRenew());
    }

    @Test
    public void verifyRenewGettersAndSettersTrue() {
        Cas10ProtocolValidationSpecification s = new Cas10ProtocolValidationSpecification(this.servicesManager);
        s.setRenew(true);
        Assertions.assertTrue((boolean)s.isRenew());
    }

    @Test
    public void verifyRenewAsTrueAsConstructor() {
        Assertions.assertTrue((boolean)new Cas10ProtocolValidationSpecification(this.servicesManager, true).isRenew());
    }

    @Test
    public void verifyRenewAsFalseAsConstructor() {
        Assertions.assertFalse((boolean)new Cas10ProtocolValidationSpecification(this.servicesManager, false).isRenew());
    }

    @Test
    public void verifySatisfiesSpecOfTrue() {
        Assertions.assertTrue((boolean)new Cas10ProtocolValidationSpecification(this.servicesManager, true).isSatisfiedBy(CoreValidationTestUtils.getAssertion(true), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifyNotSatisfiesSpecOfTrue() {
        Assertions.assertFalse((boolean)new Cas10ProtocolValidationSpecification(this.servicesManager, true).isSatisfiedBy(CoreValidationTestUtils.getAssertion(false), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifySatisfiesSpecOfFalse() {
        Assertions.assertTrue((boolean)new Cas10ProtocolValidationSpecification(this.servicesManager, false).isSatisfiedBy(CoreValidationTestUtils.getAssertion(true), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifySatisfiesSpecOfFalse2() {
        Assertions.assertTrue((boolean)new Cas10ProtocolValidationSpecification(this.servicesManager, false).isSatisfiedBy(CoreValidationTestUtils.getAssertion(false), (HttpServletRequest)new MockHttpServletRequest()));
    }
}

