/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.TestOneTimePasswordAuthenticationHandler;
import org.apereo.cas.authentication.AcceptUsersAuthenticationHandler;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.credential.OneTimePasswordCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.policy.AllAuthenticationHandlersSucceededAuthenticationPolicy;
import org.apereo.cas.authentication.policy.AllCredentialsValidatedAuthenticationPolicy;
import org.apereo.cas.authentication.policy.AtLeastOneCredentialValidatedAuthenticationPolicy;
import org.apereo.cas.authentication.policy.RequiredHandlerAuthenticationPolicy;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreServicesAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.CasRegisteredServicesTestConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.AuthenticationPolicyAwareServiceTicketValidationAuthorizer;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;

@SpringBootTest(classes={RefreshAutoConfiguration.class, CasPersonDirectoryTestConfiguration.class, CasRegisteredServicesTestConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreServicesAuthenticationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasCoreWebConfiguration.class, CasCoreHttpConfiguration.class, CasCoreUtilConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreConfiguration.class, CasCoreServicesConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, MailSenderAutoConfiguration.class})
@Tag(value="Simple")
public class AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests {
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    private static Assertion getAssertion(Map<Credential, ? extends AuthenticationHandler> handlers) {
        Assertion assertion = (Assertion)Mockito.mock(Assertion.class);
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser");
        Authentication authentication = CoreAuthenticationTestUtils.getAuthenticationBuilder((Principal)principal, handlers, Map.of("successfulAuthenticationHandlers", handlers.values().stream().map(AuthenticationHandler::getName).collect(Collectors.toList()))).build();
        Mockito.when((Object)assertion.getPrimaryAuthentication()).thenReturn((Object)authentication);
        return assertion;
    }

    private static SimpleTestUsernamePasswordAuthenticationHandler getSimpleTestAuthenticationHandler() {
        return new SimpleTestUsernamePasswordAuthenticationHandler();
    }

    private static AcceptUsersAuthenticationHandler getAcceptUsersAuthenticationHandler() {
        return new AcceptUsersAuthenticationHandler(Map.of("casuser", "Mellon"));
    }

    private static OneTimePasswordCredential getOtpCredential() {
        return new OneTimePasswordCredential("test", "123456789");
    }

    private static TestOneTimePasswordAuthenticationHandler getTestOtpAuthenticationHandler() {
        return new TestOneTimePasswordAuthenticationHandler(Map.of("casuser", "123456789"));
    }

    @Test
    public void verifyAllAuthenticationHandlersSucceededAuthenticationPolicy() {
        List<SimpleTestUsernamePasswordAuthenticationHandler> handlers = List.of(AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAcceptUsersAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getSimpleTestAuthenticationHandler());
        final Service service = CoreAuthenticationTestUtils.getService((String)"https://example.com/high/");
        final ServiceTicketValidationAuthorizer authz = this.getAuthorizer((AuthenticationPolicy)new AllAuthenticationHandlersSucceededAuthenticationPolicy(), handlers);
        Map<OneTimePasswordCredential, TestOneTimePasswordAuthenticationHandler> map = Map.of(new UsernamePasswordCredential(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAcceptUsersAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getOtpCredential(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler());
        final Assertion assertion = AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAssertion(map);
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() {
                authz.authorize((HttpServletRequest)new MockHttpServletRequest(), service, assertion);
            }
        });
    }

    @Test
    public void verifyAllCredentialsValidatedAuthenticationPolicy() {
        List<SimpleTestUsernamePasswordAuthenticationHandler> handlers = List.of(AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAcceptUsersAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getSimpleTestAuthenticationHandler());
        final Service service = CoreAuthenticationTestUtils.getService((String)"https://example.com/high/");
        final ServiceTicketValidationAuthorizer authz = this.getAuthorizer((AuthenticationPolicy)new AllCredentialsValidatedAuthenticationPolicy(), handlers);
        Map<OneTimePasswordCredential, TestOneTimePasswordAuthenticationHandler> map = Map.of(new UsernamePasswordCredential(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAcceptUsersAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getOtpCredential(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler());
        final Assertion assertion = AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAssertion(map);
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() {
                authz.authorize((HttpServletRequest)new MockHttpServletRequest(), service, assertion);
            }
        });
    }

    @Test
    public void verifyRequiredHandlerAuthenticationPolicy() {
        AcceptUsersAuthenticationHandler handler = AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAcceptUsersAuthenticationHandler();
        List<SimpleTestUsernamePasswordAuthenticationHandler> handlers = List.of(AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler(), handler, AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getSimpleTestAuthenticationHandler());
        final Service service = CoreAuthenticationTestUtils.getService((String)"https://example.com/high/");
        final ServiceTicketValidationAuthorizer authz = this.getAuthorizer((AuthenticationPolicy)new RequiredHandlerAuthenticationPolicy(handler.getName()), handlers);
        Map<OneTimePasswordCredential, TestOneTimePasswordAuthenticationHandler> map = Map.of(new UsernamePasswordCredential(), handler, AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getOtpCredential(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler());
        final Assertion assertion = AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAssertion(map);
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() {
                authz.authorize((HttpServletRequest)new MockHttpServletRequest(), service, assertion);
            }
        });
    }

    @Test
    public void verifyRequiredHandlerAuthenticationPolicyTryAll() {
        AcceptUsersAuthenticationHandler handler = AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAcceptUsersAuthenticationHandler();
        List<SimpleTestUsernamePasswordAuthenticationHandler> handlers = List.of(AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler(), handler, AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getSimpleTestAuthenticationHandler());
        final Service service = CoreAuthenticationTestUtils.getService((String)"https://example.com/high/");
        final ServiceTicketValidationAuthorizer authz = this.getAuthorizer((AuthenticationPolicy)new RequiredHandlerAuthenticationPolicy(Set.of(handler.getName()), true), handlers);
        Map<OneTimePasswordCredential, TestOneTimePasswordAuthenticationHandler> map = Map.of(new UsernamePasswordCredential(), handler, AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getOtpCredential(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler());
        final Assertion assertion = AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAssertion(map);
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() {
                authz.authorize((HttpServletRequest)new MockHttpServletRequest(), service, assertion);
            }
        });
    }

    @Test
    public void verifyOperationWithHandlersAndAtLeastOneCredential() {
        List<SimpleTestUsernamePasswordAuthenticationHandler> handlers = List.of(AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAcceptUsersAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getSimpleTestAuthenticationHandler());
        final Service service = CoreAuthenticationTestUtils.getService((String)"https://example.com/high/");
        final ServiceTicketValidationAuthorizer authz = this.getAuthorizer((AuthenticationPolicy)new AtLeastOneCredentialValidatedAuthenticationPolicy(), handlers);
        Map<OneTimePasswordCredential, TestOneTimePasswordAuthenticationHandler> map = Map.of(new UsernamePasswordCredential(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAcceptUsersAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getOtpCredential(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler());
        final Assertion assertion = AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAssertion(map);
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() {
                authz.authorize((HttpServletRequest)new MockHttpServletRequest(), service, assertion);
            }
        });
    }

    @Test
    public void verifyOperationWithHandlersAndAtLeastOneCredentialMustTryAll() {
        List<SimpleTestUsernamePasswordAuthenticationHandler> handlers = List.of(AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAcceptUsersAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getSimpleTestAuthenticationHandler());
        final Service service = CoreAuthenticationTestUtils.getService((String)"https://example.com/high/");
        final ServiceTicketValidationAuthorizer authz = this.getAuthorizer((AuthenticationPolicy)new AtLeastOneCredentialValidatedAuthenticationPolicy(true), handlers);
        Map<OneTimePasswordCredential, TestOneTimePasswordAuthenticationHandler> map = Map.of(new UsernamePasswordCredential(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAcceptUsersAuthenticationHandler(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getOtpCredential(), AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getTestOtpAuthenticationHandler());
        final Assertion assertion = AuthenticationPolicyAwareServiceTicketValidationAuthorizerTests.getAssertion(map);
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() {
                authz.authorize((HttpServletRequest)new MockHttpServletRequest(), service, assertion);
            }
        });
    }

    private ServiceTicketValidationAuthorizer getAuthorizer(AuthenticationPolicy policy, List<? extends AuthenticationHandler> authenticationHandlers) {
        DefaultAuthenticationEventExecutionPlan plan = new DefaultAuthenticationEventExecutionPlan();
        plan.registerAuthenticationHandlers(authenticationHandlers);
        plan.registerAuthenticationPolicy(policy);
        return new AuthenticationPolicyAwareServiceTicketValidationAuthorizer(this.servicesManager, (AuthenticationEventExecutionPlan)plan, this.applicationContext);
    }
}

