/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import java.util.ArrayList;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.validation.ImmutableAssertion;
import org.junit.Assert;
import org.junit.Test;

public class ImmutableAssertionTests {
    @Test
    public void verifyGettersForChainedPrincipals() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication((String)"test"));
        list.add(CoreAuthenticationTestUtils.getAuthentication((String)"test1"));
        list.add(CoreAuthenticationTestUtils.getAuthentication((String)"test2"));
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, RegisteredServiceTestUtils.getService(), true);
        Assert.assertEquals((long)list.toArray(new Authentication[0]).length, (long)assertion.getChainedAuthentications().size());
    }

    @Test
    public void verifyGetterFalseForNewLogin() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication());
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, RegisteredServiceTestUtils.getService(), false);
        Assert.assertFalse((boolean)assertion.isFromNewLogin());
    }

    @Test
    public void verifyGetterTrueForNewLogin() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication());
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, RegisteredServiceTestUtils.getService(), true);
        Assert.assertTrue((boolean)assertion.isFromNewLogin());
    }

    @Test
    public void verifyEqualsWithNull() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication());
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, RegisteredServiceTestUtils.getService(), true);
        Assert.assertNotEquals((Object)assertion, null);
    }

    @Test
    public void verifyEqualsWithInvalidObject() {
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication());
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, RegisteredServiceTestUtils.getService(), true);
        Assert.assertFalse((boolean)"test".equals(assertion));
    }

    @Test
    public void verifyEqualsWithValidObject() {
        ArrayList<Authentication> list1 = new ArrayList<Authentication>();
        ArrayList<Authentication> list2 = new ArrayList<Authentication>();
        Authentication auth = CoreAuthenticationTestUtils.getAuthentication();
        list1.add(auth);
        list2.add(auth);
        ImmutableAssertion assertion1 = new ImmutableAssertion(auth, list1, RegisteredServiceTestUtils.getService(), true);
        ImmutableAssertion assertion2 = new ImmutableAssertion(auth, list2, RegisteredServiceTestUtils.getService(), true);
        Assert.assertTrue((boolean)assertion1.equals((Object)assertion2));
    }

    @Test
    public void verifyGetService() {
        Service service = RegisteredServiceTestUtils.getService();
        ArrayList<Authentication> list = new ArrayList<Authentication>();
        list.add(CoreAuthenticationTestUtils.getAuthentication());
        ImmutableAssertion assertion = new ImmutableAssertion(CoreAuthenticationTestUtils.getAuthentication(), list, service, false);
        Assert.assertEquals((Object)service, (Object)assertion.getService());
    }
}

