/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.validation.Cas20WithoutProxyingValidationSpecification;
import org.apereo.cas.validation.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class Cas20WithoutProxyingValidationSpecificationTests {
    private Cas20WithoutProxyingValidationSpecification validationSpecification;

    @Before
    public void setUp() throws Exception {
        this.validationSpecification = new Cas20WithoutProxyingValidationSpecification();
    }

    @Test
    public void verifySatisfiesSpecOfTrue() {
        Assert.assertTrue((boolean)this.validationSpecification.isSatisfiedBy(TestUtils.getAssertion(true), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifyNotSatisfiesSpecOfTrue() {
        this.validationSpecification.setRenew(true);
        Assert.assertFalse((boolean)this.validationSpecification.isSatisfiedBy(TestUtils.getAssertion(false), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifySatisfiesSpecOfFalse() {
        Assert.assertTrue((boolean)this.validationSpecification.isSatisfiedBy(TestUtils.getAssertion(false), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifyDoesNotSatisfiesSpecOfFalse() {
        Assert.assertFalse((boolean)this.validationSpecification.isSatisfiedBy(TestUtils.getAssertion(false, new String[]{"test2"}), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifySettingRenew() {
        Cas20WithoutProxyingValidationSpecification validation = new Cas20WithoutProxyingValidationSpecification(true);
        Assert.assertTrue((boolean)validation.isRenew());
    }
}

