/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.validation.Cas10ProtocolValidationSpecification;
import org.apereo.cas.validation.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class Cas10ProtocolValidationSpecificationTests {
    @Test
    public void verifyRenewGettersAndSettersFalse() {
        Cas10ProtocolValidationSpecification s = new Cas10ProtocolValidationSpecification();
        s.setRenew(false);
        Assert.assertFalse((boolean)s.isRenew());
    }

    @Test
    public void verifyRenewGettersAndSettersTrue() {
        Cas10ProtocolValidationSpecification s = new Cas10ProtocolValidationSpecification();
        s.setRenew(true);
        Assert.assertTrue((boolean)s.isRenew());
    }

    @Test
    public void verifyRenewAsTrueAsConstructor() {
        Assert.assertTrue((boolean)new Cas10ProtocolValidationSpecification(true).isRenew());
    }

    @Test
    public void verifyRenewAsFalseAsConstructor() {
        Assert.assertFalse((boolean)new Cas10ProtocolValidationSpecification(false).isRenew());
    }

    @Test
    public void verifySatisfiesSpecOfTrue() {
        Assert.assertTrue((boolean)new Cas10ProtocolValidationSpecification(true).isSatisfiedBy(TestUtils.getAssertion(true), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifyNotSatisfiesSpecOfTrue() {
        Assert.assertFalse((boolean)new Cas10ProtocolValidationSpecification(true).isSatisfiedBy(TestUtils.getAssertion(false), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifySatisfiesSpecOfFalse() {
        Assert.assertTrue((boolean)new Cas10ProtocolValidationSpecification(false).isSatisfiedBy(TestUtils.getAssertion(true), (HttpServletRequest)new MockHttpServletRequest()));
    }

    @Test
    public void verifySatisfiesSpecOfFalse2() {
        Assert.assertTrue((boolean)new Cas10ProtocolValidationSpecification(false).isSatisfiedBy(TestUtils.getAssertion(false), (HttpServletRequest)new MockHttpServletRequest()));
    }
}

