/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mgmt;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apereo.cas.configuration.CasManagementConfigurationProperties;
import org.apereo.cas.mgmt.ManagementServicesManager;
import org.apereo.cas.mgmt.MgmtManagerFactory;
import org.apereo.cas.mgmt.authentication.CasUserProfile;
import org.apereo.cas.mgmt.domain.RegisteredServiceItem;
import org.apereo.cas.mgmt.exception.SearchException;
import org.apereo.cas.mgmt.util.CasManagementUtils;
import org.apereo.cas.services.ServicesManager;
import org.hjson.JsonObject;
import org.hjson.JsonType;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="casSearchController")
@RequestMapping(path={"api/search"}, produces={"application/json"})
public class LuceneSearch {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneSearch.class);
    private static final int MAX_RESULTS = 5000;
    private final MgmtManagerFactory<? extends ServicesManager> mgmtManagerFactory;
    private final CasManagementConfigurationProperties managementProperties;

    @PostMapping
    public List<RegisteredServiceItem> search(Authentication authentication, @RequestBody String queryString) throws SearchException {
        List<RegisteredServiceItem> list;
        CasUserProfile casUserProfile = CasUserProfile.from((Authentication)authentication);
        StandardAnalyzer analyzer = new StandardAnalyzer();
        Query query = new QueryParser("body", (Analyzer)analyzer).parse(queryString);
        ArrayList<String> fields = LuceneSearch.getFields(query, new ArrayList<String>());
        ManagementServicesManager manager = (ManagementServicesManager)this.mgmtManagerFactory.from(authentication);
        MMapDirectory memoryIndex = new MMapDirectory(Paths.get(this.managementProperties.getLuceneIndexDir() + "/" + casUserProfile.getUsername(), new String[0]));
        try {
            List<Document> docs = manager.getAllServices().stream().filter(arg_0 -> ((CasUserProfile)casUserProfile).hasPermission(arg_0)).map(CasManagementUtils::toJson).map(JsonValue::readHjson).map(r -> LuceneSearch.createDocument(r.asObject(), fields)).collect(Collectors.toList());
            LuceneSearch.writeDocs(analyzer, memoryIndex, docs);
            List<RegisteredServiceItem> results = LuceneSearch.results(memoryIndex, query).stream().map(d -> d.getField("id")).map(id -> manager.findServiceBy(Long.parseLong(id.stringValue()))).map(arg_0 -> ((ManagementServicesManager)manager).createServiceItem(arg_0)).collect(Collectors.toList());
            LOGGER.debug("Found search results [{}]", results);
            FileUtils.deleteDirectory((File)memoryIndex.getDirectory().toFile());
            list = results;
        }
        catch (Throwable throwable) {
            try {
                try {
                    memoryIndex.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParseException ex) {
                LOGGER.error(ex.getMessage(), ex);
                return List.of();
            }
        }
        memoryIndex.close();
        return list;
    }

    private static Document createDocument(JsonObject json, ArrayList<String> fields) {
        Document document = new Document();
        long id = json.asObject().getLong("id", -1L);
        fields.stream().map(f -> LuceneSearch.createTriple(json.asObject(), f)).flatMap(t -> LuceneSearch.createFields((Triple<JsonType, Object, String>)t).stream()).forEach(arg_0 -> ((Document)document).add(arg_0));
        if (fields.contains("body")) {
            document.add((IndexableField)new TextField("body", json.toString(), Field.Store.NO));
            LuceneSearch.addFieldFor(json, document, "attributeReleasePolicy");
            LuceneSearch.addFieldFor(json, document, "accessStrategy");
            LuceneSearch.addFieldFor(json, document, "multifactorPolicy");
            LuceneSearch.addFieldFor(json, document, "contacts");
            LuceneSearch.addFieldFor(json, document, "usernameAttributeProvider");
            LuceneSearch.addFieldFor(json, document, "acceptableUsagePolicy");
        }
        document.add((IndexableField)new StringField("id", String.valueOf(id), Field.Store.YES));
        LOGGER.debug("Final search document: [{}]", (Object)document);
        return document;
    }

    private static void addFieldFor(JsonObject json, Document document, String name) {
        JsonValue innerObject = json.get(name);
        if (innerObject != null) {
            document.add((IndexableField)new TextField(name, innerObject.toString(), Field.Store.NO));
        }
    }

    private static ArrayList<Field> createFields(Triple<JsonType, Object, String> triple) {
        String field = (String)triple.getRight();
        JsonType type = (JsonType)triple.getLeft();
        Object value = triple.getMiddle();
        ArrayList<Field> fields = new ArrayList<Field>();
        if (!"body".equals(field)) {
            if (type == JsonType.NUMBER) {
                fields.add((Field)new LongPoint(field, new long[]{(Long)value}));
                fields.add((Field)new StringField(field, String.valueOf(value), Field.Store.NO));
            }
            if (EnumSet.of(JsonType.ARRAY, JsonType.OBJECT, JsonType.BOOLEAN).contains(type)) {
                assert (value instanceof String);
                fields.add((Field)new TextField(field, (String)value, Field.Store.NO));
            }
            if (type == JsonType.STRING) {
                if (field.endsWith("-reg")) {
                    fields.add((Field)new StringField(field.replace("-reg", ""), (String)value, Field.Store.NO));
                } else {
                    fields.add((Field)new TextField(field, (String)value, Field.Store.NO));
                }
            }
        }
        return fields;
    }

    private static void writeDocs(StandardAnalyzer analyzer, MMapDirectory memoryIndex, List<Document> docs) {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)analyzer);
        IndexWriter writer = new IndexWriter((Directory)memoryIndex, indexWriterConfig);
        writer.deleteAll();
        for (Document doc : docs) {
            writer.addDocument((Iterable)doc);
        }
        writer.close();
    }

    private static List<Document> results(MMapDirectory memoryIndex, Query query) {
        DirectoryReader indexReader = DirectoryReader.open((Directory)memoryIndex);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        return Arrays.stream(searcher.search((Query)query, (int)5000).scoreDocs).map(s -> LuceneSearch.pullDoc(searcher, s)).collect(Collectors.toList());
    }

    private static Document pullDoc(IndexSearcher searcher, ScoreDoc scoreDoc) {
        try {
            return searcher.doc(scoreDoc.doc);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static ArrayList<String> getFields(Query query, ArrayList<String> fields) {
        if (query instanceof BooleanQuery) {
            ((BooleanQuery)query).clauses().forEach(c -> LuceneSearch.getFields(c.getQuery(), fields));
        }
        if (query instanceof WildcardQuery) {
            fields.add(((WildcardQuery)query).getTerm().field());
            return fields;
        }
        if (query instanceof RegexpQuery) {
            fields.add(((RegexpQuery)query).getField() + "-reg");
            return fields;
        }
        if (query instanceof TermQuery) {
            fields.add(((TermQuery)query).getTerm().field());
            return fields;
        }
        if (query instanceof PhraseQuery) {
            Stream.of(((PhraseQuery)query).getTerms()).forEach(t -> fields.add(t.field()));
            return fields;
        }
        if (query instanceof TermRangeQuery) {
            fields.add(((TermRangeQuery)query).getField());
            return fields;
        }
        return fields;
    }

    private static Triple<JsonType, Object, String> createTriple(JsonObject json, String field) {
        Pair<JsonType, Object> pair = LuceneSearch.getValue(json, field);
        return Triple.of((Object)((JsonType)pair.getLeft()), (Object)pair.getRight(), (Object)field);
    }

    private static Pair<JsonType, Object> getValue(JsonObject json, String field) {
        JsonType type;
        int period = field.indexOf(46);
        if (period > -1) {
            JsonObject nextObj = json.get(field.substring(0, period)).asObject();
            String nextField = field.substring(period + 1);
            return LuceneSearch.getValue(nextObj, nextField);
        }
        String tfield = field.replace("-reg", "");
        JsonValue myVal = json.get(tfield);
        JsonType jsonType = type = myVal != null ? myVal.getType() : null;
        if (type == null) {
            return Pair.of((Object)JsonType.NULL, null);
        }
        if (type == JsonType.STRING) {
            return Pair.of((Object)JsonType.STRING, (Object)json.getString(tfield, ""));
        }
        if (type == JsonType.BOOLEAN) {
            return Pair.of((Object)JsonType.BOOLEAN, (Object)String.valueOf(json.getBoolean(tfield, false)));
        }
        if (type == JsonType.NUMBER) {
            return Pair.of((Object)JsonType.NUMBER, (Object)json.getLong(tfield, 0L));
        }
        if (type == JsonType.ARRAY) {
            return Pair.of((Object)JsonType.ARRAY, (Object)json.get(tfield).asArray().toString());
        }
        if (type == JsonType.OBJECT) {
            return Pair.of((Object)JsonType.OBJECT, (Object)json.get(tfield).toString());
        }
        return Pair.of((Object)JsonType.DSF, (Object)json.get(tfield));
    }

    @Generated
    public LuceneSearch(MgmtManagerFactory<? extends ServicesManager> mgmtManagerFactory, CasManagementConfigurationProperties managementProperties) {
        this.mgmtManagerFactory = mgmtManagerFactory;
        this.managementProperties = managementProperties;
    }
}

