/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mgmt.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.CasManagementConfigurationProperties;
import org.apereo.cas.mgmt.MgmtManagerFactory;
import org.apereo.cas.mgmt.PendingRequests;
import org.apereo.cas.mgmt.authentication.CasUserProfileFactory;
import org.apereo.cas.mgmt.controller.ChangeController;
import org.apereo.cas.mgmt.controller.CommitController;
import org.apereo.cas.mgmt.controller.HistoryController;
import org.apereo.cas.mgmt.factory.RepositoryFactory;
import org.apereo.cas.mgmt.factory.VersionControlManagerFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.resource.RegisteredServiceResourceNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casManagementVersionControlConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class, CasManagementConfigurationProperties.class})
public class CasManagementVersionControlConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasManagementVersionControlConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private CasManagementConfigurationProperties managementProperties;
    @Autowired
    @Qualifier(value="casUserProfileFactory")
    private ObjectProvider<CasUserProfileFactory> casUserProfileFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private ObjectProvider<PendingRequests> pendingRequests;
    @Autowired
    @Qualifier(value="namingStrategy")
    private ObjectProvider<RegisteredServiceResourceNamingStrategy> namingStrategy;

    @Bean(name={"managerFactory"})
    public MgmtManagerFactory managerFactory() {
        return new VersionControlManagerFactory((ServicesManager)this.servicesManager.getIfAvailable(), this.managementProperties, this.repositoryFactory(), (CasUserProfileFactory)this.casUserProfileFactory.getIfAvailable(), this.casProperties, (RegisteredServiceResourceNamingStrategy)this.namingStrategy.getIfAvailable());
    }

    @Bean
    public RepositoryFactory repositoryFactory() {
        return new RepositoryFactory(this.managementProperties, (CasUserProfileFactory)this.casUserProfileFactory.getIfAvailable());
    }

    @Bean
    public CommitController commitController() {
        return new CommitController(this.repositoryFactory(), (CasUserProfileFactory)this.casUserProfileFactory.getIfAvailable(), this.managementProperties, (ServicesManager)this.servicesManager.getIfAvailable(), this.pendingRequests);
    }

    @Bean
    public ChangeController changeController() {
        return new ChangeController(this.repositoryFactory(), this.managerFactory(), (CasUserProfileFactory)this.casUserProfileFactory.getIfAvailable());
    }

    @Bean
    public HistoryController historyController() {
        return new HistoryController(this.repositoryFactory(), this.managerFactory(), (CasUserProfileFactory)this.casUserProfileFactory.getIfAvailable());
    }
}

