/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.examples.esper;

import com.espertech.esper.client.EventBean;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.Main;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyRouteBuilder
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyRouteBuilder.class);

    public static void main(String ... args) throws Exception {
        Main.main((String[])args);
    }

    public void configure() {
        this.from("activemq:EventStreamQueue").to("esper://feed");
        this.from("esper://feed?eql=insert into TicksPerSecond select feed, count(*) as cnt from org.apacheextras.camel.examples.esper.MarketDataEvent.win:time_batch(1 sec) group by feed").to("esper://feed");
        this.from("esper://feed?eql=select feed, avg(cnt) as avgCnt, cnt as feedCnt from TicksPerSecond.win:time(10 sec) group by feed + having cnt < avg(cnt) * 0.75").process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                EventBean event = (EventBean)exchange.getIn().getBody(EventBean.class);
                Map map = (Map)event.getUnderlying();
                LOGGER.info("Event map := {}", (Object)map);
            }
        });
    }
}

