/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.examples.esper;

import java.io.Serializable;
import java.util.Random;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apacheextras.camel.examples.esper.FeedEnum;
import org.apacheextras.camel.examples.esper.MarketDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketDataSendRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarketDataSendRunnable.class);
    private volatile FeedEnum rateDropOffFeed;
    private volatile boolean isShutdown;
    private Random random = new Random();
    private String user = ActiveMQConnection.DEFAULT_USER;
    private String password = ActiveMQConnection.DEFAULT_PASSWORD;
    private String url = "tcp://localhost:61616";
    private boolean transacted = false;
    private String subject = "EventStreamQueue";
    private boolean persistent = true;

    @Override
    public void run() {
        LOGGER.info(".call Thread " + Thread.currentThread() + " starting");
        try {
            Connection connection = null;
            Queue destination = null;
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.user, this.password, this.url);
            connection = connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(this.transacted, 1);
            destination = session.createQueue(this.subject);
            MessageProducer producer = session.createProducer((Destination)destination);
            if (this.persistent) {
                producer.setDeliveryMode(2);
            }
            while (!this.isShutdown) {
                int nextFeed = Math.abs(this.random.nextInt() % 2);
                FeedEnum feed = FeedEnum.values()[nextFeed];
                if (this.rateDropOffFeed == feed) continue;
                ObjectMessage message = session.createObjectMessage();
                message.setObject((Serializable)new MarketDataEvent("SYM", feed));
                producer.send((Message)message);
            }
            producer.close();
            session.close();
            connection.close();
        }
        catch (RuntimeException ex) {
            LOGGER.error("Error in send loop", (Throwable)ex);
        }
        catch (JMSException e) {
            LOGGER.error("Detected a JMS error '{}' caused by '{}'", (Object)e.getMessage(), (Object)e);
        }
        LOGGER.info(".call Thread " + Thread.currentThread() + " done");
    }

    public void setRateDropOffFeed(FeedEnum feedToDrop) {
        this.rateDropOffFeed = feedToDrop;
    }

    public void setShutdown() {
        this.isShutdown = true;
    }
}

