/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.examples.esper;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apacheextras.camel.examples.esper.FeedEnum;
import org.apacheextras.camel.examples.esper.MarketDataSendRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedSimMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedSimMain.class);
    private int numberOfThreads;
    private double dropProbability;
    private int numSeconds;

    public static void main(String[] args) throws IOException, InterruptedException {
        int numberOfSeconds;
        double dropProbability;
        int numberOfThreads;
        if (args.length < 3) {
            LOGGER.info("Arguments are: <number of threads> <drop probability percent> <number of seconds to run>");
            LOGGER.info("  number of threads: the number of threads sending feed events into the engine");
            LOGGER.info("  drop probability percent: a number between zero and 100 that dictates the ");
            LOGGER.info("                            probability that per second one of the feeds drops off");
            LOGGER.info("  number of seconds: the number of seconds the simulation runs");
            System.exit(-1);
        }
        try {
            numberOfThreads = Integer.parseInt(args[0]);
        }
        catch (NullPointerException e) {
            LOGGER.error("'{}' caused by '{}'", (Object)e.getMessage(), (Object)e);
            LOGGER.info("Invalid number of threads:" + args[0]);
            System.exit(-2);
            return;
        }
        try {
            dropProbability = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            LOGGER.error("'{}' caused by '{}'", (Object)e.getMessage(), (Object)e);
            LOGGER.info("Invalid drop probability:" + args[1]);
            System.exit(-2);
            return;
        }
        try {
            numberOfSeconds = Integer.parseInt(args[2]);
        }
        catch (NullPointerException e) {
            LOGGER.error("'{}' caused by '{}'", (Object)e.getMessage(), (Object)e);
            LOGGER.info("Invalid number of seconds to run:" + args[2]);
            System.exit(-2);
            return;
        }
        LOGGER.info("Using " + numberOfThreads + " threads with a drop probability of " + dropProbability + "%, for " + numberOfSeconds + " seconds");
        FeedSimMain feedSimMain = new FeedSimMain(numberOfThreads, dropProbability, numberOfSeconds, true);
        feedSimMain.run();
    }

    public FeedSimMain(int numberOfThreads, double dropProbability, int numSeconds, boolean isWaitKeypress) {
        this.numberOfThreads = numberOfThreads;
        this.dropProbability = dropProbability;
        this.numSeconds = numSeconds;
    }

    public void run() throws IOException, InterruptedException {
        ExecutorService threadPool = Executors.newFixedThreadPool(this.numberOfThreads);
        MarketDataSendRunnable[] runnables = new MarketDataSendRunnable[this.numberOfThreads];
        for (int i = 0; i < this.numberOfThreads; ++i) {
            runnables[i] = new MarketDataSendRunnable();
            threadPool.submit(runnables[i]);
        }
        int seconds = 0;
        Random random = new Random();
        while (seconds < this.numSeconds) {
            FeedEnum feedToDropOff;
            ++seconds;
            Thread.sleep(1000L);
            if (random.nextDouble() * 100.0 < this.dropProbability) {
                feedToDropOff = FeedEnum.FEED_A;
                if (random.nextBoolean()) {
                    feedToDropOff = FeedEnum.FEED_B;
                }
                LOGGER.info("Setting drop-off for feed " + (Object)((Object)feedToDropOff));
            } else {
                feedToDropOff = null;
            }
            for (int i = 0; i < runnables.length; ++i) {
                runnables[i].setRateDropOffFeed(feedToDropOff);
            }
        }
        LOGGER.info("Shutting down threadpool");
        for (int i = 0; i < runnables.length; ++i) {
            runnables[i].setShutdown();
        }
        threadPool.shutdown();
        threadPool.awaitTermination(10L, TimeUnit.SECONDS);
    }
}

