/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.jdk;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.AbstractAware;

public class JdkLog
extends AbstractAware {
    private final transient Logger logger;

    public JdkLog(Logger logger) {
        this.logger = logger;
    }

    public JdkLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public JdkLog(String name) {
        this(Logger.getLogger(name));
    }

    private static void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = Thread.currentThread().getStackTrace();
        int found = -1;
        for (int i = steArray.length - 2; i > -1; --i) {
            String className = steArray[i].getClassName();
            if (!callerFQCN.equals(className)) continue;
            found = i;
            break;
        }
        if (found > -1) {
            StackTraceElement ste = steArray[found + 1];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTrace() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.FINEST, t, format, arguments);
    }

    @Override
    public boolean isDebug() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.FINE, t, format, arguments);
    }

    @Override
    public boolean isInfo() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarn() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.WARNING, t, format, arguments);
    }

    @Override
    public boolean isError() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, Level.SEVERE, t, format, arguments);
    }

    @Override
    public void log(String fqcn, org.aoju.bus.logger.level.Level level, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, switch (level) {
            case org.aoju.bus.logger.level.Level.TRACE -> Level.FINEST;
            case org.aoju.bus.logger.level.Level.DEBUG -> Level.FINE;
            case org.aoju.bus.logger.level.Level.INFO -> Level.INFO;
            case org.aoju.bus.logger.level.Level.WARN -> Level.WARNING;
            case org.aoju.bus.logger.level.Level.ERROR -> Level.SEVERE;
            default -> throw new Error(StringKit.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
        }, t, format, arguments);
    }

    private void logIfEnabled(String callerFQCN, Level level, Throwable throwable, String format, Object[] arguments) {
        if (this.logger.isLoggable(level)) {
            LogRecord record = new LogRecord(level, StringKit.format((CharSequence)format, (Object[])arguments));
            record.setLoggerName(this.getName());
            record.setThrown(throwable);
            JdkLog.fillCallerData(callerFQCN, record);
            this.logger.log(record);
        }
    }
}

