/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.commons;

import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.AbstractAware;
import org.aoju.bus.logger.level.Level;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApacheCommonsLog
extends AbstractAware {
    private final transient Log logger;
    private final String name;

    public ApacheCommonsLog(Log logger, String name) {
        this.logger = logger;
        this.name = name;
    }

    public ApacheCommonsLog(Class<?> clazz) {
        this(LogFactory.getLog(clazz), null == clazz ? "null" : clazz.getName());
    }

    public ApacheCommonsLog(String name) {
        this(LogFactory.getLog((String)name), name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTrace() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isTrace()) {
            this.logger.trace((Object)StringKit.format((CharSequence)format, (Object[])arguments), t);
        }
    }

    @Override
    public boolean isDebug() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isDebug()) {
            this.logger.debug((Object)StringKit.format((CharSequence)format, (Object[])arguments), t);
        }
    }

    @Override
    public boolean isInfo() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isInfo()) {
            this.logger.info((Object)StringKit.format((CharSequence)format, (Object[])arguments), t);
        }
    }

    @Override
    public boolean isWarn() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarn()) {
            this.logger.warn((Object)StringKit.format((CharSequence)format, (Object[])arguments));
        }
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isWarn()) {
            this.logger.warn((Object)StringKit.format((CharSequence)format, (Object[])arguments), t);
        }
    }

    @Override
    public boolean isError() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        if (this.isError()) {
            this.logger.warn((Object)StringKit.format((CharSequence)format, (Object[])arguments), t);
        }
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        switch (level) {
            case TRACE: {
                this.trace(t, format, arguments);
                break;
            }
            case DEBUG: {
                this.debug(t, format, arguments);
                break;
            }
            case INFO: {
                this.info(t, format, arguments);
                break;
            }
            case WARN: {
                this.warn(t, format, arguments);
                break;
            }
            case ERROR: {
                this.error(t, format, arguments);
                break;
            }
            default: {
                throw new Error(StringKit.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
            }
        }
    }
}

