/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.tinylog;

import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.AbstractAware;
import org.aoju.bus.logger.level.Level;
import org.pmw.tinylog.LogEntryForwarder;
import org.pmw.tinylog.Logger;

public class TinyLog
extends AbstractAware {
    private static final int DEPTH = 4;
    private int level;
    private String name;

    public TinyLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public TinyLog(String name) {
        this.name = name;
        this.level = Logger.getLevel((String)name).ordinal();
    }

    private static Throwable getLastArgumentIfThrowable(Object ... arguments) {
        if (ArrayKit.isNotEmpty((Object[])arguments) && arguments[arguments.length - 1] instanceof Throwable) {
            return (Throwable)arguments[arguments.length - 1];
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTrace() {
        return this.level <= org.pmw.tinylog.Level.TRACE.ordinal();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, org.pmw.tinylog.Level.TRACE, t, format, arguments);
    }

    @Override
    public boolean isDebug() {
        return this.level <= org.pmw.tinylog.Level.DEBUG.ordinal();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, org.pmw.tinylog.Level.DEBUG, t, format, arguments);
    }

    @Override
    public boolean isInfo() {
        return this.level <= org.pmw.tinylog.Level.INFO.ordinal();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, org.pmw.tinylog.Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarn() {
        return this.level <= org.pmw.tinylog.Level.WARNING.ordinal();
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, org.pmw.tinylog.Level.WARNING, t, format, arguments);
    }

    @Override
    public boolean isError() {
        return this.level <= org.pmw.tinylog.Level.ERROR.ordinal();
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, org.pmw.tinylog.Level.ERROR, t, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, this.toTinyLevel(level), t, format, arguments);
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.level <= this.toTinyLevel(level).ordinal();
    }

    private void logIfEnabled(String fqcn, org.pmw.tinylog.Level level, Throwable t, String format, Object ... arguments) {
        if (null == t) {
            t = TinyLog.getLastArgumentIfThrowable(arguments);
        }
        LogEntryForwarder.forward((int)4, (org.pmw.tinylog.Level)level, (Throwable)t, (String)format, (Object[])arguments);
    }

    private org.pmw.tinylog.Level toTinyLevel(Level level) {
        org.pmw.tinylog.Level tinyLevel;
        switch (level) {
            case TRACE: {
                tinyLevel = org.pmw.tinylog.Level.TRACE;
                break;
            }
            case DEBUG: {
                tinyLevel = org.pmw.tinylog.Level.DEBUG;
                break;
            }
            case INFO: {
                tinyLevel = org.pmw.tinylog.Level.INFO;
                break;
            }
            case WARN: {
                tinyLevel = org.pmw.tinylog.Level.WARNING;
                break;
            }
            case ERROR: {
                tinyLevel = org.pmw.tinylog.Level.ERROR;
                break;
            }
            case OFF: {
                tinyLevel = org.pmw.tinylog.Level.OFF;
                break;
            }
            default: {
                throw new Error(StringKit.format((String)"Can not identify level: {}", (Object[])new Object[]{level}));
            }
        }
        return tinyLevel;
    }
}

