/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.utils.CallerUtils;
import org.aoju.bus.core.utils.ResourceUtils;
import org.aoju.bus.logger.GlobalFactory;
import org.aoju.bus.logger.Log;
import org.aoju.bus.logger.dialect.commons.ApacheCommonsLogFactory;
import org.aoju.bus.logger.dialect.console.ConsoleLogFactory;
import org.aoju.bus.logger.dialect.jboss.JbossLogFactory;
import org.aoju.bus.logger.dialect.jdk.JdkLogFactory;
import org.aoju.bus.logger.dialect.log4j.Log4jLogFactory;
import org.aoju.bus.logger.dialect.log4j2.Log4j2LogFactory;
import org.aoju.bus.logger.dialect.slf4j.Slf4jLogFactory;
import org.aoju.bus.logger.dialect.tinylog.TinyLogFactory;

public abstract class LogFactory {
    protected String name;
    private Map<Object, Log> logCache;

    public LogFactory(String name) {
        this.name = name;
        this.logCache = new ConcurrentHashMap<Object, Log>();
    }

    public static LogFactory create() {
        LogFactory factory = LogFactory.doCreate();
        factory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", factory.name);
        return factory;
    }

    private static LogFactory doCreate() {
        try {
            return new Slf4jLogFactory(true);
        }
        catch (NoClassDefFoundError e) {
            Console.error((Object)e.getMessage());
            try {
                return new Log4j2LogFactory();
            }
            catch (NoClassDefFoundError e2) {
                Console.error((Object)e2.getMessage());
                try {
                    return new Log4jLogFactory();
                }
                catch (NoClassDefFoundError e3) {
                    Console.error((Object)e3.getMessage());
                    try {
                        return new ApacheCommonsLogFactory();
                    }
                    catch (NoClassDefFoundError e4) {
                        Console.error((Object)e4.getMessage());
                        try {
                            return new TinyLogFactory();
                        }
                        catch (NoClassDefFoundError e5) {
                            Console.error((Object)e5.getMessage());
                            try {
                                return new JbossLogFactory();
                            }
                            catch (NoClassDefFoundError e6) {
                                Console.error((Object)e6.getMessage());
                                URL url = ResourceUtils.getResource((String)"logging.properties");
                                return null != url ? new JdkLogFactory() : new ConsoleLogFactory();
                            }
                        }
                    }
                }
            }
        }
    }

    public static LogFactory getCurrentLogFactory() {
        return GlobalFactory.get();
    }

    public static LogFactory setCurrentLogFactory(Class<? extends LogFactory> logFactoryClass) {
        return GlobalFactory.set(logFactoryClass);
    }

    public static LogFactory setCurrentLogFactory(LogFactory logFactory) {
        return GlobalFactory.set(logFactory);
    }

    public static Log get(String name) {
        return LogFactory.getCurrentLogFactory().getLog(name);
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.getCurrentLogFactory().getLog(clazz);
    }

    public static Log get() {
        return LogFactory.get(CallerUtils.getCallers());
    }

    public String getName() {
        return this.name;
    }

    public Log getLog(String name) {
        Log log = this.logCache.get(name);
        if (null == log) {
            log = this.createLog(name);
            this.logCache.put(name, log);
        }
        return log;
    }

    public Log getLog(Class<?> clazz) {
        Log log = this.logCache.get(clazz);
        if (null == log) {
            log = this.createLog(clazz);
            this.logCache.put(clazz, log);
        }
        return log;
    }

    public abstract Log createLog(String var1);

    public abstract Log createLog(Class<?> var1);

    protected void checkLogExist(Class<?> logClassName) {
    }
}

