/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2022 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.aoju.bus.core.toolkit;

/**
 * 生成姓名
 *
 * @author Kimi Liu
 * @since Java 17+
 */
public class NameKit {

    /**
     * 中文姓
     */
    public static final String[] CN_LAST_NAME = {
            "怀", "老", "堂", "考", "逄", "栋", "树", "栗", "候", "通", "速", "校", "逢", "性",
            "倪", "逮", "逯", "堵", "栾", "耿", "桂", "聂", "衅", "遇", "聊", "行", "桐", "桑",
            "道", "桓", "塔", "硕", "塞", "衡", "衣", "桥", "表", "恭", "偶", "衷", "项", "须",
            "恽", "顾", "顿", "梁", "袁", "梅", "傅", "肇", "悉", "频", "邓", "肖", "邗", "邛",
            "颜", "邝", "悟", "邢", "那", "肥", "碧", "储", "墨", "邬", "袭", "邰", "邱", "邴",
            "邵", "邶", "邸", "邹", "检", "郁", "郎", "风", "郏", "郑", "裔", "郗", "裘", "郜",
            "郝", "飞", "烟", "惠", "胡", "胥", "郦", "僧", "磨", "僪", "士", "壬", "郭", "森",
            "郯", "声", "裴", "郸", "都", "能", "鄂", "愈", "焉", "植", "夏", "褒", "夔", "夕",
            "夙", "多", "褚", "愚", "鄞", "鄢", "焦", "大", "天", "夫", "脱", "夷", "示", "礼",
            "祁", "允", "元", "充", "兆", "酆", "奇", "祈", "慈", "奈", "奉", "光", "慎", "酒",
            "慕", "奕", "祖", "党", "楚", "奚", "祝", "祢", "全", "公", "六", "祭", "兰", "关",
            "兴", "其", "饶", "典", "养", "楼", "腾", "冀", "覃", "禄", "冉", "熊", "福", "冒",
            "首", "香", "禚", "军", "农", "冠", "妫", "冯", "况", "冷", "禹", "冼", "禽", "禾",
            "释", "秋", "始", "凌", "种", "野", "金", "姒", "姓", "委", "燕", "秘", "姚", "姜",
            "解", "凤", "秦", "臧", "姬", "凭", "称", "出", "函", "言", "刀", "刁", "威", "娄",
            "戈", "樊", "戊", "程", "戎", "税", "戏", "成", "刑", "舒", "刘", "战", "戚", "刚",
            "舜", "初", "戢", "利", "别", "爱", "戴", "户", "稽", "訾", "房", "所", "穆", "扈",
            "前", "才", "剑", "牛", "牟", "牢", "剧", "牧", "马", "扬", "良", "穰", "牵", "扶",
            "驹", "詹", "空", "艾", "承", "檀", "犁", "节", "抄", "骆", "骑", "芒", "抗", "折",
            "力", "功", "务", "窦", "芮", "励", "花", "劳", "犹", "势", "狂", "狄", "勇", "苌",
            "苍", "苏", "苑", "苗", "高", "招", "拜", "苟", "章", "勤", "童", "苦", "独", "竭",
            "端", "拱", "英", "竹", "竺", "勾", "茂", "范", "笃", "包", "茅", "茆", "謇", "化",
            "北", "次", "匡", "符", "欧", "笪", "第", "嬴", "茹", "区", "荀", "千", "荆", "华",
            "魏", "卑", "卓", "答", "孔", "单", "字", "南", "孙", "孛", "卜", "孝", "卞", "孟",
            "占", "止", "卢", "荣", "季", "荤", "步", "学", "武", "歧", "卫", "卯", "印", "危",
            "却", "卷", "捷", "卿", "简", "宁", "玄", "历", "宇", "守", "安", "玉", "厉", "宋",
            "王", "掌", "完", "厍", "宏", "宓", "箕", "宗", "莘", "官", "厚", "定", "宛", "宜",
            "宝", "实", "原", "管", "计", "宣", "接", "宦", "让", "莫", "宫", "环", "宰", "莱",
            "殳", "段", "家", "殷", "许", "容", "宾", "宿", "菅", "寇", "及", "毋", "友", "富",
            "双", "母", "寒", "毓", "叔", "毕", "诗", "受", "毛", "古", "召", "揭", "班", "可",
            "台", "史", "说", "叶", "寸", "诸", "司", "诺", "寻", "寿", "封", "理", "将", "谈",
            "合", "尉", "吉", "同", "谌", "后", "谏", "少", "向", "尔", "吕", "尚", "谢", "尤",
            "营", "琦", "尧", "萧", "萨", "谬", "谭", "谯", "琴", "水", "吴", "谷", "永", "尹",
            "吾", "尾", "局", "求", "居", "豆", "屈", "汉", "告", "籍", "展", "汗", "员", "葛",
            "汝", "瑞", "江", "屠", "池", "象", "董", "汤", "周", "摩", "汪", "山", "汲", "米",
            "类", "鱼", "呼", "鲁", "沃", "针", "沈", "蒉", "钊", "貊", "蒋", "和", "鲍", "咎",
            "沐", "岑", "撒", "粘", "沙", "蒙", "鲜", "钞", "钟", "粟", "钦", "璩", "钭", "钮",
            "蒯", "钱", "蒲", "岳", "咸", "蒿", "哀", "铁", "哈", "泉", "操", "铎", "法", "糜",
            "蓝", "蓟", "波", "泣", "泥", "蓬", "瓮", "泰", "银", "泷", "系", "锁", "甄", "崇",
            "洋", "锐", "唐", "崔", "甘", "错", "蔚", "洛", "贝", "生", "素", "贡", "蔡", "索",
            "用", "洪", "甫", "紫", "贯", "支", "贰", "田", "由", "贲", "甲", "申", "贵", "贸",
            "费", "改", "锺", "贺", "蔺", "贾", "资", "畅", "商", "镇", "嵇", "敏", "赏", "浑",
            "敖", "赖", "留", "赛", "敛", "镜", "赤", "浦", "赧", "赫", "敬", "浮", "赵", "海",
            "长", "涂", "薄", "善", "文", "越", "斋", "疏", "斐", "薛", "斛", "喜", "綦", "斯",
            "方", "喻", "於", "施", "旁", "旅", "藏", "旗", "无", "淡", "巢", "藤", "左", "淦",
            "巧", "门", "巨", "藩", "巩", "闪", "巫", "闫", "闭", "问", "路", "己", "闳", "巴",
            "闵", "时", "旷", "闻", "闽", "闾", "丁", "市", "昂", "布", "清", "帅", "万", "师",
            "嘉", "希", "昌", "不", "阎", "明", "丑", "易", "昔", "帖", "世", "丘", "阙", "丙",
            "阚", "业", "帛", "丛", "东", "昝", "星", "渠", "严", "春", "温", "席", "中", "阮",
            "是", "丰", "阳", "阴", "常", "游", "丹", "阿", "陀", "晁", "繁", "陆", "蹇", "么",
            "陈", "蹉", "义", "晋", "之", "乌", "虎", "晏", "乐", "乔", "乘", "乙", "湛", "乜",
            "九", "虞", "习", "虢", "书", "普", "景", "买", "干", "平", "年", "陶", "幸", "智",
            "登", "白", "百", "乾", "鹿", "广", "蚁", "庄", "隆", "庆", "皇", "皋", "隋", "于",
            "随", "源", "隐", "云", "库", "亓", "应", "五", "井", "隗", "庚", "府", "庞", "红",
            "亢", "溥", "亥", "度", "麦", "暨", "纪", "京", "皮", "纳", "暴", "麴", "纵", "康",
            "庹", "麻", "隽", "庾", "线", "雀", "仁", "练", "黄", "仆", "集", "仇", "盈", "终",
            "廉", "仉", "益", "介", "盍", "绍", "雍", "仍", "从", "黎", "经", "滑", "滕", "盖",
            "廖", "盘", "仙", "盛", "仝", "回", "满", "代", "令", "以", "绪", "雪", "仪", "续",
            "蛮", "仰", "仲", "曲", "绳", "仵", "延", "零", "雷", "相", "曹", "建", "任", "国",
            "曾", "开", "漆", "有", "伊", "朋", "霍", "伍", "伏", "缑", "休", "弓", "弘", "望",
            "霜", "伟", "真", "张", "圣", "弥", "伦", "在", "缪", "漫", "本", "圭", "弭", "眭",
            "伯", "朱", "朴", "强", "机", "似", "权", "但", "位", "李", "齐", "归", "青", "何",
            "罕", "靖", "罗", "潘", "佘", "余", "坚", "佛", "潜", "杜", "杞", "佟", "束", "睢",
            "督", "彤", "来", "车", "睦", "杨", "革", "彭", "潭", "杭", "潮", "靳", "佴", "佼",
            "载", "松", "板", "澄", "辉", "羊", "律", "融", "侍", "徐", "析", "林", "龙", "枚",
            "龚", "辛", "辜", "果", "枝", "依", "辟", "鞠", "御", "侨", "徭", "侯", "德", "边",
            "羽", "达", "羿", "瞿", "翁", "过", "城", "俎", "柏", "运", "柔", "进", "保", "俞",
            "连", "俟", "迟", "翟", "翠", "信", "查", "韦", "翦", "韩", "矫", "濮", "修", "迮",
            "柯", "濯", "柳", "石", "柴", "念", "韶", "忻",
            "夏侯", "钟离", "由念", "第五", "闻人", "漆雕", "令狐", "尤念", "段干", "但念", "富察",
            "呼延", "乌雅", "巫马", "夹谷", "端木", "司徒", "马佳", "仲孙", "万俟", "宇文", "百里",
            "东方", "谷梁", "微生", "南宫", "东门", "澹台", "穰念", "公羊", "妫念", "张廖", "锺离",
            "羊舌", "佟佳", "濮阳", "封念", "西门", "宗政", "宰父", "翦念", "仲长", "左丘", "尉迟",
            "慕容", "纳喇", "拓跋", "轩辕", "鲜于", "南门", "司马", "申屠", "费莫", "伦念", "司空",
            "公西", "长孙", "梁丘", "颛孙", "壤驷", "子车", "东郭", "公冶", "单于", "乌孙", "公良",
            "柴念", "那拉", "完颜", "图门", "上官", "司寇", "淳于", "乐正", "范姜", "公孙", "亓官",
            "诸葛", "皇甫", "赫连", "闾丘", "太叔", "欧阳", "公叔", "太史", "章佳", "碧鲁", "漆念",
            "张简"
    };

    /**
     * 中文名字
     */
    public static final String[] CN_FIRST_NAME = {
            "慕雁", "婉然", "月明", "觅儿", "高翰", "白曼", "怀思", "碧菡", "奇邃", "云岚", "惜文",
            "夏青", "俊雄", "俊雅", "馨蓉", "庄丽", "笛韵", "笑天", "舒怀", "梦琪", "清润", "萦心",
            "丹蝶", "长旭", "清涵", "方仪", "杰秀", "天瑞", "美丽", "清淑", "忻愉", "隽美", "碧萱",
            "淑君", "诗兰", "平灵", "柔淑", "晓山", "乐蓉", "良哲", "永新", "凡阳", "莹洁", "哲圣",
            "同化", "玉英", "天和", "萦怀", "伟毅", "凝雁", "炎彬", "伟诚", "长星", "笑妍", "瀚海",
            "清一", "景天", "信瑞", "鸿雪", "子凡", "古韵", "志文", "凝雨", "凝雪", "萦思", "阳炎",
            "忆枫", "波光", "吉玉", "致萱", "博裕", "秀艾", "问风", "志新", "凡白", "忻慕", "正德",
            "芳泽", "吉玟", "秀艳", "芳洁", "白枫", "昆明", "忆柏", "辰骏", "水晶", "芳洲", "代卉",
            "菡梅", "正志", "琳溪", "叶嘉", "永昌", "曼衍", "书艺", "冰岚", "永春", "梅风", "柔丽",
            "元槐", "安歌", "子爱", "融雪", "涵韵", "香蝶", "倩语", "乐蕊", "康裕", "梓露", "昕葳",
            "问夏", "良畴", "毅君", "白柏", "彭勃", "迎真", "恨瑶", "月朗", "雨竹", "曼梅", "凡雁",
            "景福", "代玉", "碧蓉", "妙松", "童彤", "浩慨", "黎明", "黎昕", "友安", "驰海", "凝静",
            "飞鸣", "正思", "亦竹", "运盛", "易蓉", "芷波", "以南", "志明", "傲安", "蔓菁", "飞鹏",
            "春芳", "新烟", "绍晖", "凯唱", "振平", "雅彤", "虹颖", "从阳", "飞鸿", "飞鸾", "胤文",
            "帅红", "秀英", "代双", "芳润", "萱彤", "友容", "香柏", "夜雪", "凌香", "寻巧", "昊明",
            "莞然", "绮艳", "紫夏", "阳焱", "昊昊", "淑哲", "代珊", "月杉", "宜楠", "凡霜", "向卉",
            "今雨", "彦珺", "宵晨", "怀慕", "姝美", "合瑞", "妙柏", "芮丽", "春英", "白桃", "晋鹏",
            "锦凡", "香柳", "雨筠", "向南", "洋洋", "静涵", "尔竹", "献仪", "忆梅", "自明", "若枫",
            "问香", "雅美", "昭懿", "彦君", "阳煦", "小宸", "新儿", "青亦", "静淑", "娅童", "寄蓉",
            "阳兰", "以珊", "寄蓝", "明旭", "盼夏", "含灵", "雅志", "昂杰", "安民", "白梅", "熙怡",
            "靖之", "茉莉", "雨安", "伟泽", "琴轩", "倚云", "星菱", "平凡", "丁辰", "辰宇", "白梦",
            "清漪", "熠彤", "明明", "映菡", "阳冰", "从雪", "易文", "香桃", "映菱", "巍昂", "驰丽",
            "兰蕙", "振强", "锐锋", "红豆", "寒荷", "永望", "湛蓝", "新冬", "飞绿", "霏霏", "宵月",
            "春荷", "尔安", "清佳", "从霜", "田然", "同和", "盼香", "静丹", "雪容", "映萱", "宏毅",
            "含烟", "香梅", "明智", "醉芙", "昆杰", "妙梦", "痴香", "尔容", "从露", "幻儿", "山灵",
            "笑笑", "优乐", "寄蕾", "令璟", "慧雅", "高懿", "皎月", "月桂", "月桃", "和蔼", "芮优",
            "冰巧", "韵宁", "古香", "盼秋", "秋芸", "谷枫", "秋芳", "寄文", "瀚漠", "静云", "泰然",
            "俊风", "碧春", "灵萱", "恬畅", "英朗", "芝兰", "悦乐", "清俊", "飞龙", "光誉", "鸿飞",
            "梓颖", "寻绿", "蔓蔓", "安波", "沛容", "子珍", "燕妮", "巧荷", "鸿风", "朝旭", "听然",
            "书萱", "韫素", "孤兰", "高扬", "元武", "秋英", "元正", "舒扬", "飞羽", "英杰", "韶容",
            "君博", "芮佳", "同甫", "桂芝", "兴文", "飞翔", "姝惠", "雅惠", "芷云", "美偲", "昕昕",
            "令锋", "振翱", "耘志", "初然", "羡丽", "怀芹", "觅双", "觅珍", "芮澜", "文静", "飞翰",
            "诗珊", "飞翮", "诗双", "明朗", "高芬", "笑容", "意致", "飞翼", "子琪", "哲妍", "希彤",
            "悦人", "华池", "皓月", "蕴秀", "清逸", "芸溪", "语儿", "宁乐", "子琳", "寄春", "驰轩",
            "思彤", "笑寒", "秋荣", "初兰", "婉君", "嘉石", "嘉音", "森丽", "鸿祯", "秋荷", "子瑜",
            "迎天", "绣文", "兴旺", "宜欣", "梦雨", "迎夏", "兴昌", "翠曼", "山兰", "浩荡", "施然",
            "淑雅", "娴雅", "燕婉", "思美", "天真", "问筠", "烨霖", "泰初", "和昶", "鸿福", "乐松",
            "雍恬", "明杰", "好洁", "越彬", "锐阵", "碧曼", "沛山", "格菲", "子璇", "平卉", "倩丽",
            "琬凝", "文石", "梦露", "天青", "星文", "冰绿", "娟妍", "惜梦", "怜翠", "秋莲", "承嗣",
            "濡霈", "奇玮", "之桃", "德水", "建茗", "沛岚", "妍歌", "雪峰", "成荫", "志行", "云心",
            "鸿禧", "谷梦", "卿月", "阳华", "和暄", "语冰", "梓馨", "范明", "天睿", "晓彤", "霞雰",
            "秀敏", "和暖", "舒荣", "暄妍", "丁兰", "夜天", "娟秀", "娜娜", "凌寒", "茜茜", "兰月",
            "悠逸", "语燕", "骊泓", "依美", "昕月", "宏浚", "叶飞", "骊洁", "淑静", "嘉颖", "思怡",
            "轩昂", "如波", "迎秋", "思思", "琛瑞", "娴静", "紫安", "恩霈", "问寒", "恨真", "冰彦",
            "怀莲", "雅懿", "千亦", "运馨", "依心", "恬雅", "希恩", "俨雅", "驰逸", "雅致", "青烟",
            "翠柏", "思恩", "天音", "思聪", "寒蕾", "天韵", "书文", "一凡", "雁芙", "娟娟", "星星",
            "俊驰", "静逸", "景山", "春蕾", "夜香", "悦远", "碧螺", "宜民", "健柏", "慧颖", "彤雯",
            "亦巧", "文墨", "燕子", "冰心", "翰藻", "星晖", "柔煦", "红云", "兴朝", "念蕾", "国安",
            "睿识", "曦之", "德泽", "鸿骞", "雪巧", "寄松", "睿诚", "仙韵", "彤霞", "星晴", "姝艳",
            "又绿", "念文", "智宇", "聪睿", "元洲", "巧蕊", "向阳", "梓婷", "宏深", "欢欣", "雪帆",
            "泰华", "蔚星", "绮文", "斯琪", "雅艳", "恬静", "书易", "幻玉", "谷槐", "琦珍", "琪华",
            "翠桃", "欣欣", "平和", "智宸", "嘉祥", "曼语", "鹏飞", "华清", "佳文", "暄婷", "彦露",
            "夏容", "玮艺", "心语", "嘉祯", "令雪", "莹然", "宏义", "孟君", "沈思", "心诺", "寄柔",
            "修雅", "茂材", "英楠", "畅然", "听南", "敏思", "幻珊", "夏寒", "晨希", "鹏天", "怡悦",
            "涵容", "晴岚", "翠梅", "嘉福", "德海", "运骏", "含玉", "嘉禧", "凯风", "凝竹", "靖儿",
            "学博", "梓童", "海荣", "春晓", "希慕", "竹悦", "德润", "雁荷", "幼珊", "永言", "良奥",
            "华乐", "新瑶", "初南", "贝丽", "暄嫣", "向雁", "春晖", "心水", "甘雨", "嘉禾", "思慧",
            "烨磊", "之槐", "向雪", "凯复", "奇略", "修真", "访风", "端懿", "易梦", "季同", "如之",
            "佩杉", "含双", "飞舟", "康泰", "亦绿", "逸丽", "巧春", "芷烟", "彩静", "宇达", "飞航",
            "向真", "听双", "鸿宝", "光济", "海莹", "曜灿", "秀曼", "咸英", "慧秀", "安澜", "琨瑜",
            "文姝", "兰梦", "贤淑", "琨瑶", "雁菱", "如云", "珺娅", "凝安", "海菡", "雪绿", "逸云",
            "德业", "光赫", "夏山", "绮晴", "乃欣", "奕叶", "向露", "博赡", "温书", "涵山", "雁菡",
            "承基", "初珍", "访天", "飞扬", "一南", "佳晨", "夏岚", "博超", "瑞渊", "博涉", "恨风",
            "燕岚", "邵美", "学名", "雨彤", "天禄", "怀蕾", "广君", "晓慧", "德义", "成文", "宏伟",
            "蒙雨", "云臻", "洋然", "芷兰", "琬琰", "博涛", "宏伯", "怀薇", "思懿", "美华", "鹏程",
            "泰和", "霞飞", "婷然", "芸儿", "微澜", "浩旷", "如仪", "绿蓉", "玉树", "灵松", "翰林",
            "昭昭", "逸仙", "慕山", "溥心", "秋春", "醉易", "小翠", "梦香", "秀杰", "飞英", "元亮",
            "慧婕", "旭东", "和裕", "子真", "牧歌", "洮洮", "弘致", "北嘉", "灵枫", "书蝶", "清卓",
            "清华", "艳娇", "寒松", "梦秋", "景平", "宛丝", "弘懿", "曜儿", "华辉", "芸熙", "承颜",
            "琰琬", "初瑶", "敏慧", "暮雨", "舒方", "雅萍", "辰龙", "瑞云", "巧曼", "君雅", "光临",
            "雪羽", "宏达", "良骥", "采绿", "暖姝", "骞泽", "田田", "爰爰", "伟兆", "良骏", "易槐",
            "寻芳", "芫华", "寻芹", "献玉", "米琪", "振荣", "觅露", "绣梓", "绿蕊", "阳嘉", "高明",
            "宏远", "家欣", "博丽", "春枫", "知慧", "高旻", "诗霜", "安邦", "雪翎", "高昂", "雁蓉",
            "婉静", "立果", "春柔", "春柏", "悦爱", "意蕴", "沙羽", "飞荷", "韶美", "海蓝", "飞捷",
            "真如", "远骞", "千儿", "从筠", "妍丽", "建明", "弘扬", "宛亦", "棠华", "骏伟", "思若",
            "令飒", "盼巧", "馨欣", "丽泽", "霞姝", "天骄", "德佑", "阳阳", "从安", "康乐", "念柏",
            "一瑾", "经武", "天空", "香波", "宏逸", "英武", "承天", "琳瑜", "飞莲", "正文", "云英",
            "金鹏", "一璇", "光亮", "秋月", "书桃", "淑婉", "宜人", "飞掣", "淑穆", "天媛", "香洁",
            "琼华", "娴婉", "绿旋", "洁玉", "莹华", "子石", "代天", "梅红", "茵茵", "春桃", "娅思",
            "思茵", "洛灵", "平雅", "嘉宝", "德辉", "嘉实", "孟阳", "瀚玥", "安然", "昆谊", "伶伶",
            "秀梅", "曼丽", "宏邈", "敏才", "良策", "乐欣", "嘉容", "琲瓃", "半烟", "笑翠", "莹玉",
            "念桃", "英毅", "芳华", "仙媛", "景彰", "志诚", "素怀", "千凝", "怀曼", "文宣", "祺然",
            "千凡", "德运", "寒梅", "斯雅", "华灿", "承福", "音悦", "秋蝶", "兴言", "景龙", "骏俊",
            "桂月", "春梅", "欣跃", "平露", "曼云", "新雅", "乐正", "梦竹", "寒梦", "醉蝶", "丹丹",
            "高朗", "思莹", "旭辉", "新雨", "新雪", "雅蕊", "忆丹", "思莲", "阳霁", "淳雅", "代秋",
            "孤阳", "意智", "稷骞", "寻菡", "忆之", "卓逸", "彩妍", "庆生", "伶俐", "子墨", "康伯",
            "绮梅", "寻菱", "念梦", "新霁", "苇然", "雁易", "建木", "秋柔", "宏儒", "光辉", "秋柏",
            "半兰", "令秋", "凯安", "丹云", "天宇", "绮梦", "慈心", "思菱", "海昌", "建本", "智纯",
            "名姝", "莹琇", "明诚", "凯定", "静珊", "思萌", "丹亦", "彭祖", "靖琪", "秋柳", "英豪",
            "幼白", "高杰", "冬莲", "格格", "任真", "晴美", "乐语", "丹溪", "元灵", "醉柳", "晓莉",
            "骏逸", "若淑", "恨竹", "凌翠", "娟巧", "桂枫", "萧曼", "熙星", "锐立", "博达", "梦安",
            "雅旋", "思萱", "觅风", "光远", "白云", "初阳", "致欣", "香之", "文山", "白亦", "微熹",
            "博远", "季雅", "淳静", "漾漾", "冬菱", "向秋", "麦冬", "婀娜", "怀柔", "瀚钰", "妙之",
            "宜修", "瑞灵", "半凡", "梦容", "梦寒", "芷珊", "骞仕", "芷珍", "永贞", "乐水", "灵槐",
            "婷玉", "觅夏", "含雁", "一嘉", "虹彩", "韦茹", "雅昶", "冰莹", "悦可", "虹影", "博瀚",
            "令婧", "志泽", "冬萱", "睿达", "伟博", "惜海", "乐池", "幻露", "开朗", "建柏", "方雅",
            "雅晗", "奇颖", "康适", "婉奕", "凡巧", "幼霜", "曼辞", "天籁", "华采", "优瑗", "希蓉",
            "新知", "皎洁", "依萱", "夏彤", "静和", "景胜", "芷琪", "卓然", "和歌", "怿悦", "冰菱",
            "旭炎", "怀桃", "端敏", "鹏鲲", "经赋", "瑜然", "竹萱", "绿蝶", "智美", "鹏鲸", "若云",
            "建树", "和正", "如冬", "南烟", "英资", "如冰", "恨寒", "初雪", "德元", "盼翠", "运鹏",
            "蕙芸", "学真", "心远", "高格", "谧辰", "飞薇", "山雁", "飞文", "运鸿", "荷紫", "宏爽",
            "康健", "梦山", "水丹", "蕴美", "语雪", "听露", "智志", "朋义", "如凡", "咏歌", "骊燕",
            "水之", "琪睿", "婉秀", "云蔚", "忆辰", "鹤骞", "清嘉", "冷荷", "悦和", "怀梦", "畅畅",
            "辰良", "涵忍", "俊弼", "梦岚", "蕙若", "哲彦", "绿柏", "明洁", "初露", "皓洁", "腾骏",
            "修竹", "元冬", "凝绿", "庄雅", "杉月", "菊华", "哲美", "俊彦", "米雪", "叶帆", "忆远",
            "雪艳", "绿柳", "乐贤", "思敏", "丽佳", "又莲", "谷之", "一雯", "安南", "晓蓝", "承安",
            "阳飇", "新颖", "安卉", "礼骞", "腾骞", "永丰", "飞昂", "婉娜", "海融", "元凯", "承宣",
            "俊美", "尔芙", "曜瑞", "宛儿", "冷菱", "骞信", "宜然", "以筠", "流丽", "纳兰", "又菡",
            "飞星", "阳飙", "芦雪", "志专", "千叶", "鸿彩", "力行", "向笛", "飞虎", "经业", "濮存",
            "冰蓝", "俊德", "志业", "庆雪", "谷云", "湉湉", "阳夏", "骏燕", "修筠", "琴雪", "梓彤",
            "代容", "鸿羲", "林帆", "娅芳", "子骞", "良工", "迎彤", "鸿德", "鸿羽", "冷萱", "惠丽",
            "悦畅", "熙柔", "和豫", "经义", "梓美", "庄静", "志义", "昊东", "丰熙", "哲思", "忆灵",
            "弘文", "慕思", "傲菡", "安双", "夜绿", "安珊", "鸿志", "慧巧", "清雅", "荏苒", "沛芹",
            "光熙", "彭魄", "昌淼", "柔雅", "茹薇", "依薇", "嘉平", "嘉年", "寻春", "以寒", "泽雨",
            "暄美", "晓蕾", "兰泽", "友菱", "凝心", "涵育", "荌荌", "清霁", "陶然", "弘新", "寄波",
            "俏美", "嘉庆", "勇捷", "红叶", "孟夏", "子童", "宏博", "丝琦", "海桃", "丝琪", "经亘",
            "沛若", "宛凝", "弘方", "安吉", "之云", "雁桃", "君婷", "锦程", "雅柏", "昊乾", "悦喜",
            "浩言", "锐精", "雅柔", "可心", "嘉纳", "才艺", "芮雅", "半双", "青雪", "安琪", "鹏鹍",
            "才良", "丹烟", "怜晴", "晓旋", "小萍", "天巧", "天工", "雨莲", "冰薇", "晗蕊", "孤风",
            "乐游", "元勋", "洁雅", "阳秋", "凝思", "冬易", "和泰", "莹白", "良平", "雁梅", "涵意",
            "和泽", "慕悦", "乐湛", "幻天", "星汉", "柔静", "朗丽", "晗蕾", "奥雅", "雪莲", "文康",
            "如南", "又蓝", "俊悟", "佁然", "若灵", "晓星", "长运", "叶彤", "安和", "悠雅", "祺瑞",
            "晓昕", "驰皓", "琴音", "翠丝", "子安", "元化", "兴贤", "子宁", "和洽", "曼冬", "忆然",
            "平婉", "子实", "启颜", "多思", "才英", "书语", "琴韵", "绍辉", "静白", "昊伟", "齐心",
            "立诚", "月灵", "依晨", "天干", "晗日", "乐人", "坚白", "曼凡", "驰雪", "明亮", "曼凝",
            "玉泉", "信鸥", "雪萍", "幻香", "飞松", "信鸿", "洁静", "希月", "诗筠", "星河", "罗绮",
            "问芙", "俊能", "芮静", "德华", "欣然", "翰池", "晨菲", "向山", "长逸", "忻欢", "晔晔",
            "语风", "运恒", "佑运", "初夏", "玉泽", "婉容", "清韵", "静雅", "凯康", "飞柏", "天纵",
            "奕奕", "嘉美", "星波", "星泽", "文彦", "颐然", "晗昱", "苑博", "良弼", "曦哲", "梅花",
            "含香", "嘉德", "晨萱", "才捷", "德厚", "文彬", "布衣", "炫明", "映波", "力言", "易云",
            "作人", "俊慧", "采莲", "沛萍", "嘉志", "燕舞", "葛菲", "星津", "晗晗", "卿云", "英达",
            "含秀", "星洲", "梅英", "灵波", "芷雪", "晓曼", "敏智", "白凡", "怡月", "慧美", "思松",
            "永逸", "白凝", "浩歌", "玄清", "文心", "小蕊", "盼芙", "笑萍", "惜灵", "明轩", "新立",
            "吉帆", "流逸", "文德", "傲薇", "会雯", "竹月", "思枫", "卓君", "雅楠", "怡木", "兴业",
            "光华", "慧心", "双文", "嘉怡", "湘云", "星海", "含娇", "明辉", "皓轩", "琼音", "若兰",
            "瑛琭", "尔蓉", "尔蓝", "小蕾", "文翰", "新竹", "寄云", "兴为", "楚楚", "秀洁", "傲旋",
            "天罡", "文耀", "采萱", "思柔", "南珍", "觅山", "温瑜", "平宁", "晨蓓", "高歌", "莺韵",
            "代巧", "明俊", "良翰", "颖然", "瑛瑶", "英逸", "昂然", "文思", "胤运", "明达", "平安",
            "溪蓝", "骏琛", "明远", "霞绮", "馨逸", "水儿", "梦影", "翰海", "虹英", "博厚", "雨文",
            "晶茹", "访彤", "筠竹", "元瑶", "宏畅", "鹏翼", "友易", "寻桃", "又晴", "傲易", "沛蓝",
            "芸静", "天心", "晓枫", "睿博", "一禾", "嘉悦", "南琴", "绮波", "美如", "新筠", "安阳",
            "曼卉", "霁芸", "朋兴", "秀越", "浩气", "星渊", "长兴", "俊才", "冰蝶", "问萍", "瑜璟",
            "典丽", "梓舒", "千雁", "幻竹", "承平", "昂熙", "依柔", "韦曲", "恬默", "寻梅", "乐逸",
            "采蓝", "亦旋", "天翰", "清奇", "俊良", "惜儿", "彦红", "雨旋", "冰枫", "玉书", "水冬",
            "嘉胜", "小星", "嘉惠", "小春", "鸿才", "俊艾", "春海", "菱凡", "霞影", "曜坤", "永元",
            "傲晴", "谷兰", "韶敏", "光启", "楠楠", "绍元", "安白", "水凡", "高谊", "清妍", "雨星",
            "莞尔", "紫菱", "骞北", "小晨", "文惠", "蓉城", "驰颖", "丹南", "清妙", "云梦", "俊拔",
            "沛文", "元甲", "柔妙", "紫萍", "清馨", "修平", "骏哲", "理群", "晓桐", "冬梅", "波峻",
            "颖初", "凝芙", "忆南", "浦泽", "惠然", "哲茂", "远悦", "乐邦", "曼珍", "昊然", "丝雨",
            "白卉", "嘉慕", "曼珠", "英光", "紫萱", "芬馥", "清秋", "天恩", "醉波", "昊焱", "俊英",
            "宏阔", "秀丽", "俊茂", "致远", "幼安", "瑞锦", "红雪", "晨旭", "彤彤", "合美", "运良",
            "展鹏", "承弼", "雨晨", "浩波", "妍和", "青香", "世韵", "天悦", "芝宇", "泰宁", "雨晴",
            "安国", "飞槐", "碧灵", "白玉", "坚壁", "冷松", "恬美", "曼吟", "采薇", "采文", "鸣晨",
            "丽华", "夏菡", "悠奕", "晨星", "智菱", "韦柔", "又松", "子帆", "听筠", "涵菡", "香卉",
            "安露", "鸿振", "骏喆", "歌云", "音景", "涵菱", "童欣", "笑旋", "锐志", "开诚", "兴运",
            "听安", "雪晴", "馨兰", "正诚", "灵溪", "桐欣", "孤容", "曾琪", "书云", "安青", "叶舞",
            "丽玉", "乐儿", "沛春", "三姗", "俊捷", "清婉", "半雪", "乐然", "思楠", "兴修", "锐翰",
            "朗然", "寒云", "柔婉", "素昕", "安静", "念之", "绮丽", "宛畅", "嘉致", "巍然", "若南",
            "悠馨", "和通", "又柔", "傲松", "夏萱", "正谊", "问蕊", "玉轩", "华皓", "湘灵", "丹琴",
            "明煦", "承德", "以彤", "若华", "嘉懿", "锐思", "令美", "欣可", "淑惠", "宏盛", "子平",
            "修齐", "元嘉", "采春", "浩浩", "凝荷", "浩涆", "瑰玮", "凌文", "成济", "承志", "雅歌",
            "念云", "高洁", "寄灵", "立人", "雪曼", "芳馥", "芷天", "半青", "芳馨", "懿轩", "明熙",
            "欣合", "丽珠", "月华", "问薇", "书仪", "昌燎", "令羽", "萌运", "天慧", "傲柏", "妙双",
            "睿哲", "妙珍", "晓楠", "文成", "傲柔", "依楠", "修美", "正豪", "绮云", "菱华", "晨曦",
            "景明", "丽君", "小枫", "叶芳", "迎荷", "向彤", "星辰", "凝莲", "紫蕙", "巧云", "明凝",
            "子默", "修德", "杨柳", "布欣", "彬彬", "梓莹", "嘉良", "笑晴", "波鸿", "元白", "夏蓉",
            "静秀", "轶丽", "水卉", "翊君", "逸雅", "雅诗", "涵蓄", "晨朗", "如雪", "坚秉", "冷梅",
            "悠婉", "彭彭", "奇希", "良才", "梓菱", "紫文", "紫薇", "骊雪", "令怡", "静姝", "恬悦",
            "兴邦", "暄莹", "奥婷", "淑慧", "忻乐", "浩淼", "高超", "岚霏", "承恩", "雪松", "骊霞",
            "友桃", "凌春", "箫吟", "志勇", "远航", "慧艳", "芸馨", "千风", "问春", "宜嘉", "静娴",
            "尔蝶", "贞静", "英勋", "锐意", "颐和", "运莱", "立轩", "长卿", "梓萱", "雨柏", "隽洁",
            "饮香", "浩丽", "浩渺", "静婉", "成业", "承悦", "玛丽", "天成", "凌晓", "昆卉", "友梅",
            "清宁", "立辉", "雪枫", "嘉茂", "驰婷", "智敏", "阳州", "安顺", "星火", "惜玉", "婷秀",
            "凌晴", "谷玉", "泽宇", "运菱", "珠星", "伟祺", "聪慧", "昌勋", "子美", "芸姝", "语山",
            "和光", "驰媛", "景曜", "盼旋", "婵娟", "淑懿", "开济", "紫易", "宛白", "偲偲", "和煦",
            "尔柳", "绿海", "之卉", "痴旋", "雪柳", "高义", "惜珊", "涵蕾", "元青", "慧英", "正浩",
            "建业", "英华", "嘉荣", "中震", "玟丽", "高丽", "秀逸", "建中", "文茵", "建义", "贞韵",
            "晴虹", "英卫", "芮安", "雨梅", "欣畅", "琦巧", "英卓", "沛柔", "亦梅", "夏旋", "之玉",
            "盼易", "慕蕊", "英博", "丰雅", "博雅", "茂典", "斯年", "曲静", "觅翠", "迎蓉", "梓蓓",
            "宏硕", "南霜", "舒云", "艳芳", "南露", "阳平", "悦媛", "子怀", "歆然", "成仁", "倩秀",
            "痴春", "蕴藉", "修能", "瑶瑾", "幻巧", "彦慧", "晶晶", "雅洁", "水瑶", "温韦", "光霁",
            "青寒", "静竹", "妍雅", "采枫", "虹星", "智明", "从菡", "子怡", "飞语", "甜恬", "千秋",
            "海超", "平绿", "之双", "楚洁", "婷婷", "昆琦", "浩漫", "涵易", "丝祺", "敬曦", "盼晴",
            "诗翠", "星然", "慧捷", "晴曦", "英叡", "又槐", "长钰", "涵映", "星光", "凝蕊", "铭晨",
            "玉兰", "令慧", "星儿", "笑柳", "安祯", "康盛", "正清", "智晖", "英发", "梓敏", "含巧",
            "诗怀", "正业", "元基", "采柳", "凌蝶", "韵梅", "祺祥", "夜蓉", "喜儿", "安福", "佩兰",
            "自珍", "宏壮", "惠君", "红香", "小楠", "鸿文", "康震", "燕晨", "静安", "泰鸿", "耘豪",
            "木兰", "寒烟", "松月", "曼雁", "欣嘉", "蔚然", "安妮", "维运", "祺福", "平彤", "子悦",
            "骊颖", "迎蕾", "凯捷", "雁丝", "友槐", "问枫", "紫杉", "宏大", "乐珍", "乐双", "绍钧",
            "飞沉", "奇志", "思语", "岚风", "映冬", "霞英", "高轩", "善和", "琇芳", "凝旋", "半香",
            "念烟", "如风", "凌柏", "琇芬", "泰平", "俊明", "暄文", "瑾瑜", "丝娜", "铃语", "子惠",
            "明珠", "抒怀", "弘毅", "采梦", "从蓉", "景行", "慕晴", "瑾瑶", "安娜", "海之", "悦宜",
            "平心", "奇思", "绮烟", "秀兰", "安娴", "书兰", "洛妃", "俊晖", "昆锐", "翰采", "云水",
            "吟怀", "碧玉", "琼岚", "俊晤", "新美", "夏月", "问柳", "曼青", "丹雪", "情韵", "浩瀚",
            "华奥", "蝶梦", "天菱", "鸿晖", "璇玑", "皓君", "春兰", "忆雪", "齐敏", "灿灿", "娅楠",
            "芷容", "高澹", "真茹", "高达", "阳德", "梦菡", "淳美", "阳羽", "俊智", "星爵", "彦芝",
            "金枝", "梦菲", "灵凡", "海亦", "白雪", "恨荷", "秋灵", "雅丹", "雅丽", "姝丽", "可昕",
            "高远", "寄南", "茂勋", "忆霜", "代芙", "星剑", "丽雅", "振海", "春冬", "英锐", "英哲",
            "浩邈", "乐和", "婉慧", "乐咏", "璇珠", "尔槐", "逸贤", "智杰", "代芹", "志用", "书凝",
            "建修", "寒凝", "问梅", "永长", "新翰", "绮兰", "微婉", "痴柏", "昕珏", "翠琴", "春燕",
            "梓暄", "南风", "香雪", "逸馨", "巧兰", "碧琴", "碧琳", "筠心", "若雁", "如馨", "明钰",
            "芃芃", "项禹", "高逸", "和玉", "澎湃", "盼柳", "经略", "从蕾", "曼音", "楚云", "雅云",
            "奇胜", "夜春", "海伦", "云泽", "思洁", "紫桐", "骏奇", "悠素", "耘涛", "忻然", "沛槐",
            "逸秀", "琇莹", "颐真", "运晟", "意远", "越泽", "高邈", "文敏", "骏祥", "英喆", "朵儿",
            "明哲", "香露", "鸿朗", "梅梅", "康顺", "姣丽", "华婉", "飞跃", "运虹", "骊娜", "骊娟",
            "乐生", "平惠", "子舒", "天蓉", "俊材", "璎玑", "幻翠", "湘君", "夏柳", "笑槐", "巧凡",
            "涵柳", "正信", "兴发", "永嘉", "德馨", "天蓝", "浩然", "叶春", "文斌", "嫔然", "玉华",
            "俊杰", "初彤", "依波", "贞婉", "寄琴", "安筠", "迎曼", "斌蔚", "星华", "仪芳", "语彤",
            "飞丹", "和同", "昂雄", "骊婧", "安宁", "山彤", "痴梅", "端丽", "涵桃", "艳蕊", "起运",
            "冉冉", "安安", "幼怡", "莉莉", "凝蝶", "昊嘉", "明喆", "思涵", "涵衍", "安宜", "寄瑶",
            "赫然", "康复", "弘济", "骊婷", "燕桦", "昆皓", "宇寰", "骊媛", "靖巧", "玉环", "佩玉",
            "芊芊", "醉冬", "颀秀", "宛妙", "艳蕙", "文昂", "玉珂", "冰洁", "安容", "安寒", "子芸",
            "语心", "以莲", "文昌", "梦蕊", "初翠", "仲舒", "长霞", "妙音", "昆雄", "思淼", "文星",
            "天薇", "半安", "向荣", "灵卉", "云淡", "司晨", "涵梅", "秀华", "惜雪", "谷雪", "建元",
            "千山", "清绮", "奇致", "澄邈", "雅达", "柔绚", "斌斌", "舒兰", "佩珍", "高兴", "和璧",
            "雅辰", "宛秋", "元驹", "莎莉", "妍妍", "梓柔", "海逸", "嫚儿", "银柳", "运杰", "娅欣",
            "凯旋", "晨欣", "书南", "访文", "文景", "春华", "暮芸", "思义", "玉琲", "冰海", "莎莎",
            "睿好", "弘深", "勇毅", "宵雨", "浩初", "慕梅", "驰鸿", "文虹", "彩萱", "梦旋", "慧晨",
            "恨蕊", "灵珊", "寻云", "怜云", "白风", "慧智", "经国", "琴心", "雅逸", "布侬", "小谷",
            "弘业", "素欣", "斐斐", "源源", "志国", "嘉月", "宏富", "玉瑾", "思源", "思云", "梦易",
            "兴生", "思溪", "华容", "奥维", "燕楠", "晓丝", "绮南", "妙颜", "依丝", "阳舒", "弘丽",
            "阳成", "书双", "云溪", "媛女", "和畅", "云亭", "嘉木", "文曜", "弘义", "心香", "星瑶",
            "霞文", "白夏", "曼妮", "琳怡", "翠阳", "昌盛", "觅荷", "怡乐", "代蓝", "雅健", "清心",
            "绮玉", "元魁", "平良", "夜柳", "绿兰", "善静", "歌吹", "天晴", "凝梦", "迎梅", "茹云",
            "彤蕊", "吉敏", "良朋", "靓影", "津童", "睿姿", "冬亦", "胤雅", "念珍", "宾白", "高爽",
            "书君", "念双", "如容", "书琴", "凡桃", "慧月", "梦晨", "韵诗", "冰之", "子菡", "依云",
            "弘亮", "瀚彭", "柔怀", "香天", "春琳", "璞玉", "海儿", "芮美", "清怡", "绿凝", "承教",
            "嫣然", "碧白", "丹秋", "德宇", "英睿", "曼婉", "敏丽", "忆秋", "暖暖", "良材", "颖颖",
            "乐圣", "俊楚", "俊楠", "元容", "雁兰", "白秋", "夜梅", "德容", "子萱", "秋华", "蓝尹",
            "醉卉", "攸然", "天曼", "锐藻", "辰沛", "文林", "思佳", "夜梦", "泽恩", "雨泽", "望雅",
            "绮琴", "成化", "访曼", "弘伟", "以蕊", "莘莘", "秋玉", "水风", "正初", "海冬", "浩博",
            "梓楠", "嘉树", "德寿", "文柏", "同方", "新苗", "修敏", "翠霜", "月天", "念瑶", "熙熙",
            "宛筠", "梦月", "英韶", "香馨", "吉星", "桂华", "琇晶", "博学", "海凡", "静美", "宏峻",
            "丽姝", "岚岚", "清悦", "天材", "昆颉", "秋珊", "爰美", "雁凡", "思远", "修文", "梓榆",
            "易真", "思迪", "朝雨", "高卓", "文栋", "琼怡", "丽姿", "博简", "彦昌", "秋双", "琼思",
            "璞瑜", "锐智", "冷之", "昕雨", "柔惠", "昭君", "阳荣", "怀玉", "昊硕", "泽惠", "博实",
            "以旋", "煜祺", "驰翰", "博容", "翔飞", "明知", "向薇", "向文", "建华", "傲丝", "康宁",
            "力勤", "芮悦", "乐音", "平莹", "雅凡", "成双", "璠瑜", "和雅", "萌阳", "霞月", "依辰",
            "康安", "彭薄", "新荣", "惜天", "颖馨", "玟玉", "含芙", "冷亦", "玲然", "妞妞", "云逸",
            "玄雅", "寄真", "娇洁", "悦心", "昕靓", "骞骞", "飞烟", "傲之", "仪文", "又亦", "高原",
            "旭尧", "陶宁", "杏儿", "星阑", "湛雨", "芝英", "妙婧", "采波", "修明", "浦和", "素洁",
            "陶宜", "俊誉", "峻熙", "颖秀", "婷美", "韵流", "安平", "曼安", "恨蝶", "子蕙", "兴国",
            "听芹", "昊磊", "旻骞", "白竹", "吉月", "傲云", "平萱", "小之", "向明", "英飙", "珍丽",
            "雅爱", "映阳", "静恬", "令暎", "以晴", "湛霞", "伟彦", "曼容", "惜香", "心宜", "布凡",
            "悦怡", "其雨", "飞光", "子薇", "亦丝", "晨涛", "飞兰", "诗蕊", "绍祺", "欣笑", "敏达",
            "冬灵", "山芙", "安康", "典雅", "和静", "歌阑", "萍雅", "若骞", "怜烟", "灵阳", "梦桃",
            "风华", "萧玉", "昊天", "湛静", "成周", "建同", "曼寒", "永福", "玄静", "谷秋", "梦桐",
            "流如", "思烟", "骞魁", "幼荷", "承望", "成和", "小溪", "正卿", "语芹", "向晨", "诗文",
            "优悠", "尔丝", "梧桐", "优悦", "忆安", "白筠", "晓灵", "倩美", "伟志", "长娟", "英奕",
            "诗蕾", "清懿", "刚捷", "悦恺", "凌波", "清舒", "亦云", "白安", "星雨", "飞燕", "林楠",
            "忻畅", "圣杰", "彦杉", "振凯", "映雁", "丹寒", "钰凯", "子明", "子昂", "家馨", "雁卉",
            "平蓝", "听荷", "映雪", "晏然", "乐天", "白容", "访梦", "景浩", "恨桃", "熙华", "暖梦",
            "书白", "箫笛", "晴波", "馨香", "和韵", "含莲", "琳芳", "安彤", "子晋", "秀隽", "桐华",
            "映真", "尔云", "梓欣", "幼菱", "英秀", "季萌", "孤菱", "秀雅", "听莲", "书雁", "曼岚",
            "韶丽", "丽容", "寻冬", "嘉言", "灵雨", "孤萍", "巍奕", "寒雁", "流婉", "奇文", "慕诗",
            "以松", "锦文", "依然", "丝微", "怡然", "弘光", "静慧", "雯丽", "幼萱", "芙蓉", "和硕",
            "音仪", "君昊", "修杰", "水竹", "寻凝", "清芬", "骊红", "星睿", "令枫", "丹山", "雨伯",
            "代柔", "润丽", "骞尧", "余妍", "觅晴", "安翔", "颜骏", "念雁", "舒畅", "和顺", "安志",
            "余馥", "盼波", "春雪", "俊语", "思凡", "春雨", "晓兰", "诗晗", "和颂", "高畅", "平文",
            "寄风", "玉韵", "玉石", "向松", "俊民", "芬芬", "家骏", "景中", "雪漫", "湛颖", "玉堂",
            "萍韵", "白山", "山菡", "温纶", "昊穹", "沈然", "阳文", "韶仪", "以柳", "嘉誉", "戈雅",
            "安怡", "斯文", "夏波", "弘量", "芳懿", "昊空", "新蕾", "元纬", "念真", "浩阔", "秋阳",
            "雅珺", "和风", "代桃", "今歌", "念霜", "念露", "华彩", "海瑶", "言心", "骏年", "雅可",
            "英媛", "凌丝", "新文", "晓凡", "冠玉", "梦槐", "叶欣", "晨潍", "依凝", "俊豪", "德庸",
            "雨信", "斯斯", "晓燕", "振华", "琼芳", "坚成", "问丝", "友灵", "岚彩", "振博", "惜筠",
            "阳旭", "冰冰", "华美", "代梅", "绮露", "痴海", "晨轩", "旭鹏", "翰音", "溪澈", "元绿",
            "平春", "运诚", "秋白", "雅琴", "昕妤", "歌韵", "妮娜", "令梓", "令梅", "如彤", "胤骞",
            "灵韵", "玮琪", "香岚", "北晶", "琼英", "冰凡", "若山", "翔宇", "晨辰", "永宁", "晴丽",
            "顺美", "逸美", "觅松", "高阳", "平晓", "瑞绣", "昆宇", "玲玲", "开畅", "玲珑", "宜年",
            "嘉歆", "骊美", "清莹", "永安", "紫丝", "优扬", "浩皛", "志学", "江雪", "华翰", "初蓝",
            "语蓉", "银河", "芳芳", "静芙", "含蕊", "晨濡", "璇娟", "密如", "惜寒", "映颖", "又儿",
            "涵涤", "伟懋", "柳思", "如心", "元彤", "岚翠", "鸿波", "芳苓", "俊贤", "阳晖", "野云",
            "锦曦", "康平", "闲丽", "乐章", "乐童", "涵润", "玲琅", "雨灵", "婉柔", "茗雪", "兰娜",
            "涵涵", "怜南", "昊宇", "盼丹", "薇歌", "含文", "成益", "翰墨", "闳丽", "黛娥", "元龙",
            "飞双", "飞珍", "觅柔", "向梦", "宏恺", "梓洁", "幼旋", "嘉许", "迎波", "瑞彩", "傲儿",
            "思卉", "新晴", "建白", "秋露", "紫云", "永寿", "溶溶", "怀雁", "凝洁", "玲琳", "蕴涵",
            "鹤梦", "贞怡", "瑶岑", "博延", "思博", "芬菲", "秀颖", "智渊", "元德", "芳荃", "学文",
            "语蕊", "诗柳", "睿广", "芳茵", "靖荷", "逸思", "弘化", "景辉", "元忠", "景澄", "高雅",
            "翰飞", "阳曦", "映天", "长岳", "伟才", "桃雨", "芸芸", "才俊", "天欣", "旭彬", "冬卉",
            "夏之", "阳曜", "芷若", "雅唱", "歌飞", "晶滢", "运洁", "怜珊", "宏胜", "蕙兰", "志尚",
            "湛娟", "嘉谊", "凡波", "语薇", "方方", "乐安", "傲冬", "凝海", "元思", "莹莹", "雅畅",
            "凯歌", "国源", "寻双", "新曦", "怜双", "芸若", "正阳", "尔烟", "菁英", "朗宁", "羽彤",
            "未央", "弘博", "飞瑶", "玄穆", "芸茗", "莺莺", "阳朔", "新月", "鑫鹏", "诗桃", "乐容",
            "平松", "寅骏", "轩秀", "妮子", "夏云", "慧语", "晓博", "乐家", "听春", "幼晴", "好慕",
            "迎海", "香巧", "丹红", "哲丽", "丰羽", "依玉", "珠轩", "雪儿", "珠佩", "宇航", "运浩",
            "弘厚", "芳菲", "梓涵", "海阳", "寻琴", "世英", "涵亮", "雨兰", "孤晴", "寒天", "元恺",
            "思琪", "景逸", "小凝", "昆峰", "映秋", "璇子", "宾实", "含景", "芷荷", "柔蔓", "熙阳",
            "隽雅", "思琳", "勇军", "如意", "蕊珠", "依珊", "伟茂", "睿彤", "巧风", "振锐", "正雅",
            "添智", "雪兰", "向槐", "溪儿", "光耀", "从波", "晶辉", "学智", "秀妮", "鹏池", "曼彤",
            "灵秀", "雨凝", "敏博", "智伟", "凝丝", "海白", "新林", "康德", "博耘", "娟丽", "凝丹",
            "灵秋", "初晴", "唱月", "亦凝", "雨燕", "德惠", "巧夏", "娇然", "沛儿", "易容", "语晨",
            "寒香", "开霁", "高韵", "菀菀", "正真", "怡君", "春妤", "尔冬", "雪冰", "睿德", "冰双",
            "冰珍", "子楠", "顺慈", "嘉泽", "红艳", "迎丝", "鸿云", "晗玥", "秋颖", "晓君", "新柔",
            "山晴", "乐山", "贤惠", "吉欣", "菁菁", "俊人", "恬欣", "依琴", "星驰", "丹彤", "正青",
            "俏丽", "秀娟", "梓云", "春姝", "忆彤", "森莉", "海雪", "凝云", "青文", "嘉赐", "睿思",
            "依瑶", "佳妍", "初曼", "荣轩", "和安", "兴学", "敏叡", "寄容", "弘和", "红英", "凡之",
            "怡和", "雁露", "怡璐", "秀婉", "景焕", "雅隽", "春娇", "晓瑶", "孤松", "宏才", "浩壤",
            "巧香", "和宜", "琳晨", "幻枫", "兴安", "瀚文", "绢子", "幼枫", "半芹", "文赋", "欣彩",
            "青旋", "欣彤", "逸致", "沛凝", "晗琴", "心思", "晶灵", "茂学", "心怡", "翠岚", "宏扬",
            "冷玉", "运乾", "睿聪", "欣美", "长平", "诗槐", "茂实", "丹翠", "宇荫", "鹏赋", "浩大",
            "秀媛", "友卉", "秀媚", "以欣", "幼柏", "新梅", "清昶", "嘉淑", "凯泽", "雅霜", "韫玉",
            "傲南", "叶丰", "初蝶", "听枫", "升荣", "香彤", "欣德", "芳蔼", "学林", "冷珍", "清晖",
            "夜云", "天泽", "芳蕤", "问儿", "驰文", "华芝", "安荷", "昆鹏", "飞阳", "叶丹", "白翠",
            "盈盈", "康胜", "痴灵", "若彤", "玉宇", "访波", "青易", "成天", "高飞", "芳蕙", "芷蓝",
            "鸿轩", "梦泽", "鹏海", "傲玉", "俊侠", "成礼", "美曼", "从丹", "醉香", "幻桃", "瀚昂",
            "雅静", "凌兰", "山蝶", "蓉蓉", "永年", "俊迈", "三春", "秀竹", "双玉", "恬谧", "语蝶",
            "骊艳", "俊达", "鹏涛", "雅青", "玉宸", "安莲", "星宇", "贞芳", "怡畅", "天赋", "鸿达",
            "飞白", "珊珊", "问兰", "震轩", "欣怡", "友珊", "宏茂", "俊远", "书竹", "语林", "初柔",
            "晓畅", "嘉丽", "淑贞", "幻梅", "哲瀚", "鸿运", "映安", "又琴", "昆纬", "鸿远", "可佳",
            "靖易", "欣怿", "永康", "含桃", "雨华", "春竹", "翰学", "昆纶", "初柳", "雨南", "淑贤",
            "华茂", "晴照", "元良", "思嘉", "丽思", "雍雅", "从云", "若翠", "雪卉", "烨赫", "鸿信",
            "小珍", "凝远", "语柔", "文丽", "怜阳", "乐巧", "芷文", "振国", "半莲", "嘉云", "俊逸",
            "文乐", "修诚", "睿慈", "丝萝", "山柳", "音华", "亦玉", "秀筠", "妙思", "经纬", "骊英",
            "语柳", "灵安", "端雅", "慧丽", "夏烟", "问凝", "水彤", "映寒", "西华", "芳春", "雅韵",
            "安萱", "友琴", "心愫", "雅韶", "珉瑶", "炳君", "经纶", "欢悦", "旎旎", "霓云", "真洁",
            "俊健", "鸣玉", "子欣", "飞雨", "鹏举", "元芹", "飞雪", "华荣", "乃心", "天路", "欣悦",
            "心慈", "弘阔", "灵寒", "修谨", "世敏", "瑞芝", "海颖", "温茂", "英纵", "雨双", "雨珍",
            "青曼", "盼兰", "梓倩", "力夫", "骊茹", "绿夏", "锐泽", "修永", "友瑶", "怡嘉", "元英",
            "玉山", "慧云", "古兰", "翠巧", "韶华", "小琴", "珑玲", "彗云", "玄素", "晶燕", "新觉",
            "月怡", "娴淑", "霞赩", "瑜英", "贝莉", "国兴", "恺歌", "素华", "小瑜", "曜文", "浩穰",
            "雯华", "碧巧", "河灵", "娅玟", "雪珍", "鹏云", "雪珊", "康成", "易巧", "艳丽", "梦丝",
            "静晨", "雁风", "山梅", "珍瑞", "怜雪", "思雅", "寻雪", "端静", "志强", "语梦", "思雁",
            "正奇", "夏兰", "宾鸿", "欣愉", "凯乐", "文滨", "昌黎", "俊郎", "苒苒", "骏英", "承泽",
            "笑卉", "涵煦", "雨琴", "采南", "嘉佑", "思雨", "痴凝", "梦之", "笑南", "博艺", "愉婉",
            "乐康", "正祥", "念寒", "辰君", "自强", "沛珊", "英彦", "依白", "青枫", "高驰", "驰月",
            "文漪", "月悦", "家美", "天亦", "谷翠", "妙意", "冬雁", "睿才", "弘雅", "惠美", "梦云",
            "云霞", "尔琴", "思真", "嘉澍", "青柏", "锦欣", "司辰", "冬雪", "弘益", "凡灵", "茹雪",
            "弘盛", "同济", "子民", "云露", "辰钊", "妍芳", "文轩", "真一", "骊萍", "静曼", "海女",
            "修洁", "丰茂", "雪瑶", "娜兰", "永怡", "晏静", "永思", "恨之", "姗姗", "甘泽", "宇文",
            "智刚", "弘图", "嘉运", "惠心", "采珊", "凝然", "奇正", "鸿煊", "鸿光", "修贤", "水悦",
            "竹雨", "元菱", "翠绿", "善思", "依霜", "珺俐", "春岚", "蓓蕾", "伟晔", "雯君", "恨云",
            "勇锐", "慕凝", "晨璐", "晓霜", "鸿熙", "靖柏", "良俊", "靖柔", "辰铭", "建章", "沈雅",
            "南莲", "晓露", "悠柔", "仙仪", "海秋", "烨伟", "千易", "可儿", "彭泽", "英耀", "易绿",
            "浩宕", "合乐", "天佑", "晨钰", "饮月", "问玉", "姝好", "绮山", "慧俊", "芳林", "玮奇",
            "勇男", "品韵", "静枫", "锦诗", "琇云", "凝冬", "冰真", "明德", "雅香", "自怡", "昌翰",
            "秋寒", "睿范", "骊蓉", "和平", "从灵", "滢渟", "景同", "鹏运", "悦来", "凡儿", "山槐",
            "兴平", "承业", "乐心", "晗雨", "半蕾", "辰锟", "智勇", "滨海", "颖慧", "紫南", "静柏",
            "宏放", "红旭", "明志", "曜曦", "青梦", "雅秀", "如蓉", "乐志", "闲华", "云韶", "芷蝶",
            "代丝", "言文", "兴庆", "安易", "真仪", "君豪", "彤云", "珠玉", "飞飙", "宛菡", "彭越",
            "紫玉", "流惠", "安春", "俊爽", "欣艳", "沈靖", "建安", "奇水", "金玉", "绿竹", "乐怡",
            "怀寒", "沈静", "英悟", "冷雁", "高寒", "安晏", "浓绮", "盈秀", "瑜蓓", "以丹", "运凡",
            "傲白", "姣妍", "修为", "运凯", "竹韵", "俊力", "冷雪", "醉山", "星鹏", "雅娴", "丽芳",
            "虹玉", "力学", "菀柳", "天逸", "囡囡", "妙芙", "骊文", "新语", "知睿", "景铄", "霞辉",
            "宏旷", "以云", "才哲", "华藏", "君洁", "滢滢", "曦晨", "冷霜", "香芹", "南蓉", "浩岚",
            "乐悦", "星纬", "彭丹", "云飞", "雅媚", "姣姣", "叶农", "菊月", "傲雪", "温文", "怀山",
            "瑜敏", "彭湃", "紫琼", "若芳", "又青", "心菱", "英慧", "和美", "开宇", "辰阳", "尔阳",
            "寄翠", "从冬", "慕卉", "念巧", "傲霜", "曜栋", "婉淑", "君浩", "思天", "项明", "金鑫",
            "高岑", "欣荣", "文光", "童童", "云天", "小雨", "茂彦", "乐意", "嘉熙", "若英", "锐达",
            "和志", "华晖", "从凝", "逸明", "鹏煊", "兴德", "燕珺", "小雯", "晶瑶", "承载", "烨烁",
            "婉清", "锐进", "曲文", "依风", "白莲", "弘壮", "刚毅", "元旋", "子丹", "尔白", "芊丽",
            "茂德", "小霜", "海宁", "鸿卓", "鸿博", "韶阳", "辰皓", "波涛", "修伟", "贝晨", "千柔",
            "逸春", "咏德", "觅丹", "高峯", "弘大", "歆美", "兴怀", "水芸", "高峰", "痴瑶", "晟睿",
            "南蕾", "烨烨", "雨雪", "晓夏", "访烟", "微月", "丹萱", "千柳", "密思", "恺乐", "阳波",
            "婉丽", "和怡", "晏如", "震博", "元明", "咏志", "兴思", "雨真", "香莲", "以轩", "高峻",
            "天元", "阳泽", "锐逸", "尔雅", "德明", "承运", "智鑫", "德昌", "玉龙", "博敏", "烨然",
            "职君", "飞驰", "俊友", "晴画", "夏瑶", "允晨", "笑阳", "雅宁", "俊发", "沛白", "惜芹",
            "诗丹", "夏璇", "冰夏", "红螺", "迎南", "白萱", "子亦", "新洁", "学民", "沙雨", "湛恩",
            "妙菡", "宏朗", "咏思", "运升", "博文", "香菱", "英才", "涵瑶", "安柏", "情文", "运华",
            "醉巧", "华月", "访儿", "谷芹", "秋巧", "雅安", "春绿", "烨煜", "觅云", "丝柳", "信然",
            "梓玥", "尔真", "采白", "经艺", "静槐", "雅容", "梦兰", "君丽", "蕴和", "淑然", "和悌",
            "俊名", "琛丽", "和悦", "思娜", "望慕", "鹤轩", "凝珍", "君之", "梓珊", "刚豪", "语诗",
            "曼蔓", "暄玲", "修远", "善芳", "夜卉", "香萱", "夜南", "如曼", "淑兰", "馥芬", "玉怡",
            "烨熠", "施诗", "沛雯", "若菱", "睿敏", "雅寒", "秀美", "雁山", "依秋", "彦灵", "乐成",
            "婉仪", "水荷", "泰河", "飞章", "访冬", "冰香", "睿文", "夜玉", "嘉勋", "可可", "和惬",
            "凯凯", "运珊", "冠宇", "光明", "翰翮", "笑雯", "巧绿", "博易", "梓琬", "南晴", "梦凡",
            "代灵", "姮娥", "凝琴", "博明", "娅静", "凡双", "宜春", "运珧", "曼文", "长莹", "桂帆",
            "德曜", "昊苍", "运发", "子轩", "康时", "雨石", "毅然", "英范", "芮欢", "芮欣", "辰韦",
            "明艳", "昊英", "理全", "刚洁", "长菁", "振宇", "平乐", "安梦", "立群", "如松", "运珹",
            "绮彤", "浩广", "涵畅", "忆敏", "恬然", "又夏", "梓瑶", "菲菲", "梓璐", "银瑶", "春翠",
            "望舒", "德本", "思嫒", "乐芸", "睿明", "俊哲", "腾逸", "子辰", "绮美", "妍晨", "音韵",
            "半梅", "佳美", "昌茂", "飞宇", "鸿哲", "兴腾", "喜悦", "问雁", "暄和", "如柏", "斯乔",
            "忆文", "谷菱", "赞怡", "凌雪", "子濯", "新之", "元蝶", "泽语", "白薇", "含海", "晓骞",
            "馨荣", "乐英", "嘉玉", "念念", "文华", "阳云", "樱花", "承允", "苑杰", "奇伟", "从珊",
            "翠芙", "同光", "泽民", "惜萍", "元枫", "宛曼", "彬炳", "野雪", "隽巧", "彬郁", "叶吉",
            "惜萱", "柔谨", "凌霜", "学海", "孟乐", "又香", "绮怀", "绮思", "依童", "丽文", "今瑶",
            "三诗", "飞尘", "雅素", "小夏", "嘉珍", "怀绿", "侠骞", "智阳", "俊喆", "鸿畅", "秋彤",
            "晴雪", "修然", "佳思", "成弘", "珠雨", "鸿畴", "梅雪", "幻丝", "锐利", "凌青", "紫雪",
            "涵阳", "琼诗", "若蕊", "怜容", "水蓉", "泰清", "赞悦", "元柳", "香薇", "松雪", "水蓝",
            "艳卉", "晴霞", "兰芝", "松雨", "幼丝", "运锋", "乐荷", "思宸", "悦欣", "尔风", "星腾",
            "雪风", "白易", "语海", "会欣", "香旋", "筠溪", "兰芳", "盼雁", "阳伯", "天华", "若薇",
            "荷珠", "妙旋", "翠茵", "孤丹", "书意", "梅青", "晓筠", "珺琦", "莺语", "晶霞", "梦华",
            "晨风", "良吉", "奇迈", "烨华", "忻忻", "斯伯", "以冬", "北辰", "文君", "令燕", "秋翠",
            "芸欣", "正平", "珺琪", "兰若", "嘉瑞", "闵雨", "骏桀", "成龙", "韵磬", "建弼", "含之",
            "怡宁", "兰英", "天玉", "淼淼", "盼盼", "淑华", "竹筱", "谷蓝", "慧君", "翠荷", "佳悦",
            "茂才", "水蕊", "虹雨", "灵慧", "柔洁", "泽洋", "阳辉", "孤云", "妙春", "秀慧", "学义",
            "玉成", "梦玉", "夏雪", "湛芳", "闲静", "文瑞", "香春", "语丝", "文瑶", "初之", "佳惠",
            "华楚", "书慧", "若星", "坚诚", "含云", "半槐", "信厚", "冰安", "愉心", "浩思", "奇逸",
            "宣朗", "惜蕊", "谷蕊", "芮波", "幼仪", "听云", "妙晴", "可嘉", "力强", "建德", "长文",
            "湛英", "夏真", "敏学", "凝阳", "忆曼", "碧莹", "思山"
    };

    /**
     * 中文名词
     */
    public static final String[] CN_NOUN = {
            "凉面", "便当", "毛豆", "花生", "可乐", "灯泡", "野狼", "背包", "眼神", "缘分", "雪碧",
            "人生", "牛排", "蚂蚁", "飞鸟", "灰狼", "斑马", "汉堡", "悟空", "巨人", "绿茶", "大碗",
            "墨镜", "魔镜", "煎饼", "月饼", "月亮", "星星", "芝麻", "啤酒", "玫瑰", "大叔", "小伙",
            "太阳", "树叶", "芹菜", "黄蜂", "蜜粉", "蜜蜂", "信封", "西装", "外套", "裙子", "大象",
            "猫咪", "母鸡", "路灯", "蓝天", "白云", "星月", "彩虹", "微笑", "摩托", "板栗", "高山",
            "大地", "大树", "砖头", "楼房", "水池", "鸡翅", "蜻蜓", "红牛", "咖啡", "枕头", "大船",
            "诺言", "钢笔", "刺猬", "天空", "飞机", "大炮", "冬天", "洋葱", "春天", "夏天", "秋天",
            "冬日", "航空", "毛衣", "豌豆", "黑米", "玉米", "眼睛", "老鼠", "白羊", "帅哥", "美女",
            "季节", "鲜花", "服饰", "裙子", "秀发", "大山", "火车", "汽车", "歌曲", "舞蹈", "老师",
            "导师", "方盒", "大米", "麦片", "水杯", "水壶", "手套", "鞋子", "鼠标", "手机", "电脑",
            "书本", "奇迹", "身影", "香烟", "夕阳", "台灯", "宝贝", "未来", "皮带", "钥匙", "心锁",
            "故事", "花瓣", "滑板", "画笔", "画板", "学姐", "店员", "电源", "饼干", "宝马", "过客",
            "大白", "时光", "石头", "钻石", "河马", "犀牛", "西牛", "绿草", "抽屉", "柜子", "往事",
            "寒风", "路人", "橘子", "耳机", "鸵鸟", "朋友", "苗条", "铅笔", "钢笔", "硬币", "热狗",
            "大侠", "御姐", "萝莉", "毛巾", "期待", "盼望", "白昼", "黑夜", "大门", "黑裤", "哑铃",
            "板凳", "枫叶", "荷花", "乌龟", "衬衫", "大神", "草丛", "早晨", "心情", "茉莉", "流沙",
            "蜗牛", "猎豹", "棒球", "篮球", "乐曲", "电话", "网络", "世界", "中心", "老虎", "鸭子",
            "羽毛", "翅膀", "外套", "丝袜", "书包", "钢笔", "冷风", "烤鸡", "大雁", "音响", "招牌",
            "冰棍", "帽子", "菠萝", "蛋挞", "香水", "吐司", "溪流", "黄豆", "樱桃", "花卷", "荔枝",
            "镜子", "曲奇", "酒窝", "紫菜", "金鱼", "柚子", "果汁", "项链", "煎蛋", "唇彩", "戒指",
            "雪糕", "睫毛", "铃铛", "手链", "香氛", "红酒", "月光", "酸奶", "蜡烛", "糖豆", "薯片",
            "口红", "豆芽", "发箍", "发卡", "发夹", "发带", "铃铛", "冬瓜", "香菇", "短靴", "草莓",
            "柠檬", "月饼", "百合", "纸鹤", "云朵", "芒果", "面包", "海燕", "龙猫", "唇膏", "鞋垫",
            "黑猫", "白猫", "金毛", "山水", "音响", "香蕉", "苹果", "鲤鱼", "鳗鱼", "鹦鹉", "袋鼠",
            "鲸鱼", "落日", "东风", "屋子", "创意", "报道", "下巴", "面子", "迷宫", "雪山", "沙子",
            "自行车", "保温杯", "数据线", "机器猫", "电灯胆", "白开水", "自行车", "钢铁侠", "仙人掌",
            "战斗机", "冥王星", "八宝粥", "胡萝卜", "小鸽子", "小蝴蝶", "爆米花", "泥猴桃", "小鸭子",
            "小海豚", "日记本", "小熊猫", "小懒猪", "小懒虫", "百褶裙", "帆布鞋", "火龙果", "奇异果",
            "金针菇", "小松鼠", "小虾米", "小土豆", "高跟鞋", "银耳汤", "咖啡豆", "小蜜蜂", "小蚂蚁",
            "棉花糖", "向日葵", "水蜜桃", "小蝴蝶", "小刺猬", "小丸子", "指甲油", "康乃馨", "超短裙",
            "乌冬面", "冰淇淋", "棒棒糖", "长颈鹿", "小馒头", "小笼包", "小甜瓜", "小兔子", "含羞草",
            "睫毛膏", "小蘑菇", "跳跳糖", "小白菜", "小天鹅", "小猫咪", "万宝路", "哈密瓜", "梅花鹿"

    };

    /**
     * 中文形容词
     */
    public static final String[] CN_ADJECTIVE = {
            "冷静的", "醉熏的", "潇洒的", "糊涂的", "积极的", "冷酷的", "深情的", "粗暴的", "温柔的",
            "可爱的", "愉快的", "义气的", "认真的", "威武的", "帅气的", "传统的", "潇洒的", "漂亮的",
            "自然的", "专一的", "听话的", "昏睡的", "狂野的", "等待的", "搞怪的", "幽默的", "魁梧的",
            "活泼的", "开心的", "高兴的", "超帅的", "坦率的", "直率的", "轻松的", "痴情的", "完美的",
            "精明的", "无聊的", "丰富的", "繁荣的", "饱满的", "炙热的", "暴躁的", "碧蓝的", "俊逸的",
            "英勇的", "健忘的", "故意的", "无心的", "土豪的", "朴实的", "兴奋的", "幸福的", "淡定的",
            "不安的", "阔达的", "孤独的", "独特的", "疯狂的", "时尚的", "落后的", "风趣的", "忧伤的",
            "大胆的", "爱笑的", "矮小的", "健康的", "合适的", "玩命的", "沉默的", "斯文的", "任性的",
            "细心的", "粗心的", "大意的", "甜甜的", "酷酷的", "健壮的", "英俊的", "霸气的", "阳光的",
            "默默的", "大力的", "孝顺的", "忧虑的", "着急的", "紧张的", "善良的", "凶狠的", "害怕的",
            "重要的", "危机的", "欢喜的", "欣慰的", "满意的", "跳跃的", "诚心的", "称心的", "如意的",
            "怡然的", "娇气的", "无奈的", "无语的", "激动的", "愤怒的", "美好的", "感动的", "激情的",
            "激昂的", "震动的", "虚拟的", "超级的", "寒冷的", "明理的", "犹豫的", "忧郁的", "寂寞的",
            "奋斗的", "勤奋的", "现代的", "过时的", "稳重的", "热情的", "含蓄的", "无辜的", "多情的",
            "纯真的", "拉长的", "热心的", "从容的", "体贴的", "风中的", "曾经的", "追寻的", "儒雅的",
            "优雅的", "开朗的", "外向的", "内向的", "清爽的", "文艺的", "长情的", "平常的", "单身的",
            "伶俐的", "高大的", "懦弱的", "柔弱的", "爱笑的", "乐观的", "耍酷的", "酷炫的", "神勇的",
            "年轻的", "唠叨的", "瘦瘦的", "无情的", "包容的", "顺心的", "畅快的", "舒适的", "靓丽的",
            "负责的", "背后的", "简单的", "谦让的", "彩色的", "缥缈的", "欢呼的", "生动的", "复杂的",
            "慈祥的", "仁爱的", "魔幻的", "虚幻的", "淡然的", "受伤的", "雪白的", "高高的", "糟糕的",
            "顺利的", "闪闪的", "羞涩的", "缓慢的", "迅速的", "优秀的", "聪明的", "含糊的", "俏皮的",
            "淡淡的", "坚强的", "平淡的", "欣喜的", "能干的", "灵巧的", "友好的", "机智的", "机灵的",
            "正直的", "谨慎的", "俭朴的", "殷勤的", "虚心的", "辛勤的", "自觉的", "无私的", "无限的",
            "踏实的", "老实的", "现实的", "可靠的", "务实的", "拼搏的", "个性的", "粗犷的", "活力的",
            "成就的", "勤劳的", "单纯的", "落寞的", "朴素的", "悲凉的", "忧心的", "洁净的", "清秀的",
            "自由的", "小巧的", "单薄的", "贪玩的", "刻苦的", "干净的", "壮观的", "和谐的", "文静的",
            "调皮的", "害羞的", "安详的", "自信的", "端庄的", "坚定的", "美满的", "舒心的", "温暖的",
            "专注的", "勤恳的", "美丽的", "腼腆的", "优美的", "甜美的", "甜蜜的", "整齐的", "动人的",
            "典雅的", "尊敬的", "舒服的", "妩媚的", "秀丽的", "喜悦的", "甜美的", "彪壮的", "强健的",
            "大方的", "俊秀的", "聪慧的", "迷人的", "陶醉的", "悦耳的", "动听的", "明亮的", "结实的",
            "魁梧的", "标致的", "清脆的", "敏感的", "光亮的", "大气的", "知性的", "冷傲的", "呆萌的",
            "野性的", "隐形的", "微笑的", "笨笨的", "难过的", "沉静的", "失眠的", "安静的", "纯情的",
            "迷路的", "烂漫的", "哭泣的", "贤惠的", "苗条的", "温婉的", "发嗲的", "贪玩的", "执着的",
            "花痴的", "高贵的", "傲娇的", "细腻的", "天真的", "怕黑的", "感性的", "飘逸的", "忐忑的",
            "高挑的", "傻傻的", "冷艳的", "懵懂的", "特别的", "未来的", "亲切的", "鲜艳的", "拥挤的",
            "爱听歌的", "还单身的", "怕孤单的", "留胡子的", "有魅力的", "老迟到的", "笑点低的",
            "火星上的", "要减肥的", "会撒娇的", "眯眯眼的", "心灵美的", "爱撒娇的", "想人陪的",
            "眼睛大的", "怕孤独的"
    };

    /**
     * 英文姓
     */
    public static final String[] EN_LAST_LIST = {
            "nings", "hale", "lvis", "hall", "todd", "via", "vid", "liot", "vic", "ted", "rad",
            "rae", "rah", "vin", "ral", "ten", "ram", "ter", "vis", "tes", "thus", "thur", "ray",
            "lins", "pont", "dawn", "glenn", "kuk", "rold", "cliff", "roll", "gold", "cer", "xon",
            "cey", "browne", "scott", "a", "rwood", "leif", "h", "tha", "n", "o", "the", "fast",
            "frances", "y", "clife", "sweet", "muel", "rone", "lith", "thy", "ning", "chill", "gou",
            "tia", "litt", "red", "thorne", "tie", "rian", "reg", "riam", "pag", "tin", "rel", "tim",
            "ren", "tio", "rias", "swift", "tis", "ret", "che", "res", "rex", "chi", "lace", "rey",
            "riah", "holmes", "phine", "yves", "cia", "cie", "child", "young", "cil", "hart", "cis",
            "miles", "ridge", "bruce", "live", "lius", "rick", "tle", "nior", "crofts", "well", "cke",
            "sworth", "ria", "rid", "ric", "wylde", "rie", "cky", "ries", "peg", "riet", "nah", "ril",
            "keats", "pel", "rin", "nal", "nan", "per", "ris", "jane", "nat", "nas", "raine", "neil",
            "quinn", "riel", "faithe", "gue", "braith", "gus", "nell", "guy", "saul", "vogt", "ton",
            "tom", "tance", "tian", "tor", "lain", "mund", "sharp", "sham", "cob", "twain", "shaw",
            "nise", "phy", "col", "con", "duke", "cent", "phael", "lett", "cox", "nee", "reau", "nel",
            "lan", "pir", "ner", "lap", "ale", "net", "nes", "las", "tra", "law", "ney", "lay", "shall",
            "phens", "cius", "snow", "rob", "rod", "bush", "roe", "trick", "rol", "ron", "bryce", "gill",
            "tier", "blume", "trice", "land", "roy", "ann", "tta", "ple", "phrey", "wald", "lamb",
            "nence", "nia", "nid", "nic", "nie", "lee", "jah", "nin", "tus", "len", "nio", "vian",
            "gins", "elroy", "ler", "nis", "bois", "let", "les", "rine", "nix", "lew", "ley", "jay",
            "tosh", "reed", "reen", "baird", "bohm", "dunn", "brooke", "cus", "penn", "nett", "poe",
            "ward", "worth", "pkins", "gray", "lard", "grace", "nald", "vice", "rion", "dodd", "peare",
            "gram", "yan", "black", "nest", "tout", "chard", "smith", "lia", "lie", "lynch", "lin",
            "pril", "moll", "hal", "lip", "han", "ham", "piers", "lis", "bias", "vier", "bian", "lix",
            "nand", "liz", "hugh", "lass", "ives", "vien", "camp", "kiel", "boyce", "yale", "shop",
            "pert", "rell", "non", "house", "nor", "mons", "tine", "rite", "green", "race", "yes", "yer",
            "war", "yet", "wat", "mond", "way", "grey", "miah", "drich", "funk", "watt", "greg", "dutt",
            "ryl", "croft", "jim", "alick", "nard", "broad", "fax", "tram", "cash", "rene", "fay", "tion",
            "gene", "harte", "carr", "niell", "mick", "judd", "loc", "diah", "bright", "lon", "dolph",
            "lop", "gail", "lor", "lot", "lou", "hume", "low", "tein", "wen", "wer", "more", "chad",
            "born", "dolf", "wey", "borg", "grid", "dick", "chell", "dad", "dice", "pys", "whit", "nus",
            "gess", "dan", "dam", "mott", "kins", "fer", "shua", "beau", "dict", "ving", "fey", "day",
            "bloor", "bott", "king", "grote", "job", "joe", "beck", "mike", "rett", "dore", "rald", "joy",
            "win", "sam", "wis", "chael", "san", "glan", "chel", "gale", "sar", "glas", "say", "maltz",
            "lyle", "chey", "earl", "cher", "fie", "joan", "lup", "del", "lus", "den", "der", "pham",
            "bar", "des", "ac", "giles", "kirk", "ah", "bill", "leste", "an", "trid", "mill", "boyd",
            "bby", "jones", "lynn", "frank", "velt", "dean", "strong", "dge", "be", "ters", "rence",
            "sea", "xine", "laine", "by", "sel", "sen", "ca", "ses", "ser", "ce", "bins", "ch", "sey",
            "ck", "kell", "co", "bing", "june", "cy", "paul", "hutt", "da", "dia", "lyn", "die", "de",
            "bee", "di", "bel", "dn", "ben", "ford", "do", "pher", "bes", "claude", "kent", "dy", "phen",
            "bey", "bird", "joel", "nuel", "ed", "ralph", "el", "tess", "brown", "er", "dike", "chards",
            "foe", "fe", "back", "bach", "sia", "sie", "fox", "sid", "leigh", "pound", "dine", "fy",
            "leign", "sil", "ga", "ge", "troy", "dwight", "nions", "go", "soll", "greve", "clare",
            "vieve", "gy", "clark", "hue", "fort", "bia", "grant", "he", "holt", "hum", "bin", "yonng",
            "soon", "hy", "fra", "chloe", "briel", "burns", "phia", "kerr", "bitt", "tience", "brey",
            "hood", "bell", "phil", "field", "steele", "pritt", "john", "je", "joyce", "don", "jo",
            "jy", "mag", "blair", "ke", "man", "mas", "mar", "may", "max", "sopp", "ment", "mens", "ky",
            "o'neil", "la", "le", "stuart", "li", "ghes", "hicks", "dred", "lo", "drea", "vans", "ly",
            "wright", "som", "logg", "dra", "son", "ma", "tham", "berg", "dith", "dre", "than", "sor",
            "me", "noah", "phne", "brian", "brook", "mo", "harine", "lance", "tate", "my", "yule", "na",
            "bob", "nd", "ne", "bon", "no", "louie", "sean", "ny", "bess", "meg", "tiane", "head", "hous",
            "meo", "men", "beth", "bald", "louis", "mer", "boyle", "mew", "ville", "kay", "clair", "tave",
            "bert", "finn", "drey", "burne", "drew", "dell", "pe", "fitch", "ps", "dric", "beard", "py",
            "walsh", "thew", "qe", "chols", "brow", "ther", "noel", "they", "clough", "thea", "ckens", "qy",
            "thel", "ra", "booth", "re", "trine", "rl", "loise", "ro", "rist", "mia", "ry", "mie", "dair",
            "sa", "se", "min", "ken", "sh", "belle", "ian", "lian", "fith", "kes", "ker", "sibyl", "fred",
            "liam", "wolf", "sy", "mann", "lome", "josh", "ta", "flower", "te", "hill", "stan", "mand",
            "stal", "to", "bur", "dys", "ty", "ice", "woolf", "jean", "wood", "bard", "zel", "crane", "zer",
            "va", "lice", "ve", "frey", "vi", "wyatt", "thia", "sing", "coln", "vy", "colm", "nold", "cole",
            "dams", "we", "jill", "gai", "kim", "kin", "ien", "gan", "kit", "nolds", "drow", "gar", "liet",
            "wy", "xe", "bart", "stone", "thodore", "ster", "mark", "xy", "jeff", "laide", "jeames", "ye",
            "mon", "mos", "maud", "niah", "price", "zie", "yy", "van", "matt", "keith", "ze", "ckey", "cker",
            "zy", "gee", "north", "james", "claire", "gel", "nick", "gen", "ges", "ger", "kyle", "morse",
            "get", "tricia", "wilde", "cook", "sell", "thune", "nice", "pold", "nore", "pole", "tours", "xia",
            "niel", "tab", "ven", "ver", "lotte", "vey", "niei", "webb", "cooke", "gia", "lind", "gie", "dave",
            "ruth", "cott", "ling", "line", "cah", "gil", "cam", "ckle", "leen", "can", "zoe", "cas", "car",
            "buck", "wells", "ine", "ing", "will", "rhys", "rusk", "jack", "ledk", "stowe", "york", "hearst",
            "reade", "loyd", "wild", "seph", "gust", "sper"
    };

    /**
     * 英文名称
     */
    public static final String[] EN_FIRST_LIST = {
            "Ter", "Wind", "Buck", "Glo", "Ray", "Black", "Bright", "Claire", "Blithe", "Vir",
            "O'Ca", "Rams", "Dawn", "Kirk", "Beck", "Mill", "Hob", "Hod", "Fitch", "Wins",
            "Gals", "Boyd", "Myr", "Tours", "Hoo", "Dave", "Steele", "Ruth", "Brian", "Dier",
            "Mike", "Hoy", "Piers", "Lind", "Bill", "Booth", "A", "Ab", "Ser", "June", "Ac",
            "B", "Ad", "E", "F", "Brews", "Ag", "Chil", "Flo", "I", "Elroy", "Al", "L", "Tha",
            "An", "Paul", "O", "Beer", "Hutt", "The", "Ar", "Leif", "As", "Baird", "S", "At",
            "Au", "U", "Stra", "Jud", "Tho", "Dia", "Doug", "God", "Fast", "Ba", "Bea", "Lyn",
            "Walsh", "Be", "Dil", "Lyt", "Bi", "Bel", "Scrip", "Jus", "Ben", "Gos", "Gor", "Bo",
            "Hicks", "Ber", "Tris", "Bet", "Tif", "Hale", "Bes", "Joan", "Pad", "Bu", "Hearst",
            "Wol", "Reg", "Woo", "By", "Pag", "Tim", "Pal", "Crich", "Todd", "Pan", "Cha", "Sibyl",
            "Ca", "Bing", "Par", "Yves", "Bran", "Ce", "Ade", "Rex", "Pau", "Rey", "Pay", "Co",
            "Brad", "Sha", "Stone", "She", "Need", "Cu", "Cy", "Tess", "North", "Da", "Christ",
            "Frances", "De", "Gold", "Di", "Oisen", "Do", "Cis", "Fox", "Dean", "Fow", "Sid",
            "Sig", "Brooke", "Du", "Dy", "Samp", "Gra", "Sin", "Gre", "Smed", "Ed", "Gri", "Ef",
            "Eg", "Ei", "Gro", "O'Con", "Bird", "El", "Em", "Fors", "Er", "Holt", "Es", "Woolf",
            "Eu", "Field", "Kris", "Hub", "Hud", "Crai", "Rho", "Boyce", "Fa", "Hug", "Hul", "Fe",
            "Hun", "Lynch", "Grant", "Hum", "Young", "Kent", "Bil", "Fo", "Bir", "Hux", "Pea",
            "Joel", "Peg", "White", "Fre", "Pen", "Cla", "Ga", "Ford", "Nan", "Per", "Cle", "Ge",
            "Pet", "Nat", "John", "Crane", "Cly", "Ode", "Browne", "Dob", "Back", "Kerr", "Ha",
            "Bach", "He", "Phil", "Hood", "Neil", "Ever", "Dol", "Hi", "Gun", "Don", "Pear", "Gus",
            "Ho", "Guy", "Dou", "Hu", "Mac", "Troy", "Mab", "Doy", "Hy", "Mag", "Tom", "Morse",
            "Bla", "Mal", "Hart", "Swift", "Man", "Bell", "Mar", "Mau", "Wilde", "Mat", "May",
            "In", "Max", "Ir", "Shaw", "Beard", "Bly", "Phi", "Ja", "Je", "Cof", "Wyatt", "Com",
            "Col", "Coo", "Con", "James", "Jo", "Cop", "Cor", "Cot", "Cow", "Ju", "Croft", "Jane",
            "Son", "Nel", "Ka", "Lan", "Sou", "Lam", "Pit", "Ke", "Lar", "Frank", "Lat", "New",
            "Lau", "Horn", "Tra", "Law", "Snow", "Tre", "Als", "Dry", "Bob", "Stowe", "Brid",
            "Chris", "Tru", "Thodore", "Tate", "Le", "Gwen", "Li", "Yule", "Bon", "Alick", "Saul",
            "Lo", "Rob", "Rod", "Bos", "Lu", "Deir", "Bow", "Ly", "Meg", "Vogt", "Ron", "Browning",
            "Nell", "Roo", "Ma", "Mel", "Broad", "Price", "Eve", "Jeames", "Mc", "Ros", "Me", "Mer",
            "Mi", "Wells", "Roy", "Kat", "Ann", "Drew", "Walk", "Giles", "Cro", "Mo", "Finn", "Quee",
            "Chur", "Kay", "Sher", "Berg", "Mu", "Cry", "Phoe", "Quen", "My", "Lamb", "Na", "Maltz",
            "Ne", "Dul", "Ni", "Glenn", "Dun", "Reade", "No", "Eips", "Lea", "Ny", "Duke", "Noah",
            "Lee", "Jac", "Bra", "Tur", "Faulk", "Lei", "Tut", "Len", "Oc", "Yvon", "Jan", "Leo",
            "Og", "Bert", "Les", "Shel", "Ol", "Shei", "Bro", "Lew", "Sta", "Jay", "Or", "Troll",
            "Os", "Bru", "Ralph", "Ste", "Ot", "Bald", "Blan", "Bry", "Pa", "Dunn", "Reed", "Pe",
            "Bush", "Theo", "Sweet", "Cooke", "Pi", "Cum", "Bess", "Po", "Cur", "Keith", "Cliff",
            "Gill", "Demp", "Pu", "Hous", "Poe", "Mid", "Mig", "Grote", "Spring", "Pol", "Abra",
            "Pop", "Mil", "Ara", "Sur", "Por", "Kel", "Min", "Ken", "Kep", "Bloom", "Ian", "Faithe",
            "Sean", "Fran", "Ker", "Bloor", "Sails", "Wheat", "Arm", "Key", "Quil", "Pull", "Hill",
            "Stan", "Kath", "Dodd", "Ra", "Quin", "Lionel", "Bron", "Jones", "Re", "Ri", "Bul",
            "Josh", "Clar", "Bun", "Wolf", "Ro", "Mans", "Tout", "Bur", "But", "Ru", "Ry", "Jef",
            "Noel", "Sa", "Lil", "Hag", "Lin", "Rus", "Se", "Hal", "Jen", "Han", "Ham", "Si", "Jer",
            "Har", "Shir", "Jes", "So", "Liz", "Scott", "Sains", "Haw", "Att", "Haz", "Hay", "Su",
            "Xan", "Sy", "Pri", "Yale", "Fitz", "Crom", "Strong", "Ta", "Harte", "Swin", "Leigh",
            "Yvette", "Te", "Pru", "Ti", "Ives", "Cyn", "To", "Aus", "Gray", "Ty", "Syl", "Wylde",
            "Fred", "Yonng", "Free", "Kim", "Nor", "Miles", "Penn", "Gal", "Kip", "Yea", "Ward",
            "Vaug", "Keats", "Kit", "Long", "Gas", "Gar", "Yed", "Up", "Wag", "Holmes", "Ur", "Camp",
            "Simp", "Brown", "Wal", "Watt", "Wan", "Yer", "Wright", "Yet", "Mark", "Clare", "War",
            "Va", "Wat", "Greg", "Funk", "Bard", "Way", "Stel", "Camil", "Ve", "Dutt", "Clark", "Vi",
            "Toyn", "Mond", "Grey", "Wood", "Moi", "Hed", "Pul", "Moll", "Wa", "Jean", "Mol", "Moo",
            "Hugh", "Mon", "Stein", "Jim", "Hen", "Bruce", "Mor", "Wh", "Fan", "Wi", "Mot", "Her",
            "Pound", "Wo", "Hew", "Wool", "Green", "Bart", "Fay", "Zim", "Mick", "Wy", "Van", "Word",
            "Thorn", "Sharp", "Judd", "Xa", "Xe", "Phyl", "Matt", "Twain", "Gene", "Dwight", "Child",
            "Carr", "Carl", "Smith", "House", "Lon", "Ye", "Mont", "Gem", "Lor", "Lou", "Ear", "Jill",
            "Geor", "Wen", "Stil", "Wes", "Wer", "Za", "Cook", "Chad", "Cleve", "Grif", "Ze", "Cash",
            "Cham", "Joyce", "More", "Chan", "Loui", "Chap", "Thom", "Zo", "Char", "Chau", "Maug",
            "Priest", "Maud", "Zang", "Crofts", "Hil", "Fel", "Dai", "Dal", "Dan", "Cons", "Veb",
            "Fer", "Dar", "Geof", "Blair", "Tab", "Jeff", "Whee", "Wilhel", "Chloe", "Borg", "Tam",
            "Ver", "Grace", "Webb", "Quinn", "Tay", "Burne", "King", "Webs", "Job", "Roxan", "Joe",
            "Gib", "Kyle", "Cae", "Nick", "Hume", "Jon", "Mur", "Gil", "Jor", "Louie", "Cal", "Gis",
            "Jou", "Can", "Zoe", "Car", "Joy", "Wil", "Burns", "Gail", "Win", "Sam", "Sal", "Louis",
            "Spen", "San", "Wild", "Sas", "York", "Lance", "Beau", "Saw", "Hodg", "Glad", "Claude",
            "Sax", "Brook", "Kings", "Cher", "Gale", "Ches", "Rhys", "Earl", "Will", "Pritt", "Rusk",
            "Jack", "Deb", "Bab", "Flower", "Fin", "O'Neil", "Den", "Dick", "Thomp", "Der", "Vic",
            "Bar", "Ted", "Boyle", "Stuart", "Whit", "Bau", "Rae", "Blume", "Vin", "Bryce", "Ten",
            "Gla", "Vio", "Moul", "Tem", "Ran"
    };

    /**
     * 生成随机中文名
     *
     * @return 中文名
     */
    public static String getCnName() {
        String head = CN_LAST_NAME[(int) (Math.random() * CN_LAST_NAME.length)];
        String tail = CN_FIRST_NAME[(int) (Math.random() * CN_FIRST_NAME.length)];
        return head + tail;
    }

    /**
     * 生成随机英文名
     *
     * @return 英文名
     */
    public static String getEnName() {
        String head = EN_FIRST_LIST[(int) (Math.random() * EN_FIRST_LIST.length)];
        String tail = EN_LAST_LIST[(int) (Math.random() * EN_LAST_LIST.length)];
        return head + tail;
    }

    /**
     * 生成随机昵称
     *
     * @return
     */
    public static String getNick() {
        String head = CN_ADJECTIVE[(int) (Math.random() * CN_ADJECTIVE.length)];
        String tail = CN_NOUN[(int) (Math.random() * CN_NOUN.length)];
        return head + tail;
    }

}
