/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.wechat.pay.util;

import org.anyline.entity.DataRow;
import org.anyline.util.BasicUtil;
import org.anyline.wechat.pay.util.WechatPayConfig;
import org.anyline.wechat.pay.util.WechatPayUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component(value="anyline.wechat.pay.load.bean")
public class WechatPayBean
implements InitializingBean {
    @Value(value="${anyline.wechat.pay.mchId:}")
    public String MCH_ID;
    @Value(value="${anyline.wechat.pay.spMchId:}")
    public String SP_MCH_ID;
    @Value(value="${anyline.wechat.pay.subMchId:}")
    public String SUB_MCH_ID;
    @Value(value="${anyline.wechat.pay.apiSecret:}")
    public String API_SECRET;
    @Value(value="${anyline.wechat.pay.apiSecret3:}")
    public String API_SECRET3;
    @Value(value="${anyline.wechat.pay.mchPrivateSecretFile:}")
    public String MCH_PRIVATE_SECRET_FILE;
    @Value(value="${anyline.wechat.pay.certificateSerial:}")
    public String CERTIFICATE_SERIAL;
    @Value(value="${anyline.wechat.pay.keyStoreFile:}")
    public String KEY_STORE_FILE;
    @Value(value="${anyline.wechat.pay.keyStorePassword:}")
    public String KEY_STORE_PASSWORD;
    @Value(value="${anyline.wechat.pay.notifyUrl:}")
    public String NOTIFY_URL;
    @Value(value="${anyline.wechat.pay.callbackUrl:}")
    public String CALLBACK_URL;
    @Value(value="${anyline.wechat.pay.bankRsaPublicKeyFile:}")
    public String BANK_RSA_PUBLIC_KEY_FILE;

    public void afterPropertiesSet() {
        this.MCH_ID = (String)BasicUtil.evl((Object[])new String[]{this.MCH_ID, WechatPayConfig.DEFAULT_MCH_ID});
        if (BasicUtil.isEmpty((Object)this.MCH_ID)) {
            return;
        }
        DataRow row = new DataRow();
        row.put("MCH_ID", BasicUtil.evl((Object[])new String[]{this.MCH_ID, WechatPayConfig.DEFAULT_MCH_ID}));
        row.put("SP_MCH_ID", BasicUtil.evl((Object[])new String[]{this.SP_MCH_ID, WechatPayConfig.DEFAULT_SP_MCH_ID}));
        row.put("SUB_MCH_ID", BasicUtil.evl((Object[])new String[]{this.SUB_MCH_ID, WechatPayConfig.DEFAULT_SUB_MCH_ID}));
        row.put("API_SECRET", BasicUtil.evl((Object[])new String[]{this.API_SECRET, WechatPayConfig.DEFAULT_API_SECRET}));
        row.put("API_SECRET_V3", BasicUtil.evl((Object[])new String[]{this.API_SECRET3, WechatPayConfig.DEFAULT_API_SECRET3}));
        row.put("MCH_PRIVATE_SECRET_FILE", BasicUtil.evl((Object[])new String[]{this.MCH_PRIVATE_SECRET_FILE, WechatPayConfig.DEFAULT_MCH_PRIVATE_SECRET_FILE}));
        row.put("CERTIFICATE_SERIAL", BasicUtil.evl((Object[])new String[]{this.CERTIFICATE_SERIAL, WechatPayConfig.DEFAULT_CERTIFICATE_SERIAL}));
        row.put("KEY_STORE_FILE", BasicUtil.evl((Object[])new String[]{this.KEY_STORE_FILE, WechatPayConfig.DEFAULT_KEY_STORE_FILE}));
        row.put("KEY_STORE_PASSWORD", BasicUtil.evl((Object[])new String[]{this.KEY_STORE_PASSWORD, WechatPayConfig.DEFAULT_KEY_STORE_PASSWORD}));
        row.put("NOTIFY_URL", BasicUtil.evl((Object[])new String[]{this.NOTIFY_URL, WechatPayConfig.DEFAULT_NOTIFY_URL}));
        row.put("CALLBACK_URL", BasicUtil.evl((Object[])new String[]{this.CALLBACK_URL, WechatPayConfig.DEFAULT_CALLBACK_URL}));
        row.put("BANK_RSA_PUBLIC_KEY_FILE", BasicUtil.evl((Object[])new String[]{this.BANK_RSA_PUBLIC_KEY_FILE, WechatPayConfig.DEFAULT_BANK_RSA_PUBLIC_KEY_FILE}));
        WechatPayConfig.register(row);
    }

    @Bean(value={"anyline.wechat.pay.init.util"})
    public WechatPayUtil instance() {
        return WechatPayUtil.getInstance();
    }
}

