/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.wechat.util;

import org.anyline.entity.DataRow;
import org.anyline.util.BasicUtil;
import org.anyline.wechat.mp.util.WechatMPConfig;
import org.anyline.wechat.mp.util.WechatMPUtil;
import org.anyline.wechat.open.util.WechatOpenConfig;
import org.anyline.wechat.open.util.WechatOpenUtil;
import org.anyline.wechat.program.WechatProgramConfig;
import org.anyline.wechat.program.WechatProgramUtil;
import org.anyline.wechat.util.WechatConfig;
import org.anyline.wechat.wap.util.WechatWapConfig;
import org.anyline.wechat.wap.util.WechatWapUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component(value="anyline.wechat.load.bean")
public class WechatBean
implements InitializingBean {
    @Value(value="${anyline.wechat.app:}")
    private String APP_ID;
    @Value(value="${anyline.wechat.secret:}")
    private String APP_SECRET;
    @Value(value="${anyline.wechat.signType:}")
    private String SIGN_TYPE;
    @Value(value="${anyline.wechat.token:}")
    private String SERVER_TOKEN;
    @Value(value="${anyline.wechat.redirect:}")
    private String OAUTH_REDIRECT_URL;
    @Value(value="${anyline.wechat.server:}")
    private String WEB_SERVER;
    @Value(value="${anyline.wechat.tokenServer:}")
    private String ACCESS_TOKEN_SERVER;
    @Value(value="${anyline.wechat.whitelist:}")
    private String SERVER_WHITELIST;

    public void afterPropertiesSet() {
        this.APP_ID = (String)BasicUtil.evl((Object[])new String[]{this.APP_ID, WechatConfig.DEFAULT_APP_ID});
        if (BasicUtil.isEmpty((Object)this.APP_ID)) {
            return;
        }
        DataRow row = new DataRow();
        row.put("APP_ID", BasicUtil.evl((Object[])new String[]{this.APP_ID, WechatConfig.DEFAULT_APP_ID}));
        row.put("APP_SECRET", BasicUtil.evl((Object[])new String[]{this.APP_SECRET, WechatConfig.DEFAULT_APP_SECRET}));
        row.put("SIGN_TYPE", BasicUtil.evl((Object[])new String[]{this.SIGN_TYPE, WechatConfig.DEFAULT_SIGN_TYPE}));
        row.put("SERVER_TOKEN", BasicUtil.evl((Object[])new String[]{this.SERVER_TOKEN, WechatConfig.DEFAULT_SERVER_TOKEN}));
        row.put("OAUTH_REDIRECT_URL", BasicUtil.evl((Object[])new String[]{this.OAUTH_REDIRECT_URL, WechatConfig.DEFAULT_OAUTH_REDIRECT_URL}));
        row.put("WEB_SERVER", BasicUtil.evl((Object[])new String[]{this.WEB_SERVER, WechatConfig.DEFAULT_WEB_SERVER}));
        row.put("ACCESS_TOKEN_SERVER", BasicUtil.evl((Object[])new String[]{this.ACCESS_TOKEN_SERVER, WechatConfig.DEFAULT_ACCESS_TOKEN_SERVER}));
        row.put("SERVER_WHITELIST", BasicUtil.evl((Object[])new String[]{this.SERVER_WHITELIST, WechatConfig.DEFAULT_SERVER_WHITELIST}));
        WechatMPConfig.register(row);
        WechatOpenConfig.register(row);
        WechatProgramConfig.register(row);
        WechatWapConfig.register(row);
    }

    @Bean(value={"anyline.wechat.mp.init.util"})
    public WechatMPUtil instanceMp() {
        return WechatMPUtil.getInstance();
    }

    @Bean(value={"anyline.wechat.open.init.util"})
    public WechatOpenUtil instanceOpen() {
        return WechatOpenUtil.getInstance();
    }

    @Bean(value={"anyline.wechat.program.init.util"})
    public WechatProgramUtil instanceProgram() {
        return WechatProgramUtil.getInstance();
    }

    @Bean(value={"anyline.wechat.wap.init.util"})
    public WechatWapUtil instanceWap() {
        return WechatWapUtil.getInstance();
    }
}

