/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.wechat.pay.util;

import java.io.File;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.anyline.entity.DataRow;
import org.anyline.net.HttpBuilder;
import org.anyline.net.HttpUtil;
import org.anyline.net.SimpleHttpUtil;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.encrypt.RSAUtil;
import org.anyline.wechat.entity.WechatEnterpriseTransfer;
import org.anyline.wechat.entity.WechatEnterpriseTransferBank;
import org.anyline.wechat.entity.WechatEnterpriseTransferBankResult;
import org.anyline.wechat.entity.WechatEnterpriseTransferResult;
import org.anyline.wechat.entity.WechatFissionRedpack;
import org.anyline.wechat.entity.WechatFissionRedpackResult;
import org.anyline.wechat.entity.WechatPrePayOrder;
import org.anyline.wechat.entity.WechatPrePayResult;
import org.anyline.wechat.entity.WechatRedpack;
import org.anyline.wechat.entity.WechatRedpackResult;
import org.anyline.wechat.entity.WechatRefund;
import org.anyline.wechat.entity.WechatRefundResult;
import org.anyline.wechat.pay.util.WechatPayConfig;
import org.anyline.wechat.util.WechatUtil;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatPayUtil {
    protected static final Logger log = LoggerFactory.getLogger(WechatPayUtil.class);
    private WechatPayConfig config = null;
    private static Hashtable<String, WechatPayUtil> instances = new Hashtable();

    public static Hashtable<String, WechatPayUtil> getInstances() {
        return instances;
    }

    public static WechatPayUtil getInstance() {
        return WechatPayUtil.getInstance("default");
    }

    public WechatPayUtil(WechatPayConfig config) {
        this.config = config;
    }

    public WechatPayUtil(String key, DataRow config) {
        WechatPayConfig conf;
        this.config = conf = WechatPayConfig.parse(key, config);
        instances.put(key, this);
    }

    public static WechatPayUtil register(String key, DataRow config) {
        WechatPayConfig conf = WechatPayConfig.register(key, config);
        WechatPayUtil util = new WechatPayUtil(conf);
        instances.put(key, util);
        return util;
    }

    public static WechatPayUtil getInstance(String key) {
        WechatPayConfig config;
        WechatPayUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key)) && null != (config = WechatPayConfig.getInstance(key))) {
            util = new WechatPayUtil(config);
            instances.put(key, util);
        }
        return util;
    }

    public WechatPayConfig getConfig() {
        return this.config;
    }

    public WechatPrePayResult unifiedorder(WechatPrePayOrder order) throws Exception {
        WechatPrePayResult result = null;
        order.setNonce_str(BasicUtil.getRandomLowerString((int)20));
        if (null == order.getAppid()) {
            throw new Exception("\u672a\u8bbe\u7f6eappid");
        }
        if ("JSAPI".equals(order.getTrade_type()) && null == order.getOpenid()) {
            throw new Exception("\u672a\u8bbe\u7f6eopenid");
        }
        if (BasicUtil.isEmpty((Object)order.getMch_id())) {
            order.setMch_id(this.config.MCH_ID);
        }
        if (BasicUtil.isEmpty((Object)order.getNotify_url())) {
            order.setNotify_url(this.config.NOTIFY_URL);
        }
        if (BasicUtil.isEmpty((Object)order.getNotify_url())) {
            // empty if block
        }
        if (BasicUtil.isEmpty((Object)order.getOut_trade_no())) {
            throw new Exception("\u672a\u8bbe\u7f6e\u4ea4\u6613\u5355\u53f7");
        }
        Map map = BeanUtil.toMap((Object)order, (String[])new String[0]);
        String sign = WechatUtil.sign(this.config.API_SECRET, map);
        map.put("sign", sign);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u7edf\u4e00\u4e0b\u5355][sign:{}}", (Object)sign);
        }
        String xml = BeanUtil.map2xml((Map)map);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u7edf\u4e00\u4e0b\u5355][xml:{}]", (Object)xml);
        }
        String rtn = SimpleHttpUtil.post((String)"https://api.mch.weixin.qq.com/pay/unifiedorder", (String)xml);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u7edf\u4e00\u4e0b\u5355][return:{}]", (Object)rtn);
        }
        if (BasicUtil.isNotEmpty((Object)(result = (WechatPrePayResult)BeanUtil.xml2object((String)rtn, WechatPrePayResult.class)).getPrepay_id())) {
            result.setResult(true);
        }
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u7edf\u4e00\u4e0b\u5355][prepay id:{}]", (Object)result.getPrepay_id());
        }
        return result;
    }

    public DataRow callUpParam(String appid, String prepayid) {
        String timestamp = System.currentTimeMillis() / 1000L + "";
        String random = BasicUtil.getRandomLowerString((int)20);
        String pkg = "prepay_id=" + prepayid;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("package", pkg);
        params.put("timeStamp", timestamp);
        params.put("appId", appid);
        params.put("nonceStr", random);
        params.put("signType", "MD5");
        String sign = WechatUtil.sign(this.config.API_SECRET, params);
        params.put("paySign", sign);
        DataRow row = new DataRow(params);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[jsapi\u8c03\u8d77\u5fae\u4fe1\u652f\u4ed8][\u53c2\u6570:{}]", (Object)row.toJSON());
        }
        return row;
    }

    public WechatRefundResult refund(WechatRefund refund) throws Exception {
        File keyStoreFile;
        WechatRefundResult result = null;
        if (null == refund.getAppid()) {
            throw new Exception("\u672a\u8bbe\u7f6eappid");
        }
        refund.setNonce_str(BasicUtil.getRandomLowerString((int)20));
        if (BasicUtil.isEmpty((Object)refund.getMch_id())) {
            refund.setMch_id(this.config.MCH_ID);
        }
        Map map = BeanUtil.toMap((Object)refund, (String[])new String[0]);
        String sign = WechatUtil.sign(this.config.API_SECRET, map);
        map.put("sign", sign);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u9000\u6b3e\u7533\u8bf7][sign:{}]", (Object)sign);
        }
        String xml = BeanUtil.map2xml((Map)map);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u9000\u6b3e\u7533\u8bf7][xml:{}]", (Object)xml);
            log.warn("[\u9000\u6b3e\u7533\u8bf7][\u8bc1\u4e66:{}]", (Object)this.config.KEY_STORE_FILE);
        }
        if (!(keyStoreFile = new File(this.config.KEY_STORE_FILE)).exists()) {
            log.warn("[\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728][file:{}]", (Object)this.config.KEY_STORE_FILE);
            return new WechatRefundResult(false, "\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String keyStorePassword = this.config.KEY_STORE_PASSWORD;
        if (BasicUtil.isEmpty((Object)keyStorePassword)) {
            log.warn("\u672a\u8bbe\u7f6e\u5bc6\u94a5\u6587\u4ef6\u5bc6\u7801");
            return new WechatRefundResult(false, "\u672a\u8bbe\u7f6e\u5bc6\u94a5\u6587\u4ef6\u5bc6\u7801");
        }
        try {
            CloseableHttpClient httpclient = HttpUtil.ceateSSLClient((File)keyStoreFile, (String)HttpUtil.PROTOCOL_TLSV1, (String)keyStorePassword);
            StringEntity reqEntity = new StringEntity(xml);
            reqEntity.setContentType("application/x-www-form-urlencoded");
            String txt = HttpBuilder.init().setClient(httpclient).setUrl("https://api.mch.weixin.qq.com/secapi/pay/refund").setCharset("UTF-8").setEntity((HttpEntity)reqEntity).build().get().getText();
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.warn("[\u9000\u6b3e\u7533\u8bf7\u8c03\u7528][result:{}", (Object)txt);
            }
            result = (WechatRefundResult)BeanUtil.xml2object((String)txt, WechatRefundResult.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new WechatRefundResult(false, e.toString());
        }
        return result;
    }

    public WechatRedpackResult sendRedpack(WechatRedpack pack) throws Exception {
        File keyStoreFile;
        WechatRedpackResult result = new WechatRedpackResult();
        if (null == pack.getWxappid()) {
            throw new Exception("\u672a\u8bbe\u7f6ewxappid");
        }
        if (null == pack.getRe_openid()) {
            throw new Exception("\u672a\u8bbe\u7f6ereopenid");
        }
        pack.setNonce_str(BasicUtil.getRandomLowerString((int)20));
        if (BasicUtil.isEmpty((Object)pack.getMch_id())) {
            pack.setMch_id(this.config.MCH_ID);
        }
        if (BasicUtil.isEmpty((Object)pack.getMch_billno())) {
            pack.setMch_billno(BasicUtil.getRandomLowerString((int)20));
        }
        Map map = BeanUtil.toMap((Object)pack, (String[])new String[0]);
        String sign = WechatUtil.sign(this.config.API_SECRET, map);
        map.put("sign", sign);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u53d1\u9001\u7ea2\u5305[sign:{}]", (Object)sign);
        }
        String xml = BeanUtil.map2xml((Map)map);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u53d1\u9001\u7ea2\u5305][xml:{}]", (Object)xml);
            log.warn("[\u53d1\u9001\u7ea2\u5305][\u8bc1\u4e66:{}]", (Object)this.config.KEY_STORE_FILE);
        }
        if (!(keyStoreFile = new File(this.config.KEY_STORE_FILE)).exists()) {
            log.warn("[\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728][file:{}]", (Object)this.config.KEY_STORE_FILE);
            return new WechatRedpackResult(false, "\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String keyStorePassword = this.config.KEY_STORE_PASSWORD;
        if (BasicUtil.isEmpty((Object)keyStorePassword)) {
            log.warn("\u672a\u8bbe\u7f6e\u5bc6\u94a5\u6587\u4ef6\u5bc6\u7801");
            return new WechatRedpackResult(false, "\u672a\u8bbe\u7f6e\u5bc6\u94a5\u6587\u4ef6\u5bc6\u7801");
        }
        try {
            CloseableHttpClient httpclient = HttpUtil.ceateSSLClient((File)keyStoreFile, (String)HttpUtil.PROTOCOL_TLSV1, (String)keyStorePassword);
            StringEntity reqEntity = new StringEntity(xml, "UTF-8");
            reqEntity.setContentType("application/x-www-form-urlencoded");
            String txt = HttpBuilder.init().setClient(httpclient).setUrl("https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack").setCharset("UTF-8").setEntity((HttpEntity)reqEntity).build().get().getText();
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.warn("[\u53d1\u9001\u7ea2\u5305\u8c03\u7528][result:{}]", (Object)txt);
            }
            result = (WechatRedpackResult)BeanUtil.xml2object((String)txt, WechatRedpackResult.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new WechatRedpackResult(false, e.toString());
        }
        return result;
    }

    public WechatFissionRedpackResult sendRedpack(WechatFissionRedpack pack) throws Exception {
        File keyStoreFile;
        if (null == pack.getWxappid()) {
            throw new Exception("\u672a\u8bbe\u7f6ewxappid");
        }
        if (null == pack.getRe_openid()) {
            throw new Exception("\u672a\u8bbe\u7f6ereopenid");
        }
        WechatFissionRedpackResult result = new WechatFissionRedpackResult();
        pack.setNonce_str(BasicUtil.getRandomLowerString((int)20));
        if (BasicUtil.isEmpty((Object)pack.getMch_id())) {
            pack.setMch_id(this.config.MCH_ID);
        }
        if (BasicUtil.isEmpty((Object)pack.getMch_billno())) {
            pack.setMch_billno(BasicUtil.getRandomLowerString((int)20));
        }
        Map map = BeanUtil.toMap((Object)pack, (String[])new String[0]);
        String sign = WechatUtil.sign(this.config.API_SECRET, map);
        map.put("sign", sign);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u53d1\u9001\u88c2\u53d8\u7ea2\u5305][sign:{}]", (Object)sign);
        }
        String xml = BeanUtil.map2xml((Map)map);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u53d1\u9001\u88c2\u53d8\u7ea2\u5305][xml:{}]", (Object)xml);
            log.warn("[\u53d1\u9001\u88c2\u53d8\u7ea2\u5305][\u8bc1\u4e66:{}]", (Object)this.config.KEY_STORE_FILE);
        }
        if (!(keyStoreFile = new File(this.config.KEY_STORE_FILE)).exists()) {
            log.warn("[\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728][file:{}]", (Object)this.config.KEY_STORE_FILE);
            return new WechatFissionRedpackResult(false, "\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String keyStorePassword = this.config.KEY_STORE_PASSWORD;
        if (BasicUtil.isEmpty((Object)keyStorePassword)) {
            log.warn("\u672a\u8bbe\u7f6e\u5bc6\u94a5\u6587\u4ef6\u5bc6\u7801");
            return new WechatFissionRedpackResult(false, "\u672a\u8bbe\u7f6e\u5bc6\u94a5\u6587\u4ef6\u5bc6\u7801");
        }
        try {
            CloseableHttpClient httpclient = HttpUtil.ceateSSLClient((File)keyStoreFile, (String)HttpUtil.PROTOCOL_TLSV1, (String)keyStorePassword);
            StringEntity reqEntity = new StringEntity(xml, "UTF-8");
            reqEntity.setContentType("application/x-www-form-urlencoded");
            String txt = HttpBuilder.init().setClient(httpclient).setUrl("https://api.mch.weixin.qq.com/mmpaymkttransfers/sendgroupredpack").setCharset("UTF-8").setEntity((HttpEntity)reqEntity).build().get().getText();
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.warn("[\u53d1\u9001\u88c2\u53d8\u7ea2\u5305\u8c03\u7528][result:{}]", (Object)txt);
            }
            result = (WechatFissionRedpackResult)BeanUtil.xml2object((String)txt, WechatFissionRedpackResult.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new WechatFissionRedpackResult(false, e.toString());
        }
        return result;
    }

    public WechatEnterpriseTransferResult transfer(WechatEnterpriseTransfer transfer) {
        File keyStoreFile;
        WechatEnterpriseTransferResult result = new WechatEnterpriseTransferResult();
        transfer.setNonce_str(BasicUtil.getRandomLowerString((int)20));
        if (BasicUtil.isEmpty((Object)transfer.getMchid())) {
            transfer.setMchid(this.config.MCH_ID);
        }
        if (BasicUtil.isEmpty((Object)transfer.getPartner_trade_no())) {
            transfer.setPartner_trade_no(BasicUtil.getRandomLowerString((int)20));
        }
        Map map = BeanUtil.toMap((Object)transfer, (String[])new String[0]);
        String sign = WechatUtil.sign(this.config.API_SECRET, map);
        map.put("sign", sign);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u4ed8\u6b3e][sign:{}]", (Object)sign);
        }
        String xml = BeanUtil.map2xml((Map)map);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u4ed8\u6b3e][xml:{}]", (Object)xml);
            log.warn("[\u4ed8\u6b3e][\u8bc1\u4e66:{}]", (Object)this.config.KEY_STORE_FILE);
        }
        if (!(keyStoreFile = new File(this.config.KEY_STORE_FILE)).exists()) {
            log.warn("[\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728][file:{}]", (Object)this.config.KEY_STORE_FILE);
            return new WechatEnterpriseTransferResult(false, "\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String keyStorePassword = this.config.KEY_STORE_PASSWORD;
        if (BasicUtil.isEmpty((Object)keyStorePassword)) {
            log.warn("\u672a\u8bbe\u7f6e\u5bc6\u94a5\u6587\u4ef6\u5bc6\u7801");
            return new WechatEnterpriseTransferResult(false, "\u672a\u8bbe\u7f6e\u5bc6\u94a5\u6587\u4ef6\u5bc6\u7801");
        }
        try {
            CloseableHttpClient httpclient = HttpUtil.ceateSSLClient((File)keyStoreFile, (String)HttpUtil.PROTOCOL_TLSV1, (String)keyStorePassword);
            StringEntity reqEntity = new StringEntity(xml, "UTF-8");
            reqEntity.setContentType("application/x-www-form-urlencoded");
            String txt = HttpBuilder.init().setClient(httpclient).setUrl("https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers").setCharset("UTF-8").setEntity((HttpEntity)reqEntity).build().get().getText();
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.warn("[\u4ed8\u6b3e\u8c03\u7528][result:{}]", (Object)txt);
            }
            result = (WechatEnterpriseTransferResult)BeanUtil.xml2object((String)txt, WechatEnterpriseTransferResult.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new WechatEnterpriseTransferResult(false, e.toString());
        }
        return result;
    }

    public WechatEnterpriseTransferBankResult transfer(WechatEnterpriseTransferBank transfer) {
        File keyStoreFile;
        WechatEnterpriseTransferBankResult result = new WechatEnterpriseTransferBankResult();
        transfer.setNonce_str(BasicUtil.getRandomLowerString((int)20));
        String enc_bank_no = transfer.getEnc_bank_no();
        String enc_true_name = transfer.getEnc_true_name();
        if (BasicUtil.isEmpty((Object)enc_bank_no)) {
            log.warn("\u672a\u63d0\u4f9b\u6536\u6b3e\u5361\u53f7");
            return new WechatEnterpriseTransferBankResult(false, "\u672a\u63d0\u4f9b\u6536\u6b3e\u5361\u53f7");
        }
        if (BasicUtil.isEmpty((Object)enc_true_name)) {
            log.warn("\u672a\u63d0\u4f9b\u6536\u6b3e\u4eba\u59d3\u540d");
            return new WechatEnterpriseTransferBankResult(false, "\u672a\u63d0\u4f9b\u6536\u6b3e\u4eba\u59d3\u540d");
        }
        try {
            enc_bank_no = RSAUtil.encrypt((String)enc_bank_no, (PublicKey)RSAUtil.createPublicKey((File)new File(this.config.BANK_RSA_PUBLIC_KEY_FILE)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (BasicUtil.isEmpty((Object)transfer.getMch_id())) {
            transfer.setMch_id(this.config.MCH_ID);
        }
        if (BasicUtil.isEmpty((Object)transfer.getPartner_trade_no())) {
            transfer.setPartner_trade_no(BasicUtil.getRandomLowerString((int)20));
        }
        Map map = BeanUtil.toMap((Object)transfer, (String[])new String[0]);
        String sign = WechatUtil.sign(this.config.API_SECRET, map);
        map.put("sign", sign);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u4ed8\u6b3e][sign:{}]", (Object)sign);
        }
        String xml = BeanUtil.map2xml((Map)map);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u4ed8\u6b3e][xml:{}]", (Object)xml);
            log.warn("[\u4ed8\u6b3e][\u8bc1\u4e66:{}]", (Object)this.config.KEY_STORE_FILE);
        }
        if (!(keyStoreFile = new File(this.config.KEY_STORE_FILE)).exists()) {
            log.warn("[\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728][file:{}]", (Object)this.config.KEY_STORE_FILE);
            return new WechatEnterpriseTransferBankResult(false, "\u5bc6\u94a5\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String keyStorePassword = this.config.KEY_STORE_PASSWORD;
        if (BasicUtil.isEmpty((Object)keyStorePassword)) {
            log.warn("\u672a\u8bbe\u7f6e\u5bc6\u94a5\u6587\u4ef6\u5bc6\u7801");
            return new WechatEnterpriseTransferBankResult(false, "\u672a\u8bbe\u7f6e\u5bc6\u94a5\u6587\u4ef6\u5bc6\u7801");
        }
        try {
            CloseableHttpClient httpclient = HttpUtil.ceateSSLClient((File)keyStoreFile, (String)HttpUtil.PROTOCOL_TLSV1, (String)keyStorePassword);
            StringEntity reqEntity = new StringEntity(xml, "UTF-8");
            reqEntity.setContentType("application/x-www-form-urlencoded");
            String txt = HttpBuilder.init().setClient(httpclient).setUrl("https://api.mch.weixin.qq.com/mmpaysptrans/pay_bank").setCharset("UTF-8").setEntity((HttpEntity)reqEntity).build().get().getText();
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.warn("[\u4ed8\u6b3e\u8c03\u7528][result:{}]", (Object)txt);
            }
            result = (WechatEnterpriseTransferBankResult)BeanUtil.xml2object((String)txt, WechatEnterpriseTransferBankResult.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new WechatEnterpriseTransferBankResult(false, e.toString());
        }
        return result;
    }

    public String getPublicKey() {
        String txt = WechatUtil.getPublicKey(this.config.MCH_ID, this.config.API_SECRET, new File(this.config.KEY_STORE_FILE), this.config.KEY_STORE_PASSWORD);
        Map map = BeanUtil.xml2map((String)txt);
        return (String)map.get("pub_key");
    }

    static {
        Hashtable<String, AnylineConfig> configs = WechatPayConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, WechatPayUtil.getInstance(key));
        }
    }
}

