/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.wechat.util;

import java.io.File;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.net.HttpBuilder;
import org.anyline.net.HttpUtil;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.encrypt.MD5Util;
import org.anyline.wechat.entity.WechatAuthInfo;
import org.anyline.wechat.entity.WechatUserInfo;
import org.anyline.wechat.util.WechatConfig;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatUtil {
    protected static final Logger log = LoggerFactory.getLogger(WechatUtil.class);
    private static DataSet accessTokens = new DataSet();

    public static String sign(String secret, Map<String, Object> params) {
        String sign = "";
        sign = BeanUtil.map2string(params);
        sign = sign + "&key=" + secret;
        sign = MD5Util.crypto((String)sign).toUpperCase();
        return sign;
    }

    public static boolean validateSign(String secret, Map<String, Object> map) {
        String sign = (String)map.get("sign");
        if (BasicUtil.isEmpty((Object)sign)) {
            return false;
        }
        map.remove("sign");
        String chkSign = WechatUtil.sign(secret, map);
        return chkSign.equals(sign);
    }

    public static boolean validateSign(String secret, String xml) {
        return WechatUtil.validateSign(secret, BeanUtil.xml2map((String)xml));
    }

    public static String getPublicKey(String mch, String apiSecret, File keyStoreFile, String keyStorePassword) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("mch_id", mch);
        parameters.put("nonce_str", BasicUtil.getRandomLowerString((int)20));
        parameters.put("sign_type", "MD5");
        String sign = WechatUtil.sign(apiSecret, parameters);
        parameters.put("sign", sign);
        String xml = BeanUtil.map2xml(parameters);
        CloseableHttpClient httpclient = HttpUtil.ceateSSLClient((File)keyStoreFile, (String)HttpUtil.PROTOCOL_TLSV1, (String)keyStorePassword);
        StringEntity reqEntity = new StringEntity(xml, "UTF-8");
        reqEntity.setContentType("application/x-www-form-urlencoded");
        String txt = HttpBuilder.init().setClient(httpclient).setUrl("https://fraud.mch.weixin.qq.com/risk/getpublickey").setCharset("UTF-8").setEntity((HttpEntity)reqEntity).build().get().getText();
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[\u83b7\u53d6RSA\u516c\u94a5][\n{}\n]", (Object)txt);
        }
        return txt;
    }

    public static String getAccessToken(WechatConfig config) {
        if (BasicUtil.isNotEmpty((Object)config.SERVER_WHITELIST)) {
            try {
                String ip = InetAddress.getLocalHost().getHostAddress();
                if (!config.SERVER_WHITELIST.contains(ip)) {
                    log.warn("[\u767d\u540d\u5355\u9a8c\u8bc1\u5931\u8d25][\u767d\u540d\u5355:{}][\u672c\u673aIP:{}]", (Object)config.SERVER_WHITELIST, (Object)ip);
                    return null;
                }
            }
            catch (Exception e) {
                log.warn("[\u767d\u540d\u5355\u9a8c\u8bc1\u5f02\u5e38]");
            }
        }
        String result = "";
        DataRow row = accessTokens.getRow(new String[]{"APP_ID", config.APP_ID});
        if (null == row || row.isExpire()) {
            accessTokens.remove((Object)row);
            row = WechatUtil.newAccessToken(config);
        }
        if (null != row) {
            result = row.getString(new String[]{"ACCESS_TOKEN"});
        }
        return result;
    }

    private static DataRow newAccessToken(WechatConfig config) {
        DataRow json;
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[CREATE NEW ACCESS TOKEN][appid:{}][secret:{}]", (Object)config.APP_ID, (Object)config.APP_SECRET);
        }
        String appid = config.APP_ID;
        String secret = config.APP_SECRET;
        DataRow row = null;
        String url = null;
        url = BasicUtil.isEmpty((Object)config.ACCESS_TOKEN_SERVER) ? "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + appid + "&secret=" + secret : config.ACCESS_TOKEN_SERVER + "?grant_type=client_credential&appid=" + appid + "&secret=" + secret;
        String text = HttpUtil.post((String)url).getText();
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[CREATE NEW ACCESS TOKEN][result:{}]", (Object)text);
        }
        if (null != (json = DataRow.parseJson((String)text)) && json.containsKey("access_token")) {
            row = new DataRow();
            row.put("APP_ID", (Object)appid);
            row.put("ACCESS_TOKEN", (Object)json.getString(new String[]{"access_token"}));
            row.setExpires(json.getInt("expires_in", Integer.valueOf(0)) * 800);
            row.setExpires(300000);
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.warn("[CREATE NEW ACCESS TOKEN][ACCESS_TOKEN:{}]", (Object)row.getString(new String[]{"ACCESS_TOKEN"}));
            }
        } else {
            if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.warn("[CREATE NEW ACCESS TOKEN][FAIL]");
            }
            return null;
        }
        accessTokens.addRow(row);
        return row;
    }

    public static WechatAuthInfo getAuthInfo(WechatConfig config, String code) {
        WechatAuthInfo result = null;
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + config.APP_ID + "&secret=" + config.APP_SECRET + "&code=" + code + "&grant_type=authorization_code";
        String txt = HttpUtil.get((String)url).getText();
        log.warn("[get auth info][txt:{}]", (Object)txt);
        result = (WechatAuthInfo)BeanUtil.json2oject((String)txt, WechatAuthInfo.class);
        if (BasicUtil.isNotEmpty((Object)result.getOpenid())) {
            result.setResult(true);
        }
        return result;
    }

    public static WechatUserInfo getUserInfo(WechatConfig config, String openid) {
        WechatUserInfo result = null;
        String url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=" + WechatUtil.getAccessToken(config) + "&openid=" + openid + "&lang=zh_CN";
        String txt = HttpUtil.get((String)url).getText();
        log.warn("[wechar get user info][result:{}]", (Object)txt);
        result = (WechatUserInfo)BeanUtil.json2oject((String)txt, WechatUserInfo.class);
        if (BasicUtil.isNotEmpty((Object)result.getOpenid())) {
            result.setResult(true);
        }
        return result;
    }

    public static void profit() {
    }
}

