/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.wechat.program;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Hashtable;
import org.anyline.entity.DataRow;
import org.anyline.net.HttpUtil;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.FileUtil;
import org.anyline.util.encrypt.AESUtil;
import org.anyline.wechat.program.WechatProgramConfig;
import org.anyline.wechat.util.WechatUtil;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class WechatProgramUtil
extends WechatUtil {
    private WechatProgramConfig config = null;
    private static Hashtable<String, WechatProgramUtil> instances = new Hashtable();
    private static boolean HAS_SECURITY_PROVIDER;

    public static WechatProgramUtil getInstance() {
        return WechatProgramUtil.getInstance("default");
    }

    public WechatProgramUtil(WechatProgramConfig config) {
        this.config = config;
    }

    public WechatProgramUtil(String key, DataRow config) {
        WechatProgramConfig conf;
        this.config = conf = WechatProgramConfig.parse(key, config);
        instances.put(key, this);
    }

    public static WechatProgramUtil reg(String key, DataRow config) {
        WechatProgramConfig conf = WechatProgramConfig.reg(key, config);
        WechatProgramUtil util = new WechatProgramUtil(conf);
        instances.put(key, util);
        return util;
    }

    public static WechatProgramUtil getInstance(String key) {
        WechatProgramConfig config;
        WechatProgramUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key)) && null != (config = WechatProgramConfig.getInstance(key))) {
            util = new WechatProgramUtil(config);
            instances.put(key, util);
        }
        return util;
    }

    public WechatProgramConfig getConfig() {
        return this.config;
    }

    public String sessionKey(String code) {
        DataRow session = this.jscode2session(code);
        return session.getString(new String[]{"session_key"});
    }

    public String openid(String code) {
        DataRow session = this.jscode2session(code);
        return session.getString(new String[]{"openid"});
    }

    public String unionid(String code) {
        DataRow session = this.jscode2session(code);
        return session.getString(new String[]{"unionid"});
    }

    public DataRow jscode2session(String code) {
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid=" + this.config.APP_ID + "&secret=" + this.config.APP_SECRET + "&js_code=" + code + "&grant_type=authorization_code";
        String json = HttpUtil.get((String)url).getText();
        DataRow session = DataRow.parseJson((String)json);
        if (session.isEmpty("session_key")) {
            log.warn("[jscode2session][result:fail][json:{}]", (Object)json);
        }
        return session;
    }

    public String getAccessToken() {
        return WechatProgramUtil.getAccessToken(this.config);
    }

    public InputStream createQRCode(String path, int width) throws Exception {
        String access_token = WechatProgramUtil.getAccessToken(this.config);
        String url = "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=" + access_token;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("path", path);
        if (width > 0) {
            params.put("width", width);
        }
        String json = BeanUtil.map2json(params);
        InputStream is = HttpUtil.stream((String)url, (String)"UTF-8", (HttpEntity)new StringEntity(json, "UTF-8")).getInputStream();
        return is;
    }

    public boolean createQRCode(String path, int width, File file) {
        try {
            InputStream is = this.createQRCode(path, width);
            FileUtil.write((InputStream)is, (File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createQRCode(String path, int width, OutputStream os) {
        try {
            InputStream is = this.createQRCode(path, width);
            FileUtil.write((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createQRCode(String path, File file) {
        return this.createQRCode(path, 0, file);
    }

    public boolean createQRCode(String path, OutputStream os) {
        return this.createQRCode(path, 0, os);
    }

    public InputStream createQRCode(String path) throws Exception {
        return this.createQRCode(path, 0);
    }

    public InputStream createWXCode(String path, int width, boolean autoColor, String color, boolean hyaline) {
        String access_token = WechatProgramUtil.getAccessToken(this.config);
        String url = "https://api.weixin.qq.com/wxa/getwxacode?access_token=" + access_token;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("path", path);
        if (width > 0) {
            params.put("width", width);
        }
        params.put("auto_color", autoColor);
        if (BasicUtil.isNotEmpty((Object)color)) {
            params.put("line_color", color);
        }
        params.put("is_hyaline", hyaline);
        String json = BeanUtil.map2json(params);
        InputStream is = HttpUtil.stream((String)url, (String)"UTF-8", (HttpEntity)new StringEntity(json, "UTF-8")).getInputStream();
        return is;
    }

    public boolean createWXCode(String path, int width, boolean autoColor, String color, boolean hyaline, File file) {
        try {
            InputStream is = this.createWXCode(path, width, autoColor, color, hyaline);
            FileUtil.write((InputStream)is, (File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createWXCode(String path, int width, boolean autoColor, String color, boolean hyaline, OutputStream os) {
        try {
            InputStream is = this.createWXCode(path, width, autoColor, color, hyaline);
            FileUtil.write((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createWXCode(String path, File file) {
        return this.createWXCode(path, 0, true, null, false, file);
    }

    public boolean createWXCode(String path, OutputStream os) {
        return this.createWXCode(path, 0, true, null, false, os);
    }

    public InputStream createWXCodeUnlimit(String path, String scene, int width, boolean autoColor, String color, boolean hyaline) {
        String access_token = WechatProgramUtil.getAccessToken(this.config);
        String url = "https://api.weixin.qq.com/wxa/getwxacode?access_token=" + access_token;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("path", path);
        if (width > 0) {
            params.put("width", width);
        }
        params.put("auto_color", autoColor);
        if (BasicUtil.isNotEmpty((Object)scene)) {
            params.put("scene", scene);
        }
        if (BasicUtil.isNotEmpty((Object)color)) {
            params.put("line_color", color);
        }
        params.put("is_hyaline", hyaline);
        String json = BeanUtil.map2json(params);
        InputStream is = HttpUtil.stream((String)url, (String)"UTF-8", (HttpEntity)new StringEntity(json, "UTF-8")).getInputStream();
        return is;
    }

    public boolean createWXCodeUnlimit(String path, String scene, int width, boolean autoColor, String color, boolean hyaline, File file) {
        try {
            InputStream is = this.createWXCodeUnlimit(path, scene, width, autoColor, color, hyaline);
            FileUtil.write((InputStream)is, (File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createWXCodeUnlimit(String path, String scene, int width, boolean autoColor, String color, boolean hyaline, OutputStream os) {
        try {
            InputStream is = this.createWXCodeUnlimit(path, scene, width, autoColor, color, hyaline);
            FileUtil.write((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createWXCodeUnlimit(String path, String scene, File file) {
        return this.createWXCodeUnlimit(path, scene, 0, true, null, false, file);
    }

    public boolean createWXCodeUnlimit(String path, String scene, OutputStream os) {
        return this.createWXCodeUnlimit(path, scene, 0, true, null, false, os);
    }

    public static String decrypt(String session, String vector, String data) {
        if (!HAS_SECURITY_PROVIDER) {
            HAS_SECURITY_PROVIDER = true;
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        return AESUtil.decrypt((AESUtil.CIPHER)AESUtil.CIPHER.PKCS7, (String)session, (String)vector, (String)data);
    }

    static {
        Hashtable<String, AnylineConfig> configs = WechatProgramConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, WechatProgramUtil.getInstance(key));
        }
        HAS_SECURITY_PROVIDER = false;
    }
}

