/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.wechat.pay.util.v3;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.anyline.entity.DataRow;
import org.anyline.net.HttpResponse;
import org.anyline.net.HttpUtil;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.wechat.entity.WechatEnterpriseTransfer;
import org.anyline.wechat.entity.WechatEnterpriseTransferResult;
import org.anyline.wechat.entity.WechatPrePayResult;
import org.anyline.wechat.entity.WechatRefund;
import org.anyline.wechat.entity.WechatRefundResult;
import org.anyline.wechat.entity.v3.WechatPrePayOrder;
import org.anyline.wechat.pay.util.WechatPayConfig;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatPayUtil {
    protected static final Logger log = LoggerFactory.getLogger(WechatPayUtil.class);
    private WechatPayConfig config = null;
    private static Hashtable<String, WechatPayUtil> instances = new Hashtable();
    static final int KEY_LENGTH_BYTE = 32;
    static final int TAG_LENGTH_BIT = 128;

    public static Hashtable<String, WechatPayUtil> getInstances() {
        return instances;
    }

    public static WechatPayUtil getInstance() {
        return WechatPayUtil.getInstance("default");
    }

    public WechatPayUtil(WechatPayConfig config) {
        this.config = config;
    }

    public WechatPayUtil(String key, DataRow config) {
        WechatPayConfig conf;
        this.config = conf = WechatPayConfig.parse(key, config);
        instances.put(key, this);
    }

    public static WechatPayUtil reg(String key, DataRow config) {
        WechatPayConfig conf = WechatPayConfig.register(key, config);
        WechatPayUtil util = new WechatPayUtil(conf);
        instances.put(key, util);
        return util;
    }

    public static WechatPayUtil getInstance(String key) {
        WechatPayUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key))) {
            WechatPayConfig config = WechatPayConfig.getInstance(key);
            util = new WechatPayUtil(config);
            instances.put(key, util);
        }
        return util;
    }

    public WechatPayConfig getConfig() {
        return this.config;
    }

    public WechatPrePayResult unifiedorder(WechatPayConfig.TRADE_TYPE type, WechatPrePayOrder order) {
        return this.transactions(type, order);
    }

    public WechatPrePayResult transactions(WechatPayConfig.TRADE_TYPE type, WechatPrePayOrder order) {
        WechatPrePayResult result = new WechatPrePayResult();
        if (BasicUtil.isEmpty((Object)order.getMchid())) {
            order.setMchid(this.config.MCH_ID);
        }
        if (BasicUtil.isEmpty((Object)order.getNotify_url())) {
            order.setNotify_url(this.config.NOTIFY_URL);
        }
        String url = "https://api.mch.weixin.qq.com/v3/pay/transactions/" + type.getApi();
        DataRow row = this.api(url, BeanUtil.object2json((Object)order));
        result.setPrepay_id(row.getString(new String[]{"PREPAY_ID"}));
        result.setAppid(order.getAppid());
        result.setRequest_id(row.getString(new String[]{"REQUEST_ID"}));
        result.setRequest_status(row.getString(new String[]{"REQUEST_STATUS"}));
        return result;
    }

    public DataRow callUpParam(String appid, String prepayid) {
        String timestamp = System.currentTimeMillis() / 1000L + "";
        String random = BasicUtil.getRandomUpperString((int)32);
        String pkg = "prepay_id=" + prepayid;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("package", pkg);
        params.put("timeStamp", timestamp);
        params.put("appId", appid);
        params.put("nonceStr", random);
        params.put("signType", "RSA");
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(appid).append("\n");
            builder.append(timestamp).append("\n");
            builder.append(random).append("\n");
            builder.append(pkg).append("\n");
            String sign = this.sign(builder.toString().getBytes("UTF-8"));
            params.put("paySign", sign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DataRow row = new DataRow(params);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.warn("[jsapi\u8c03\u8d77\u5fae\u4fe1\u652f\u4ed8][\u53c2\u6570:{}]", (Object)row.toJSON());
        }
        return row;
    }

    public WechatRefundResult refund(WechatRefund refund) throws Exception {
        return null;
    }

    public WechatEnterpriseTransferResult transfer(WechatEnterpriseTransfer transfer) {
        return null;
    }

    private DataRow api(String url, String json) {
        DataRow row = new DataRow();
        try {
            String authorization = "WECHATPAY2-SHA256-RSA2048 " + this.authorization("POST", url.replace("https://api.mch.weixin.qq.com", ""), json);
            Map headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("Accept", "application/json");
            headers.put("Authorization", authorization);
            HttpResponse http = HttpUtil.post(headers, (String)url, (String)"UTF-8", (HttpEntity)new StringEntity(json, "UTF-8"));
            headers = http.getHeaders();
            String requestId = (String)headers.get("Request-ID");
            String txt = http.getText();
            log.warn("[api request][url:{}][text:{}]", (Object)url, (Object)txt);
            row = DataRow.parseJson((String)txt);
            row.put("REQUEST_ID", (Object)requestId);
            row.put("REQUEST_STATUS", (Object)http.getStatus());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row;
    }

    private String authorization(String method, String url, String body) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = BasicUtil.getRandomUpperString((int)32);
        String message = method + "\n" + url + "\n" + timestamp + "\n" + nonce + "\n" + body + "\n";
        String signature = this.sign(message.getBytes("utf-8"));
        return "mchid=\"" + this.config.MCH_ID + "\"," + "nonce_str=\"" + nonce + "\"," + "timestamp=\"" + timestamp + "\"," + "serial_no=\"" + this.config.CERTIFICATE_SERIAL + "\"," + "signature=\"" + signature + "\"";
    }

    public String sign(byte[] message) throws Exception {
        String result = null;
        try {
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initSign(this.getPrivateKey(this.config.MCH_PRIVATE_SECRET_FILE));
            sign.update(message);
            result = Base64.getEncoder().encodeToString(sign.sign());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean verifySign() {
        boolean result = false;
        return result;
    }

    public PrivateKey getPrivateKey(String path) throws IOException {
        log.warn("[get private key][file path:{}]", (Object)path);
        String content = new String(Files.readAllBytes(Paths.get(path, new String[0])), "utf-8");
        try {
            String privateKey = content.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5bc6\u94a5\u683c\u5f0f");
        }
    }

    public String decrypt(String associated, String nonce, String ciphertext) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec key = new SecretKeySpec(this.config.API_SECRET3.getBytes("UTF-8"), "AES");
        GCMParameterSpec spec = new GCMParameterSpec(128, nonce.getBytes("UTF-8"));
        cipher.init(2, (Key)key, spec);
        cipher.updateAAD(associated.getBytes("UTF-8"));
        return new String(cipher.doFinal(Base64.getDecoder().decode(ciphertext)), "utf-8");
    }

    static {
        Hashtable<String, AnylineConfig> configs = WechatPayConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, WechatPayUtil.getInstance(key));
        }
    }
}

