/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.wechat.mp.util;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.net.HttpUtil;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SHA1Util;
import org.anyline.wechat.entity.WechatAuthInfo;
import org.anyline.wechat.entity.WechatTemplateMessage;
import org.anyline.wechat.entity.WechatTemplateMessageResult;
import org.anyline.wechat.entity.WechatUserInfo;
import org.anyline.wechat.mp.entity.Menu;
import org.anyline.wechat.mp.util.WechatMPConfig;
import org.anyline.wechat.util.WechatConfig;
import org.anyline.wechat.util.WechatUtil;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;

public class WechatMPUtil
extends WechatUtil {
    private static DataSet jsapiTickets = new DataSet();
    private WechatMPConfig config = null;
    private static Hashtable<String, WechatMPUtil> instances = new Hashtable();

    public static WechatMPUtil getInstance() {
        return WechatMPUtil.getInstance("default");
    }

    public WechatMPUtil(WechatMPConfig config) {
        this.config = config;
    }

    public WechatMPUtil(String key, DataRow config) {
        WechatMPConfig conf;
        this.config = conf = WechatMPConfig.parse(key, config);
        instances.put(key, this);
    }

    public static WechatMPUtil reg(String key, DataRow config) {
        WechatMPConfig conf = WechatMPConfig.register(key, config);
        WechatMPUtil util = new WechatMPUtil(conf);
        instances.put(key, util);
        return util;
    }

    public static WechatMPUtil getInstance(String key) {
        WechatMPConfig config;
        WechatMPUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key)) && null != (config = WechatMPConfig.getInstance(key))) {
            util = new WechatMPUtil(config);
            instances.put(key, util);
        }
        return util;
    }

    public WechatMPConfig getConfig() {
        return this.config;
    }

    public String getAccessToken() {
        return WechatUtil.getAccessToken(this.config);
    }

    public String getJsapiTicket() {
        String result = "";
        DataRow row = jsapiTickets.getRow(new String[]{"APP_ID", this.config.APP_ID});
        if (null == row) {
            String accessToken = this.getAccessToken();
            row = this.newJsapiTicket(accessToken);
        } else if (row.isExpire()) {
            jsapiTickets.remove((Object)row);
            String accessToken = this.getAccessToken();
            row = this.newJsapiTicket(accessToken);
        }
        if (null != row) {
            result = row.getString("TICKET");
        }
        return result;
    }

    public DataRow newJsapiTicket(String accessToken) {
        DataRow row = new DataRow();
        if (ConfigTable.isDebug() && log.isWarnEnabled()) {
            log.warn("[CREATE NEW JSAPI TICKET][token:{}]", (Object)accessToken);
        }
        if (BasicUtil.isNotEmpty((Object)accessToken)) {
            row.put("APP_ID", (Object)this.config.APP_ID);
            String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + accessToken + "&type=jsapi";
            String text = HttpUtil.get((String)url, (String)"UTF-8").getText();
            log.warn("[CREATE NEW JSAPI TICKET][txt:{}]", (Object)text);
            DataRow json = DataRow.parseJson((String)text);
            if (json.containsKey("ticket")) {
                row.put("TICKET", (Object)json.getString("ticket"));
                row.setExpires(json.getInt("expires_in", 0) * 1000);
                row.setExpires(300000);
                if (ConfigTable.isDebug() && log.isWarnEnabled()) {
                    log.warn("[CREATE NEW JSAPI TICKET][TICKET:{}]", row.get("TICKET"));
                }
            } else {
                log.warn("[CREATE NEW JSAPI TICKET][FAIL]");
                return null;
            }
            jsapiTickets.addRow(row);
        }
        return row;
    }

    public String jsapiSign(Map<String, Object> params) {
        String sign = "";
        sign = BeanUtil.map2string(params);
        sign = SHA1Util.sign((String)sign);
        return sign;
    }

    public Map<String, Object> jsapiSign(String url) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("noncestr", BasicUtil.getRandomLowerString((int)32));
        params.put("jsapi_ticket", this.getJsapiTicket());
        params.put("timestamp", System.currentTimeMillis() / 1000L + "");
        params.put("url", url);
        String sign = this.jsapiSign(params);
        params.put("sign", sign);
        params.put("appid", this.config.APP_ID);
        return params;
    }

    public WechatAuthInfo getAuthInfo(String code) {
        return WechatUtil.getAuthInfo(this.config, code);
    }

    public String getOpenId(String code) {
        WechatAuthInfo info = this.getAuthInfo(code);
        if (null != info && info.isResult()) {
            return info.getOpenid();
        }
        return null;
    }

    public WechatUserInfo getUserInfo(String openid) {
        return WechatUtil.getUserInfo(this.config, openid);
    }

    public String getUnionId(String openid) {
        WechatUserInfo info = this.getUserInfo(openid);
        if (null != info && info.isResult()) {
            return info.getUnionid();
        }
        return null;
    }

    public boolean isSubscribe(String openid) {
        WechatUserInfo info = this.getUserInfo(openid);
        if (null == info) {
            return false;
        }
        return "1".equals(info.getSubscribe());
    }

    public static String ceateAuthUrl(String key, String redirect, WechatConfig.SNSAPI_SCOPE scope, String state) {
        String url = null;
        try {
            WechatMPConfig config = WechatMPConfig.getInstance(key);
            String appid = config.APP_ID;
            if (BasicUtil.isEmpty((Object)((Object)scope))) {
                scope = WechatConfig.SNSAPI_SCOPE.BASE;
            }
            if (BasicUtil.isEmpty((Object)redirect)) {
                redirect = config.OAUTH_REDIRECT_URL;
            }
            if (BasicUtil.isEmpty((Object)redirect)) {
                redirect = WechatMPConfig.getInstance().OAUTH_REDIRECT_URL;
            }
            redirect = URLEncoder.encode(redirect, "UTF-8");
            url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + appid + "&redirect_uri=" + redirect + "&response_type=code&scope=" + scope.getCode() + "&state=" + state + ",app:" + key + "#wechat_redirect";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return url;
    }

    public WechatTemplateMessageResult sendTemplateMessage(WechatTemplateMessage msg) {
        WechatTemplateMessageResult result = null;
        String token = this.getAccessToken();
        String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + token;
        if (null != msg) {
            String json = BeanUtil.object2json((Object)msg);
            log.warn("[send template message][data:{}]", (Object)json);
            StringEntity entity = new StringEntity(json, "UTF-8");
            String txt = HttpUtil.post((String)url, (String)"UTF-8", (HttpEntity)entity).getText();
            log.warn("[send template message][result:{}]", (Object)txt);
            result = (WechatTemplateMessageResult)BeanUtil.json2oject((String)txt, WechatTemplateMessageResult.class);
        }
        return result;
    }

    public WechatTemplateMessageResult sendTemplateMessage(String openId, WechatTemplateMessage msg) {
        if (null != msg) {
            msg.setUser(openId);
        }
        return this.sendTemplateMessage(msg);
    }

    public DataRow createQrCode(String code) {
        String token = this.getAccessToken();
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" + token;
        HashMap params = new HashMap();
        String param = "{\"action_name\": \"QR_LIMIT_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"" + code + "\"}}}";
        String result = HttpUtil.post((String)url, (String)"UTF-8", (HttpEntity)new StringEntity(param, "UTF-8")).getText();
        return DataRow.parseJson((String)result);
    }

    public DataRow createQrCode(String code, int sec) {
        String token = this.getAccessToken();
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" + token;
        HashMap params = new HashMap();
        String param = "{\"expire_seconds\":" + sec + ", \"action_name\": \"QR_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"" + code + "\"}}}";
        String result = HttpUtil.post((String)url, (String)"UTF-8", (HttpEntity)new StringEntity(param, "UTF-8")).getText();
        return DataRow.parseJson((String)result);
    }

    public DataRow addUserTag(List<String> users, int tag) {
        String token = this.getAccessToken();
        String url = "https://api.weixin.qq.com/cgi-bin/tags/members/batchuntagging?access_token=" + token;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("openid_list", users);
        params.put("tagid", tag);
        String result = HttpUtil.post((String)url, (String)"UTF-8", (HttpEntity)new StringEntity(BeanUtil.map2json(params), "UTF-8")).getText();
        return DataRow.parseJson((String)result);
    }

    public String createMenu(Menu menu) {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/addconditional?access_token=" + this.getAccessToken();
        if (null == menu.getMatchrule()) {
            url = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=" + this.getAccessToken();
        }
        String result = HttpUtil.post((String)url, (String)"UTF-8", (HttpEntity)new StringEntity(menu.toJson(), "UTF-8")).getText();
        DataRow row = DataRow.parse((Object)result, (String[])new String[0]);
        String id = row.getString("menuid");
        menu.setMenuid(id);
        return id;
    }

    public DataRow deleteMenu() {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=" + this.getAccessToken();
        String result = HttpUtil.get((String)url).getText();
        DataRow row = DataRow.parse((Object)result, (String[])new String[0]);
        return row;
    }

    public DataRow deleteMenu(String menu) {
        String param = "{\"menuid\":\"" + menu + "\"}";
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delconditional?access_token=" + this.getAccessToken();
        String result = HttpUtil.post((String)url, (String)"UTF-8", (HttpEntity)new StringEntity(param, "UTF-8")).getText();
        DataRow row = DataRow.parse((Object)result, (String[])new String[0]);
        return row;
    }

    public DataRow getMenu() {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=" + this.getAccessToken();
        String result = HttpUtil.get((String)url).getText();
        DataRow row = DataRow.parseJson((String)result);
        return row;
    }

    static {
        Hashtable<String, AnylineConfig> configs = WechatMPConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, WechatMPUtil.getInstance(key));
        }
    }
}

