/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.wechat.wap.util;

import java.util.Hashtable;
import org.anyline.entity.DataRow;
import org.anyline.util.BasicUtil;
import org.anyline.wechat.entity.WechatAuthInfo;
import org.anyline.wechat.entity.WechatUserInfo;
import org.anyline.wechat.util.WechatUtil;
import org.anyline.wechat.wap.util.WechatWapConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatWapUtil {
    private static final Logger log = LoggerFactory.getLogger(WechatWapUtil.class);
    private static Hashtable<String, WechatWapUtil> instances = new Hashtable();
    private WechatWapConfig config;

    public WechatWapUtil(WechatWapConfig config) {
        this.config = config;
    }

    public WechatWapUtil(String key, DataRow config) {
        WechatWapConfig conf;
        this.config = conf = WechatWapConfig.parse(key, config);
        instances.put(key, this);
    }

    public static WechatWapUtil getInstance() {
        return WechatWapUtil.getInstance("default");
    }

    public static WechatWapUtil getInstance(String key) {
        WechatWapConfig config;
        WechatWapUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key)) && null != (config = WechatWapConfig.getInstance(key))) {
            util = new WechatWapUtil(config);
            instances.put(key, util);
        }
        return util;
    }

    public WechatWapConfig getConfig() {
        return this.config;
    }

    public WechatAuthInfo getAuthInfo(String code) {
        return WechatUtil.getAuthInfo(this.config, code);
    }

    public String getOpenId(String code) {
        WechatAuthInfo info = this.getAuthInfo(code);
        if (null != info && info.isResult()) {
            return info.getOpenid();
        }
        return null;
    }

    public WechatUserInfo getUserInfo(String openid) {
        return WechatUtil.getUserInfo(this.config, openid);
    }

    public String getUnionId(String openid) {
        WechatUserInfo info = this.getUserInfo(openid);
        if (null != info && info.isResult()) {
            return info.getUnionid();
        }
        return null;
    }
}

