/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.wechat.open.util;

import java.util.Hashtable;
import org.anyline.entity.DataRow;
import org.anyline.util.BasicUtil;
import org.anyline.wechat.entity.WechatAuthInfo;
import org.anyline.wechat.entity.WechatUserInfo;
import org.anyline.wechat.open.util.WechatOpenConfig;
import org.anyline.wechat.util.WechatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatOpenUtil {
    private static final Logger log = LoggerFactory.getLogger(WechatOpenUtil.class);
    private static Hashtable<String, WechatOpenUtil> instances = new Hashtable();
    private WechatOpenConfig config;

    public WechatOpenUtil(WechatOpenConfig config) {
        this.config = config;
    }

    public WechatOpenUtil(String key, DataRow config) {
        WechatOpenConfig conf;
        this.config = conf = WechatOpenConfig.parse(key, config);
        instances.put(key, this);
    }

    public static WechatOpenUtil reg(String key, DataRow config) {
        WechatOpenConfig conf = WechatOpenConfig.parse(key, config);
        WechatOpenUtil util = new WechatOpenUtil(conf);
        instances.put(key, util);
        return util;
    }

    public static WechatOpenUtil getInstance() {
        return WechatOpenUtil.getInstance("default");
    }

    public static WechatOpenUtil getInstance(String key) {
        WechatOpenConfig config;
        WechatOpenUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key)) && null != (config = WechatOpenConfig.getInstance(key))) {
            util = new WechatOpenUtil(config);
            instances.put(key, util);
        }
        return util;
    }

    public WechatOpenConfig getConfig() {
        return this.config;
    }

    public WechatAuthInfo getAuthInfo(String code) {
        return WechatUtil.getAuthInfo(this.config, code);
    }

    public String getOpenId(String code) {
        WechatAuthInfo info = this.getAuthInfo(code);
        if (null != info && info.isResult()) {
            return info.getOpenid();
        }
        return null;
    }

    public WechatUserInfo getUserInfo(String openid) {
        return WechatUtil.getUserInfo(this.config, openid);
    }

    public String getUnionId(String openid) {
        WechatUserInfo info = this.getUserInfo(openid);
        if (null != info && info.isResult()) {
            return info.getUnionid();
        }
        return null;
    }
}

