/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.sms.util;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.anyline.net.HttpUtil;
import org.anyline.sms.entity.SMSResult;
import org.anyline.sms.util.SMSConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSClient {
    private static final Logger log = LoggerFactory.getLogger(SMSClient.class);
    private SMSConfig config = null;
    private static Hashtable<String, SMSClient> instances = new Hashtable();

    public static SMSClient getInstance() {
        return SMSClient.getInstance("default");
    }

    public static SMSClient getInstance(String key) {
        SMSClient client;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (client = instances.get(key))) {
            SMSConfig config;
            client = new SMSClient();
            client.config = config = SMSConfig.getInstance(key);
            instances.put(key, client);
        }
        return client;
    }

    public SMSResult send(String platform, String tenant, String sign, String template, String mobile, Map<String, String> params) {
        SMSResult result = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("a", this.config.APP_KEY);
            map.put("k", this.config.APP_SECRET);
            map.put("s", sign);
            map.put("t", template);
            map.put("tt", BasicUtil.nvl((Object[])new String[]{tenant, this.config.TENANT_CODE}));
            map.put("pl", BasicUtil.nvl((Object[])new String[]{platform, this.config.PLATFORM_CODE}));
            map.put("m", mobile);
            map.put("p", BeanUtil.map2json(params));
            String txt = HttpUtil.post((String)this.config.SERVER_HOST, (String)"UTF-8", map).getText();
            result = (SMSResult)BeanUtil.json2oject((String)txt, SMSResult.class);
            if (ConfigTable.isDebug() && log.isWarnEnabled()) {
                log.warn("[SMS SEND][mobile:{}][result:{}]", (Object)mobile, (Object)txt);
            }
        }
        catch (Exception e) {
            result = new SMSResult();
            result.setMsg(e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    public SMSResult send(String sign, String template, String mobile, Map<String, String> params) {
        return this.send(null, null, sign, template, mobile, params);
    }

    public SMSResult send(String sign, String template, List<String> mobiles, Map<String, String> params) {
        String mobile = "";
        for (String item : mobiles) {
            if ("".equals(mobile)) {
                mobile = item;
                continue;
            }
            mobile = mobile + "," + item;
        }
        return this.send(sign, template, mobile, params);
    }

    public SMSResult send(String template, String mobile, Map<String, String> params) {
        return this.send(this.config.SIGN, template, mobile, params);
    }

    public SMSResult send(String template, List<String> mobile, Map<String, String> params) {
        return this.send(this.config.SIGN, template, mobile, params);
    }
}

